//
//  PPDateTextFieldTableViewCell.h
//
//  Created by Howard.Lin on 13/10/11.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTextFieldTableViewCell.h"

@class PPDateTextFieldTableViewCell;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPDateTextFieldTableViewCell : PPTextFieldTableViewCell


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,readonly) UIDatePicker *datePicker;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method For Inheriting

/**
 * To detect datePicker'text changed
 */
- (void)datePickerValueChanged:(id)object;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To set datePicker maximumDate
 * @param isBirthday If isBirthDay is YES, The maximumDate is today
 */
- (void)datePickerMaximumDateShowWithBirthDay:(BOOL)isBirthday;


/**
 * To set datePicker date
 * @param dateString The dateString comes from NSDate to NSString
 */
- (void)setDatePickerDateWithDateString:(NSString *)dateString format:(NSString *)format;


/**
 *  cell reuse
 * 使用時機: cell 回收後，將 datePicker 更新, 防止鍵盤切換時產生 crash
 */
- (void)reuse;

@end
