//
//  PPSystemInfoController.h
//  
//
//  Created by Mike on 13/5/13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

#ifdef __IPHONE_OS_VERSION_MIN_REQUIRED

#import <UIKit/UIKit.h>

#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

//目前共33種語言
typedef NS_ENUM(NSInteger, PPSystemInfoLanguage)
{
	PPSystemInfoLanguage_English = 0,			// 英文              English
	PPSystemInfoLanguage_ChineseTraditional,	// 繁體中文			繁體中文
	PPSystemInfoLanguage_Korean,				// 韓文				한국어
	PPSystemInfoLanguage_Japanese,				// 日本語				日本語
	PPSystemInfoLanguage_Spanish,				// 西班牙文			Español
	PPSystemInfoLanguage_German,				// 德文				Deutsch
	PPSystemInfoLanguage_Portuguese,			// 葡萄牙文    		português
	PPSystemInfoLanguage_Italian,				// 義大利文			Italiano
	PPSystemInfoLanguage_ChineseSimplified,		// 簡體中文			简体中文
	PPSystemInfoLanguage_Dutch,					// 荷蘭文				Nederlands
	PPSystemInfoLanguage_French,				// 法文				Français
	PPSystemInfoLanguage_Danish,				// 丹麥文				Dansk
	PPSystemInfoLanguage_Finnish,				// 芬蘭文				Suomi
	PPSystemInfoLanguage_Norwegian,				// 挪威文				Norsk_bokmål)
	PPSystemInfoLanguage_Swedish,				// 瑞典文				Svenska
	PPSystemInfoLanguage_Russian,				// 俄文				Русский
	PPSystemInfoLanguage_Polish,				// 波蘭文				Polski
	PPSystemInfoLanguage_Turkish,				// 土耳其文			Türkçe
	PPSystemInfoLanguage_Ukrainian,				// 烏克蘭文			Українська
	PPSystemInfoLanguage_Arabic,				// 阿拉伯文			العربية
	PPSystemInfoLanguage_Croatian,				// 克羅埃西亞文		Hrvatski
	PPSystemInfoLanguage_Czech,					// 捷克文				Čeština
	PPSystemInfoLanguage_Greek,					// 希臘文				Ελληνικά
	PPSystemInfoLanguage_Hebrew,				// 希伯來文			עברית
	PPSystemInfoLanguage_Romanian,				// 羅馬尼亞文			Română
	PPSystemInfoLanguage_Slovak,				// 斯洛伐克文			Slovenčina
	PPSystemInfoLanguage_Thai,					// 泰文				ภาษาไทย
	PPSystemInfoLanguage_Indonesian,			// 印尼文				Bahasa Indonesia
	PPSystemInfoLanguage_Malay,					// 馬來文				Bahasa Melayu
	PPSystemInfoLanguage_Catalan,				// 加泰隆文文			Català
	PPSystemInfoLanguage_Hungarian,				// 匈牙利文			Magyar
	PPSystemInfoLanguage_Vietnamese,			// 越南文				Tiếng Việt
    PPSystemInfoLanguage_Hindi,                 // 北印度文          हिन्दी
};

//目前共249種地區格式
typedef NS_ENUM(NSInteger, PPSystemInfoLocale)
{
    PPSystemInfoLocale_BosniaHerzegovina = 0, // 波士尼亞與赫塞哥維納
    PPSystemInfoLocale_Cameroon, // 喀麥隆
    PPSystemInfoLocale_Rwanda, // 盧安達
    PPSystemInfoLocale_Swaziland, // 史瓦濟蘭
    PPSystemInfoLocale_Israel, // 以色列
    PPSystemInfoLocale_PitcairnIslands, // 皮特肯群島
    PPSystemInfoLocale_NorfolkIsland, // 諾福克島
    PPSystemInfoLocale_Tanzania, // 坦尚尼亞
    PPSystemInfoLocale_Taiwan, // 台灣
    PPSystemInfoLocale_Liechtenstein, // 列支敦斯登
    PPSystemInfoLocale_Thailand, // 泰國
    PPSystemInfoLocale_India, // 印度
    PPSystemInfoLocale_CeutaMelilla, // 休達與梅利利亞
    PPSystemInfoLocale_FrenchGuiana, // 法屬圭亞那
    PPSystemInfoLocale_World, // 世界
    PPSystemInfoLocale_Turkey, // 土耳其
    PPSystemInfoLocale_Switzerland, // 瑞士
    PPSystemInfoLocale_Togo, // 多哥
    PPSystemInfoLocale_Nigeria, // 奈及利亞
    PPSystemInfoLocale_Seychelles, // 塞席爾
    PPSystemInfoLocale_Honduras, // 宏都拉斯
    PPSystemInfoLocale_AntiguaBarbuda, // 安地卡及巴布達
    PPSystemInfoLocale_Kazakhstan, // 哈薩克
    PPSystemInfoLocale_Ethiopia, // 衣索比亞
    PPSystemInfoLocale_MacauSARChina, // 中華人民共和國澳門特別行政區
    PPSystemInfoLocale_Belgium, // 比利時
    PPSystemInfoLocale_Cambodia, // 柬埔寨
    PPSystemInfoLocale_MyanmarBurma, // 緬甸
    PPSystemInfoLocale_Mozambique, // 莫三比克
    PPSystemInfoLocale_Ghana, // 迦納
    PPSystemInfoLocale_Ecuador, // 厄瓜多
    PPSystemInfoLocale_UnitedKingdom, // 英國
    PPSystemInfoLocale_Montenegro, // 蒙特內哥羅
    PPSystemInfoLocale_Macedonia, // 馬其頓
    PPSystemInfoLocale_Mauritania, // 茅利塔尼亞
    PPSystemInfoLocale_Bermuda, // 百慕達
    PPSystemInfoLocale_Anguilla, // 安圭拉
    PPSystemInfoLocale_Spain, // 西班牙
    PPSystemInfoLocale_PuertoRico, // 波多黎各
    PPSystemInfoLocale_Mali, // 馬利
    PPSystemInfoLocale_Madagascar, // 馬達加斯加
    PPSystemInfoLocale_TimorLeste, // 東帝汶
    PPSystemInfoLocale_StLucia, // 聖露西亞
    PPSystemInfoLocale_Singapore, // 新加坡
    PPSystemInfoLocale_Latvia, // 拉脫維亞
    PPSystemInfoLocale_UnitedStates, // 美國
    PPSystemInfoLocale_Portugal, // 葡萄牙
    PPSystemInfoLocale_Liberia, // 賴比瑞亞
    PPSystemInfoLocale_Netherlands, // 荷蘭
    PPSystemInfoLocale_Canada, // 加拿大
    PPSystemInfoLocale_Uganda, // 烏干達
    PPSystemInfoLocale_MarshallIslands, // 馬紹爾群島
    PPSystemInfoLocale_Tonga, // 東加
    PPSystemInfoLocale_SouthAfrica, // 南非
    PPSystemInfoLocale_Morocco, // 摩洛哥
    PPSystemInfoLocale_Comoros, // 葛摩
    PPSystemInfoLocale_Albania, // 阿爾巴尼亞
    PPSystemInfoLocale_Benin, // 貝南
    PPSystemInfoLocale_Vanuatu, // 萬那杜
    PPSystemInfoLocale_Germany, // 德國
    PPSystemInfoLocale_CongoKinshasa, // 剛果（金夏沙）
    PPSystemInfoLocale_Reunion, // 留尼旺
    PPSystemInfoLocale_Kenya, // 肯亞
    PPSystemInfoLocale_Greenland, // 格陵蘭
    PPSystemInfoLocale_Tunisia, // 突尼西亞
    PPSystemInfoLocale_Panama, // 巴拿馬
    PPSystemInfoLocale_Poland, // 波蘭
    PPSystemInfoLocale_Niger, // 尼日
    PPSystemInfoLocale_EquatorialGuinea, // 赤道幾內亞
    PPSystemInfoLocale_Guinea, // 幾內亞
    PPSystemInfoLocale_Palau, // 帛琉
    PPSystemInfoLocale_Norway, // 挪威
    PPSystemInfoLocale_Serbia, // 塞爾維亞
    PPSystemInfoLocale_France, // 法國
    PPSystemInfoLocale_Zimbabwe, // 辛巴威
    PPSystemInfoLocale_Bolivia, // 玻利維亞
    PPSystemInfoLocale_Afghanistan, // 阿富汗
    PPSystemInfoLocale_Bahamas, // 巴哈馬
    PPSystemInfoLocale_ChristmasIsland, // 聖誕島
    PPSystemInfoLocale_Zambia, // 尚比亞
    PPSystemInfoLocale_Haiti, // 海地
    PPSystemInfoLocale_Guadeloupe, // 瓜地洛普
    PPSystemInfoLocale_Greece, // 希臘
    PPSystemInfoLocale_Cyprus, // 賽普勒斯
    PPSystemInfoLocale_Guatemala, // 瓜地馬拉
    PPSystemInfoLocale_HongKongSARChina, // 中華人民共和國香港特別行政區
    PPSystemInfoLocale_Uruguay, // 烏拉圭
    PPSystemInfoLocale_Nauru, // 諾魯
    PPSystemInfoLocale_Peru, // 秘魯
    PPSystemInfoLocale_Senegal, // 塞內加爾
    PPSystemInfoLocale_CzechRepublic, // 捷克共和國
    PPSystemInfoLocale_Bhutan, // 不丹
    PPSystemInfoLocale_Jordan, // 約旦
    PPSystemInfoLocale_CentralAfricanRepublic, // 中非共和國
    PPSystemInfoLocale_Chad, // 查德
    PPSystemInfoLocale_Botswana, // 波札那
    PPSystemInfoLocale_AmericanSamoa, // 美屬薩摩亞
    PPSystemInfoLocale_Brunei, // 汶萊
    PPSystemInfoLocale_China, // 中華人民共和國
    PPSystemInfoLocale_Armenia, // 亞美尼亞
    PPSystemInfoLocale_CongoBrazzaville, // 剛果（布拉薩）
    PPSystemInfoLocale_NorthernMarianaIslands, // 北馬里亞納群島
    PPSystemInfoLocale_SaudiArabia, // 沙烏地阿拉伯
    PPSystemInfoLocale_Finland, // 芬蘭
    PPSystemInfoLocale_Libya, // 利比亞
    PPSystemInfoLocale_Austria, // 奧地利
    PPSystemInfoLocale_Namibia, // 納米比亞
    PPSystemInfoLocale_Niue, // 紐埃島
    PPSystemInfoLocale_Philippines, // 菲律賓
    PPSystemInfoLocale_Kiribati, // 吉里巴斯
    PPSystemInfoLocale_Jersey, // 澤西島
    PPSystemInfoLocale_Australia, // 澳洲
    PPSystemInfoLocale_Iran, // 伊朗
    PPSystemInfoLocale_Uzbekistan, // 烏茲別克
    PPSystemInfoLocale_FrenchPolynesia, // 法屬玻里尼西亞
    PPSystemInfoLocale_Italy, // 義大利
    PPSystemInfoLocale_Belize, // 貝里斯
    PPSystemInfoLocale_Kuwait, // 科威特
    PPSystemInfoLocale_GuineaBissau, // 幾內亞比索
    PPSystemInfoLocale_StVincentGrenadines, // 聖文森及格瑞那丁
    PPSystemInfoLocale_Djibouti, // 吉布地
    PPSystemInfoLocale_ElSalvador, // 薩爾瓦多
    PPSystemInfoLocale_Montserrat, // 蒙哲臘
    PPSystemInfoLocale_SaoTomePrincipe, // 聖多美普林西比
    PPSystemInfoLocale_Sudan, // 蘇丹
    PPSystemInfoLocale_Iraq, // 伊拉克
    PPSystemInfoLocale_Malta, // 馬爾他
    PPSystemInfoLocale_Georgia, // 喬治亞共和國
    PPSystemInfoLocale_Suriname, // 蘇利南
    PPSystemInfoLocale_DominicanRepublic, // 多明尼加共和國
    PPSystemInfoLocale_LatinAmerica, // 拉丁美洲
    PPSystemInfoLocale_Mauritius, // 模里西斯
    PPSystemInfoLocale_Estonia, // 愛沙尼亞
    PPSystemInfoLocale_Ireland, // 愛爾蘭
    PPSystemInfoLocale_Chile, // 智利
    PPSystemInfoLocale_CapeVerde, // 維德角
    PPSystemInfoLocale_CotedIvoire, // 象牙海岸
    PPSystemInfoLocale_NewZealand, // 紐西蘭
    PPSystemInfoLocale_Kyrgyzstan, // 吉爾吉斯
    PPSystemInfoLocale_StKittsNevis, // 聖克里斯多福及尼維斯
    PPSystemInfoLocale_SvalbardJanMayen, // 冷岸及央麥恩群島
    PPSystemInfoLocale_Russia, // 俄羅斯
    PPSystemInfoLocale_AlandIslands, // 奧蘭群島
    PPSystemInfoLocale_BritishVirginIslands, // 英屬維京群島
    PPSystemInfoLocale_BurkinaFaso, // 布吉納法索
    PPSystemInfoLocale_Malawi, // 馬拉威
    PPSystemInfoLocale_Lesotho, // 賴索托
    PPSystemInfoLocale_NewCaledonia, // 新喀里多尼亞
    PPSystemInfoLocale_Iceland, // 冰島
    PPSystemInfoLocale_FaroeIslands, // 法羅群島
    PPSystemInfoLocale_Lithuania, // 立陶宛
    PPSystemInfoLocale_Qatar, // 卡達
    PPSystemInfoLocale_Colombia, // 哥倫比亞
    PPSystemInfoLocale_Azerbaijan, // 亞塞拜然
    PPSystemInfoLocale_Burundi, // 蒲隆地
    PPSystemInfoLocale_USVirginIslands, // 美屬維京群島
    PPSystemInfoLocale_Malaysia, // 馬來西亞
    PPSystemInfoLocale_Luxembourg, // 盧森堡
    PPSystemInfoLocale_Syria, // 敘利亞
    PPSystemInfoLocale_Jamaica, // 牙買加
    PPSystemInfoLocale_StPierreMiquelon, // 聖皮埃爾和密克隆群島
    PPSystemInfoLocale_Moldova, // 摩爾多瓦
    PPSystemInfoLocale_IsleofMan, // 曼島
    PPSystemInfoLocale_Nicaragua, // 尼加拉瓜
    PPSystemInfoLocale_SintMaarten, // 荷屬聖馬丁
    PPSystemInfoLocale_TurksCaicosIslands, // 英屬土克凱可群島
    PPSystemInfoLocale_Egypt, // 埃及
    PPSystemInfoLocale_Monaco, // 摩納哥
    PPSystemInfoLocale_CostaRica, // 哥斯大黎加
    PPSystemInfoLocale_WesternSahara, // 西撒哈拉
    PPSystemInfoLocale_Grenada, // 格瑞那達
    PPSystemInfoLocale_StBarthelemy, // 聖巴瑟米
    PPSystemInfoLocale_SolomonIslands, // 索羅門群島
    PPSystemInfoLocale_Pakistan, // 巴基斯坦
    PPSystemInfoLocale_Somalia, // 索馬利亞
    PPSystemInfoLocale_StMartin, // 法屬聖馬丁
    PPSystemInfoLocale_Samoa, // 薩摩亞群島
    PPSystemInfoLocale_Cuba, // 古巴
    PPSystemInfoLocale_Japan, // 日本
    PPSystemInfoLocale_BritishIndianOceanTerritory, // 英屬印度洋領地
    PPSystemInfoLocale_Guernsey, // 根西島
    PPSystemInfoLocale_Angola, // 安哥拉
    PPSystemInfoLocale_Romania, // 羅馬尼亞
    PPSystemInfoLocale_USOutlyingIslands, // 美國本土外小島嶼
    PPSystemInfoLocale_Sweden, // 瑞典
    PPSystemInfoLocale_CaymanIslands, // 開曼群島
    PPSystemInfoLocale_Gibraltar, // 直布羅陀
    PPSystemInfoLocale_Brazil, // 巴西
    PPSystemInfoLocale_Tajikistan, // 塔吉克
    PPSystemInfoLocale_Paraguay, // 巴拉圭
    PPSystemInfoLocale_SouthSudan, // 南蘇丹
    PPSystemInfoLocale_Tokelau, // 托克勞群島
    PPSystemInfoLocale_SriLanka, // 斯里蘭卡
    PPSystemInfoLocale_Algeria, // 阿爾及利亞
    PPSystemInfoLocale_Andorra, // 安道爾
    PPSystemInfoLocale_Argentina, // 阿根廷
    PPSystemInfoLocale_Slovakia, // 斯洛伐克
    PPSystemInfoLocale_StHelena, // 聖赫勒拿島
    PPSystemInfoLocale_Eritrea, // 厄利垂亞
    PPSystemInfoLocale_CaribbeanNetherlands, // 荷蘭加勒比區
    PPSystemInfoLocale_Slovenia, // 斯洛維尼亞
    PPSystemInfoLocale_Gambia, // 甘比亞
    PPSystemInfoLocale_Curacao, // 庫拉索
    PPSystemInfoLocale_Croatia, // 克羅埃西亞
    PPSystemInfoLocale_Fiji, // 斐濟
    PPSystemInfoLocale_Belarus, // 白俄羅斯
    PPSystemInfoLocale_FalklandIslands, // 福克蘭群島
    PPSystemInfoLocale_SierraLeone, // 獅子山共和國
    PPSystemInfoLocale_Bahrain, // 巴林
    PPSystemInfoLocale_Laos, // 寮國
    PPSystemInfoLocale_Nepal, // 尼泊爾
    PPSystemInfoLocale_CanaryIslands, // 加那利群島
    PPSystemInfoLocale_Kosovo, // 科索沃
    PPSystemInfoLocale_Hungary, // 匈牙利
    PPSystemInfoLocale_UnitedArabEmirates, // 阿拉伯聯合大公國
    PPSystemInfoLocale_Micronesia, // 密克羅尼西亞群島
    PPSystemInfoLocale_NorthKorea, // 北韓
    PPSystemInfoLocale_Europe, // 歐洲
    PPSystemInfoLocale_Martinique, // 馬丁尼克島
    PPSystemInfoLocale_Venezuela, // 委內瑞拉
    PPSystemInfoLocale_WallisFutuna, // 瓦利斯和富圖納群島
    PPSystemInfoLocale_Ukraine, // 烏克蘭
    PPSystemInfoLocale_Turkmenistan, // 土庫曼
    PPSystemInfoLocale_Mongolia, // 蒙古
    PPSystemInfoLocale_SouthKorea, // 南韓
    PPSystemInfoLocale_DiegoGarcia, // 迪亞哥加西亞島
    PPSystemInfoLocale_CocosKeelingIslands, // 科科斯（基林）群島
    PPSystemInfoLocale_SanMarino, // 聖馬利諾
    PPSystemInfoLocale_TrinidadTobago, // 千里達及托巴哥
    PPSystemInfoLocale_Oman, // 阿曼王國
    PPSystemInfoLocale_Mexico, // 墨西哥
    PPSystemInfoLocale_Guam, // 關島
    PPSystemInfoLocale_Lebanon, // 黎巴嫩
    PPSystemInfoLocale_Tuvalu, // 吐瓦魯
    PPSystemInfoLocale_Aruba, // 荷屬阿魯巴
    PPSystemInfoLocale_PalestinianTerritories, // 巴勒斯坦自治區
    PPSystemInfoLocale_Barbados, // 巴貝多
    PPSystemInfoLocale_PapuaNewGuinea, // 巴布亞紐幾內亞
    PPSystemInfoLocale_Bangladesh, // 孟加拉
    PPSystemInfoLocale_Denmark, // 丹麥
    PPSystemInfoLocale_Mayotte, // 馬約特
    PPSystemInfoLocale_Yemen, // 葉門
    PPSystemInfoLocale_Indonesia, // 印尼
    PPSystemInfoLocale_Guyana, // 蓋亞那
    PPSystemInfoLocale_Dominica, // 多米尼克
    PPSystemInfoLocale_Gabon, // 加彭
    PPSystemInfoLocale_Vietnam, // 越南
    PPSystemInfoLocale_CookIslands, // 庫克群島
    PPSystemInfoLocale_Bulgaria, // 保加利亞
};



@interface PPSystemInfoController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (PPSystemInfoLanguage)language;
+ (NSString *)stringWithLanguage:(PPSystemInfoLanguage)language;
+ (PPSystemInfoLocale)locale;

// x86_64 Or Arm64
+ (NSString *)cpuArchitectureName;
@end
