//
//  PPSyncActionController.h
//  
//
//  Created by Mike Shih on 11/11/23.
//  Copyright (c) 2011年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPSyncActionModel.h"
#import "PPSyncDataController.h"
#import "PPSyncRecordController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, NSErrorPPSyncActionController_Code)
{
    NSErrorPPSyncActionController_Code_ReportSuspend = NSErrorCustom_Code_UserDefine,   //3
    NSErrorPPSyncActionController_Code_Suspend,
    NSErrorPPSyncActionController_Code_LocalDeleteAllWarnning,
    NSErrorPPSyncActionController_Code_RemoteDeleteAllWarnning,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPSyncActionConflict)
{
    /// 異動時間優先 （以較晚的為主）
	PPSyncActionConflict_ModifiedTimeFirst = 0,
    
    /// 本地動作優先
    PPSyncActionConflict_LocalFirst,
    
    /// 遠端動作優先
    PPSyncActionConflict_RemoteFirst,
    
    /// 刪除動作優先
    PPSyncActionConflict_DeleteFirst,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPSyncActionStep)
{
    PPSyncActionStep_Idle = 0,
    PPSyncActionStep_UpgradeSyncGroupModels,
    PPSyncActionStep_UpgradeSyncCardModels,
    PPSyncActionStep_LocalCopySyncGroupModels,
	PPSyncActionStep_RemoteCopySyncGroupModels,
	PPSyncActionStep_CreateSyncGroupActions,
    PPSyncActionStep_LocalCopySyncCardModels,
	PPSyncActionStep_RemoteCopySyncCardModels,
    PPSyncActionStep_CreateSyncCardActions,
    PPSyncActionStep_ExecuteSyncActions,
    PPSyncActionStep_ExecuteSpecialSyncActions,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPSyncActionController;
@protocol PPSyncActionControllerDelegate <NSObject>
@optional
- (void)ppSyncActionController:(PPSyncActionController *)ppSyncActionController progress:(CGFloat)progress;
- (void)ppSyncActionController:(PPSyncActionController *)ppSyncActionController step:(PPSyncActionStep)step;
- (void)ppSyncActionController:(PPSyncActionController *)ppSyncActionController logMessage:(NSString *)logMessage;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSyncActionController : PPSyncRecordController<PPSyncDataControllerDelegate>
{
@protected
    id<PPSyncActionControllerDelegate>  delegate_;
    BOOL                                cancel_;
    BOOL                                executing_;
    BOOL                                suspended_;
    NSDate                              *startDate_;
    NSMutableArray                      *syncActionModels_;
    NSUInteger                          currentSyncActionIndex_;
    NSUInteger                          localCardCount_;
    NSUInteger                          localGroupCount_;
    NSUInteger                          remoteCardCount_;
    NSUInteger                          remoteGroupCount_;
    NSUInteger                          totalSyncActionCount_;
    NSUInteger                          syncCardVersion_;
    NSUInteger                          syncGroupVersion_;
    PPSyncActionConflict                conflict_;
    PPSyncActionStep                    step_;
    PPSyncActionModel                   *currentSyncActionModel_;
    PPSyncDataController                *localSyncDataController_;
    PPSyncDataController                *remoteSyncDataController_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)             id<PPSyncActionControllerDelegate>  delegate;
@property(nonatomic,readonly,assign)    NSUInteger                          currentSyncActionIndex;
@property(nonatomic,readonly,assign)    NSUInteger                          localCardCount;
@property(nonatomic,readonly,assign)    NSUInteger                          localGroupCount;
@property(nonatomic,readonly,assign)    NSUInteger                          remoteCardCount;
@property(nonatomic,readonly,assign)    NSUInteger                          remoteGroupCount;
@property(nonatomic,readonly,assign)    NSUInteger                          totalSyncActionCount;
@property(nonatomic,assign)             NSUInteger                          syncCardVersion;
@property(nonatomic,assign)             NSUInteger                          syncGroupVersion;
@property(nonatomic,assign)             PPSyncActionConflict                conflict;
@property(nonatomic,readonly,retain)    PPSyncActionModel                   *currentSyncActionModel;
@property(nonatomic,readonly)           PPSyncDataController                *localSyncDataController;
@property(nonatomic,readonly)           PPSyncDataController                *remoteSyncDataController;
@property(nonatomic,assign)             BOOL                                needAddForceUpdate;

@property(atomic,readonly,assign)       PPSyncActionStep                    step;
@property(assign)                       BOOL                hasSkipedAction;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initWithFileName:(NSString *)fileName atPath:(NSString *)path error:(NSError **)error localSyncDataController:(PPSyncDataController *)localSyncDataController remoteSyncDataController:(PPSyncDataController *)remoteSyncDataController;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (BOOL)isExecuting;
- (BOOL)isSuspended;
- (void)cancelActions;
- (BOOL)cleanActionsWithError:(NSError **)error;
- (BOOL)resumeActionsWithError:(NSError **)error;
- (BOOL)suspendActionsWithError:(NSError **)error;
- (BOOL)skipOneOfActionsWithError:(NSError **)error;
- (BOOL)syncWithError:(NSError **)error quickSyncVaildTimeInterval:(NSTimeInterval)quickSyncVaildTimeInterval;

- (NSDate *)lastSyncCompleteStartDate;
- (void)setLastSyncCompleteStartDate:(NSDate *)date;
- (NSDate *)lastSyncActionSuccessDate;
- (void)setLastSyncActionSuccessDate:(NSDate *)date;
- (BOOL)cleanSyncData:(NSError **)error;
- (BOOL)hasSyncData;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

- (void)executeActionSuccess;
- (void)logMessage:(NSString *)logMessage sender:(id)sender;
- (BOOL)shouldRescheduleActionWithError:(NSError *)error;
- (BOOL)shouldRetryActionWithError:(NSError *)error;

@end
