//
//  PPSectionModel.h
//  
//
//  Created by Mike on 13/5/28.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPRowModel.h"

@interface PPSectionModel : NSObject <NSCopying>
{
@protected
    NSMutableArray		*rowModels_;
    NSInteger           section_;
    NSString            *title_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,readonly)   NSMutableArray  *rowModels;
@property(nonatomic,assign)     NSInteger       section;
@property(nonatomic,retain)     NSString        *title;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (NSComparisonResult)compare:(PPSectionModel *)sectionModel;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (PPSectionModel *)sectionModelWithSection:(NSInteger)section title:(NSString *)title rowModels:(NSArray *)rowModels;

@end
