//
//  PPScrollPageController.h
//  Pods
//
//  Created by sanhue on 2016/10/18.
//
//

#import <UIKit/UIKit.h>
#import "PPViewController.h"



@class PPScrollPageController;

////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol PPScrollPageControllerDelegate <NSObject>
@optional

/**
 * 將要顯示哪一個頁面
 * @param scrollPageController 委託者
 * @param index 將要顯示的頁面index
 */
- (void)scrollPageController:(PPScrollPageController *)scrollPageController willShowPageAtIndex:(NSInteger)index;

/**
 * 已經顯示到某個頁面
 * @param scrollPageController 委託者
 * @param index 將要顯示的頁面index
 */
- (void)scrollPageController:(PPScrollPageController *)scrollPageController didShowPageAtIndex:(NSInteger)index;


@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol PPScrollPageControllerDataSource <NSObject>

/**
 * 有幾個頁面要顯示
 * @param scrollPageController 委託者
 */
- (NSInteger)numberOfPageAtController:(PPScrollPageController *)scrollPageController;


/**
 * 依據index回傳該頁的viewController
 * @param scrollPageController 委託者
 * @param index 目前需要回傳的viewController的 index
 */
- (UIViewController *)scrollPageController:(PPScrollPageController *)scrollPageController viewControllerAtIndex:(NSInteger)index;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPScrollPageController : PPViewController


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - property

@property (nonatomic, assign) id<PPScrollPageControllerDelegate> delegate;
@property (nonatomic, assign) id<PPScrollPageControllerDataSource> dataSource;

@property (nonatomic, assign) NSInteger currentPageIndex;

- (UIViewController *)viewControllerAtIndex:(NSInteger)index;

- (void)assignPageToIndex:(NSUInteger)index animated:(BOOL)animated;
@end
