//
//  PPTouchID.h
//  Pods
//
//  Created by sanhue on 2015/9/22.
//
//

#import <Foundation/Foundation.h>


typedef NS_ENUM(NSUInteger, PPTouchIDResponse) {
    PPTouchIDResponse_Unknown,              ///< 未知問題
    PPTouchIDResponse_Success,              ///< 認証成功
    PPTouchIDResponse_UsePasscode,          ///< user按下輸入密碼
    PPTouchIDResponse_ReachMaxRetry,        ///< 驗証失敗超過最大次數，應該用輸入密碼方式解鎖
    PPTouchIDResponse_SystemCanceled,       ///< system cancel
    PPTouchIDResponse_UserCanceled,         ///< user cancel
    PPTouchIDResponse_AlreadyPresent,       ///< 已經顯示
    PPTouchIDResponse_NotSupport,           ///< 不支援，如ios8以下
};

typedef void(^PPTouchIDCompletion)(PPTouchIDResponse response);

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPTouchID : NSObject

/**
 * 顯示TouchID介面
 * @param reason custom reason
 * @param customEnterPasswordTitle 客制化button title, nil: 使用系統預設，@"": 不顯示
 * @param completion block that response when touchid finish
 */
+ (void)showWithReason:(NSString * __nonnull)reason
customEnterPasswordTitle:(NSString * __nullable)customEnterPasswordTitle
            completion:(PPTouchIDCompletion __nullable)completion;

/**
 * 回傳是否可使用touchID
 * @return BOOL yes if supported, else no
 */
+ (BOOL)canUseTouchID;
@end
