//
//  BKPasscodeInputView.h
//  BKPasscodeViewDemo
//
//  Created by Byungkook Jang on 2014. 4. 20..
//  Copyright (c) 2014년 Byungkook Jang. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "PPDigitalPinCodeField.h"
#import "UIView+CustomAnimation.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, PPPincodeViewStyle)
{
    PPPincodeViewStyle_Simple,  ///< 簡易密碼
    PPPincodeViewStyle_Normal,  ///< 複雜密碼
};


////////////////////////////////////////////////////////////////////////////////////////////////////
@class PPPincodeView;
@protocol PPPincodeViewDelegate <NSObject>

/**
 * 通知app, 輸入結束
 * 如果是PPPincodeViewStyle_Number，是在輸入滿最大位數後，
 * 如果是PPPincodeViewStyle_Normal，且是按下done之後
 * @param inputView instance of inputView
 */
- (void)inputViewDidFinish:(PPPincodeView *)inputView;

@end




////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPPincodeView : UIView <UITextFieldDelegate, PPDigitalPinCodeFieldDelegate, NSCopying>

/// delegate
@property (nonatomic, assign) id<PPPincodeViewDelegate> delegate;

/// 指定要使用複雜或是簡易密碼，預設為簡易
@property (nonatomic) PPPincodeViewStyle viewStyle;

/// 設定鍵盤模式
@property (nonatomic) UIKeyboardType     keyboardType;

/// 設定最大密碼長度，簡易密碼預設為4，複雜密碼預設為20
@property (nonatomic) NSUInteger         maximumLength;

/// 提示目前使用者應該做的動作
@property (nonatomic, retain) NSString                  *title;

/// 操作中的訊息
@property (nonatomic, retain) NSString                  *message;

/// 操作中的錯誤訊息
@property (nonatomic, retain) NSString                  *errorMessage;

/// 目前輸入的密碼
@property (nonatomic, retain) NSString                  *pincode;

/// 目前正在使用的textfield
@property (nonatomic, retain, readonly) UIControl       *pincodeField;

@property (nonatomic, getter = isEnabled) BOOL          enabled;

@end

