//
//  PPImageScrollView.h
//  
//
//  Created by Mike on 13/6/7.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPImageScrollViewDefaultMaximumZoomScaleForImageSize 2.0f

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPImageScrollViewImageMode)
{
	PPImageScrollViewImageMode_ScaleAspectFit = 0,  // imageView填滿整個scrollView
	PPImageScrollViewImageMode_ScaleAspectFill,     // 讓scrollView顯現整個imageView的最適大小
    PPImageScrollViewImageMode_ScaleAspectRecessed, // 同Fit，但可設定Inset
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPImageScrollViewScaleBase)
{
	PPImageScrollViewScaleBase_ViewSize = 0,        // 基於View
	PPImageScrollViewScaleBase_ImageSize,           // 基於Image
};





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPImageScrollView()

@interface PPImageScrollView : UIScrollView <UIScrollViewDelegate>





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<UIScrollViewDelegate> proxy;

/**
 *  儲存原始圖片
 */
@property (nonatomic,retain) UIImage *image;

/**
 *  儲存並顯示image的View
 */
@property (nonatomic,readonly) UIImageView *imageView;

/**
 *  接收使用者雙擊觸控操作的Recongnizer
 */
@property (nonatomic,readonly) UITapGestureRecognizer *doubleTapGestureRecognizer;

/**
 *  當imageView顯示模式為Recessed時的Inset
 */
@property (nonatomic,assign) UIEdgeInsets edgeInsetsForRecessed;

/**
 *  設定imageView的顯示模式，
 *  分別為Fill，Fit，Recessed
 */
@property (nonatomic,assign) PPImageScrollViewImageMode imageMode;

/**
 *  設定imageView的縮放基準，分別為相對於原圖大小和相對於imageView大小
 *  scale的值和縮放結果會依此而有所不同
 */
@property (nonatomic,assign) PPImageScrollViewScaleBase scaleBase;

/**
 *  是否允許使用者雙擊放大操作，預設為YES
 */
@property(nonatomic,getter=isDoubleTapGestureEnabled) BOOL doubleTapGestureEnabled;

/**
 *  是否允許變更zoomScale，預設為YES
 *  設為NO則鎖定當前的zoomScale(除非重設image、imageMode或scaleBase)
 */
@property(nonatomic,getter=isZoomEnabled) BOOL zoomEnabled;

/**
 *  設定雙擊放大時的Scale比率，預設為0(未指定)，此時會放大為原圖的一倍大；當有指定值時則以此值做縮放
 *  (當此值為0，且原圖又小於View大小：
 *   若ScaleBase為Image，則改為放大至maximumZoomScale以確保能填滿View，
 *   若ScaleBase為View則不做放大縮小)
 */
@property(nonatomic,assign) float doubleTapZoomScale;

/**
 *  設定原圖大小為基準的最大Scale比率(無論scaleBase為何)，預設為2，即原圖的兩倍大
 *  (但若原圖小於View大小，且ScaleBase為Image，則改為可放大至maximumZoomScale，不受此值限制)
 */
@property(nonatomic,assign) float maximumZoomScaleForImageSize;

/**
 *  當image為nil時需要的imageSize，以使元件行為保持一致
 *  若image不是nil則此值與image.size無異
 */
@property(nonatomic,assign) CGSize preferredImageSize;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

/**
 *  當每次對View參數進行調整時，重新Layout ImageView的位置
 */
- (void)layoutImageView;

/**
 *  將ImageView Scale到特定的Size
 *
 *  @param size 目標Size
 */
- (void)zoomScaleToSize:(CGSize)size;

@end
