//
//  PPGuideFocusModel.h
//  Pods
//
//  Created by eddie on 2015/4/13.
//
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_OPTIONS(NSInteger, PPGuideFocusShape)
{
    PPGuideFocusShape_None = 0,
    PPGuideFocusShape_Circle,
    PPGuideFocusShape_Rectangle,
};

typedef NS_OPTIONS(NSInteger, PPGuideFocusStyle)
{
    PPGuideFocusStyle_None = 0,
    PPGuideFocusStyle_Image,
    PPGuideFocusStyle_View,
    PPGuideFocusStyle_DoubleRing,
    PPGuideFocusStyle_Transparent,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPGuideFocusModel : NSObject

@property (nonatomic, assign, readonly) PPGuideFocusStyle style;
@property (nonatomic, assign, readonly) PPGuideFocusShape shape;
@property (nonatomic, retain, readonly) UIImage *image;
@property (nonatomic, retain, readonly) UIView *view;
@property (nonatomic, assign, readonly) CGRect imageTransparentFrame;
@property (nonatomic, assign, readonly) BOOL canTouchThrough;
@property (nonatomic, assign, readonly) CGSize targetAreaInset;
@property (nonatomic, assign, readonly) CGFloat infoAreaGap;

// for PPGuideFocusStyle_DoubleRing
@property (nonatomic, retain, readonly) UIColor *color;


/**
 * 顯示image及透明focus區域的樣式
 *
 * @param shape                 One of PPGuideFocusShape
 * @param imageName             焦點區域的貼圖影像, nil代表使用預設影像（需加入subspec）
 * @param imageTransparentFrame 影像中透明區域的範圍（用影像座標計算）
 * @param canTouchThrough       透明區域點擊是否可以穿透（點到下方物件）
 * @param targetAreaInset       目標區域的放大或縮小值
 *
 * @return PPGuideFocusModel instance
 */
+ (PPGuideFocusModel *)modelWithGuideFocusShape:(PPGuideFocusShape)shape
                                      imageName:(NSString *)imageName
                          imageTransparentFrame:(CGRect)imageTransparentFrame
                                canTouchThrough:(BOOL)canTouchThrough
                                targetAreaInset:(CGSize)targetAreaInset;


/**
 * 只顯示image的樣式
 *
 * @param imageName             影像檔名
 * @param infoAreaGap           目標區域到訊息區域的間距
 *
 * @return PPGuideFocusModel instance
 */
+ (PPGuideFocusModel *)modelWithImageName:(NSString *)imageName
                              infoAreaGap:(CGFloat)infoAreaGap;


/**
 * 只顯示view的樣式
 *
 * @param customView            自訂顯示view
 * @param infoAreaGap           目標區域到訊息區域的間距
 *
 * @return PPGuideFocusModel instance
 */
+ (PPGuideFocusModel *)modelWithCustomView:(UIView *)customView
                               infoAreaGap:(CGFloat)infoAreaGap;


/**
 * 繪製兩層光暈及透明focus區域的樣式
 *
 * @param color                 主體顏色
 * @param canTouchThrough       透明區域點擊是否可以穿透（點到下方物件）
 * @param targetAreaInset       目標區域的放大或縮小值
 *
 * @return PPGuideFocusModel instance
 */
+ (PPGuideFocusModel *)modelWithDoubleRingStyleColor:(UIColor *)color
                                     canTouchThrough:(BOOL)canTouchThrough
                                     targetAreaInset:(CGSize)targetAreaInset;


/**
 * 只顯示透明focus區域的樣式
 *
 * @param shape                 One of PPGuideFocusShape
 * @param canTouchThrough       透明區域點擊是否可以穿透（點到下方物件）
 * @param targetAreaInset       目標區域的放大或縮小值
 * @param infoAreaGap           目標區域到訊息區域的間距
 *
 * @return PPGuideFocusModel instance
 */
+ (PPGuideFocusModel *)modelWithGuideFocusShape:(PPGuideFocusShape)shape
                                canTouchThrough:(BOOL)canTouchThrough
                                targetAreaInset:(CGSize)targetAreaInset
                                    infoAreaGap:(CGFloat)infoAreaGap;


@end
