//
//  PPFloatingMenuButton.h
//
//  Created by eddie on 2015/6/4.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#import <Foundation/Foundation.h>


////////////////////////////////////////////////////////////////////////////////////////////////////

static const NSInteger PPFloatingMenuButton_ItemNone = -1;

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPFloatingMenuButtonDelegate <NSObject>

@optional

/**
 * Delegate when button was tapped
 *
 * @param button - Tapped PPFloatingMenuButton instance
 * @param identifier - Button identifier, PPFloatingMenuButton_ItemNone means tap nothing.
 */
- (void)floatingMenuButton:(id)button didTapButtonWithIdentifier:(NSInteger)identifier;

/**
 * Delegate when menu item was tapped
 *
 * @param button - Tapped PPFloatingMenuButton instance
 * @param identifier - Item identifier, PPFloatingMenuButton_ItemNone means tap nothing.
 */
- (void)floatingMenuButton:(id)button didTapItemWithIdentifier:(NSInteger)identifier;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPFloatingMenuButton : UIView

/**
 * Text font of menu item.
 */
@property (nonatomic, retain) UIFont *menuItemTextFont;


/**
 * Text color of menu item.
 */
@property (nonatomic, retain) UIColor *menuItemTextColor;


/**
 * Text background color of menu item.
 */
@property (nonatomic, retain) UIColor *menuItemTextBackgroundColor;


/**
 * Text background color of menu item.
 */
@property (nonatomic, assign) CGSize menuItemIconSize;


/**
 * Initialize
 *
 * @param delegate - PPFloatingMenuButtonDelegate
 * @param identifier - Button ID
 * @return PPFloatingMenuButton instance
 */
- (id)initWithDelegate:(id<PPFloatingMenuButtonDelegate>)delegate identifier:(NSInteger)identifier;


/**
 * Set main button background image
 *
 * @param image - UIImage object
 * @param state - UIControlState
 */
- (void)setMainButtonBackgroundImage:(UIImage *)image forState:(UIControlState)state;


/**
 * Add menu items
 *
 * @param identifier - Item ID
 * @param icon - Item icon
 * @param text - Item text
 */
- (void)addMenuItemWithIdentifier:(NSInteger)identifier icon:(UIImage *)icon text:(NSString *)text;


/**
 * Remove menu items
 */
- (void)removeItems;


/**
 * Manually show menu
 */
- (void)showMenu;


/**
 * Manually hide menu
 */
- (void)hideMenu;


/**
 * Check if menu is appear
 *
 * @return YES if menu is hidden
 */
- (BOOL)menuIsHidden;

@end
