//
//  PPCloud+ParameterDefine.h
//  
//
//  Created by Howard on 2016/9/26.
//
//

#ifndef PPCloud_ParameterDefine_h
#define PPCloud_ParameterDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Google Drive Releated Parameter 

#if TARGET_OS_IPHONE

#define GTMOAuth2ViewController GTMOAuth2ViewControllerTouch
#define CPCLViewController UIViewController

#elif TARGET_OS_MAC

#define GTMOAuth2ViewController GTMOAuth2WindowController
#define CPCLViewController NSWindowController

#endif

#endif /* PPCloud_ParameterDefine_h */


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Download Related Parameter

static NSUInteger const PPCloud_DownloadChunkSize = 50*1024*1024; // 50MB





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Error Code


////////////////////////////////////////////////////////////////////////////////////////////////////

/// PPCloud共用錯誤碼
typedef NS_OPTIONS(NSInteger, PPCloudCommonError)
{
    PPCloudCommonError_Unknown = 5000,
    
    /// link failed
    PPCloudCommonError_LinkFailed,
    
    /// login canceled
    PPCloudCommonError_CancelLogin,
    
    /// nothing exist with input path
    PPCloudCommonError_PathNotExist,
    
    /// nothing exist with input path
    PPCloudCommonError_FileIDNotExist,
    
    /// already exist with input path
    PPCloudCommonError_PathAlreadyExist,
    
    /// more then one file/folder with input path
    PPCloudCommonError_MultipleItemsWithSamePath,
    
    /// 超過上傳檔案大小限制
    PPCloudCommonError_OverMaximumUploadFileSize,
    
    // 讀檔失敗
    PPCloudCommonError_ReadChunkFileFail,
    
    // 寫檔失敗
    PPCloudCommonError_WriteFileFail,
    
    // 空間不足
    PPCloudCommonError_SpaceNotEnough,
    
    // 檢查目錄是否存在失敗
    PPCloudCommonError_CheckIfFolderExists,
};

