//
//  PPButtonFactory.h
//  WorldPenScanX
//
//  Created by Egg on 2014/10/8.
//  Copyright (c) 2014年 com.penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPButton.h"

@interface PPButton(Factory)

+ (PPButton *)ppButtonWithFrame:(CGRect)frame
                  IconImageName:(NSString *)iconImageName
                       delegate:(id<PPButtonDelegate>)delegate
                            tag:(NSInteger)tag
                backgroundColor:(UIColor *)backgroundColor;

+ (PPButton *)ppButtonWithImageFrame:(CGRect)imageFrame
                       IconImageName:(NSString *)iconImageName
                            delegate:(id<PPButtonDelegate>)delegate
                                 tag:(NSInteger)tag
                     backgroundColor:(UIColor *)backgroundColor
                               title:(NSString *)title
                          titleColor:(UIColor *)titleColor
                           titleFont:(UIFont *)titleFont
                             spacing:(CGFloat)spacing;

+ (PPButton *)ppButtonWithFrame:(CGRect)frame
                  IconImageName:(NSString *)iconImageName
            backgroundImageName:(NSString *)backgroundImageName
                backgroundColor:(UIColor *)backgroundColor
                    borderColor:(UIColor *)borderColor
                       delegate:(id<PPButtonDelegate>)delegate
                            tag:(NSInteger)tag
                          title:(NSString *)title;

+ (PPButton *)ppButtonWithIconImageName:(NSString *)iconImageName
                                    tag:(NSInteger)tag
                               delegate:(id<PPButtonDelegate>)delegate
                  normalBackgroundColor:(UIColor *)normalBackgroundColor
             highlightedBackgroundColor:(UIColor *)highlightedBackgroundColor
                        imageEdgeInsets:(UIEdgeInsets)imageEdgeInsets;

/**
 *  回傳一個仿系統 < back 鍵的ppButton, 注意delegate 及 tag 要自己設。
 *
 *  @return 仿系統 < back 鍵的ppButton
 */
+ (PPButton *)ppButtonWithSystemBackImitation;

+ (PPButton *)ppButtonWithLayoutType:(PPButtonLayoutType)layoutType
                       iconImageName:(NSString *)iconImageName
                                 tag:(NSInteger)tag
                            delegate:(id<PPButtonDelegate>)delegate
                               title:(NSString *)title
                          titleColor:(UIColor *)titleColor
                           titleFont:(UIFont *)titleFont
;

@end
