//
//  PP3rdPartyLoginView.h
//
//
//  Created by Howard on 2019/6/10.
//

#import <WebKit/WebKit.h>

typedef void (^AuthCompletion) (id object, NSError *returnError);

@interface PP3rdPartyLoginView : WKWebView <WKNavigationDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) NSString *clientID;
@property (nonatomic,retain) NSString *secretID;
@property (nonatomic,copy) AuthCompletion authCompletion;

/// !! 是否開啟重讀判斷，microsoft登入頁面上的back，要用這方式處理, default NO;
/// 開啟時要實作|shouldReloadPageWithRedirectURL:|
@property (nonatomic,assign) BOOL enableShouldReloadPage;




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Inherit Method

- (BOOL)isRedirectURL:(NSString *)requestUrlString;
- (void)handleUserAgentResponse:(NSURL *)url;

/// 以原本的URL重load
- (void)reloadOriginalUrl;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)showAuthFlowFromRequest:(NSURLRequest *)request
                       clientID:(NSString *)clientID
                       secretID:(NSString *)secretID
                     completion:(AuthCompletion)completion;

@end
