///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBUSERSGetAccountBatchArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GetAccountBatchArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBUSERSGetAccountBatchArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// List of user account identifiers.  Should not contain any duplicate account
/// IDs.
@property (nonatomic, readonly) NSArray<NSString *> *accountIds;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param accountIds List of user account identifiers.  Should not contain any
/// duplicate account IDs.
///
/// @return An initialized instance.
///
- (instancetype)initWithAccountIds:(NSArray<NSString *> *)accountIds;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GetAccountBatchArg` struct.
///
@interface DBUSERSGetAccountBatchArgSerializer : NSObject

///
/// Serializes `DBUSERSGetAccountBatchArg` instances.
///
/// @param instance An instance of the `DBUSERSGetAccountBatchArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBUSERSGetAccountBatchArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBUSERSGetAccountBatchArg *)instance;

///
/// Deserializes `DBUSERSGetAccountBatchArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBUSERSGetAccountBatchArg` API object.
///
/// @return An instantiation of the `DBUSERSGetAccountBatchArg` object.
///
+ (DBUSERSGetAccountBatchArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
