///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMUsersSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UsersSelectorArg` union.
///
/// Argument for selecting a list of users, either by team_member_ids,
/// external_ids or emails.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMUsersSelectorArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMUsersSelectorArgTag` enum type represents the possible tag states
/// with which the `DBTEAMUsersSelectorArg` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMUsersSelectorArgTag){
    /// List of member IDs.
    DBTEAMUsersSelectorArgTeamMemberIds,

    /// List of external user IDs.
    DBTEAMUsersSelectorArgExternalIds,

    /// List of email addresses.
    DBTEAMUsersSelectorArgEmails,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMUsersSelectorArgTag tag;

/// List of member IDs. @note Ensure the `isTeamMemberIds` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) NSArray<NSString *> *teamMemberIds;

/// List of external user IDs. @note Ensure the `isExternalIds` method returns
/// true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) NSArray<NSString *> *externalIds;

/// List of email addresses. @note Ensure the `isEmails` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) NSArray<NSString *> *emails;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "team_member_ids".
///
/// Description of the "team_member_ids" tag state: List of member IDs.
///
/// @param teamMemberIds List of member IDs.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMemberIds:(NSArray<NSString *> *)teamMemberIds;

///
/// Initializes union class with tag state of "external_ids".
///
/// Description of the "external_ids" tag state: List of external user IDs.
///
/// @param externalIds List of external user IDs.
///
/// @return An initialized instance.
///
- (instancetype)initWithExternalIds:(NSArray<NSString *> *)externalIds;

///
/// Initializes union class with tag state of "emails".
///
/// Description of the "emails" tag state: List of email addresses.
///
/// @param emails List of email addresses.
///
/// @return An initialized instance.
///
- (instancetype)initWithEmails:(NSArray<NSString *> *)emails;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "team_member_ids".
///
/// @note Call this method and ensure it returns true before accessing the
/// `teamMemberIds` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "team_member_ids".
///
- (BOOL)isTeamMemberIds;

///
/// Retrieves whether the union's current tag state has value "external_ids".
///
/// @note Call this method and ensure it returns true before accessing the
/// `externalIds` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "external_ids".
///
- (BOOL)isExternalIds;

///
/// Retrieves whether the union's current tag state has value "emails".
///
/// @note Call this method and ensure it returns true before accessing the
/// `emails` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "emails".
///
- (BOOL)isEmails;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMUsersSelectorArg` union.
///
@interface DBTEAMUsersSelectorArgSerializer : NSObject

///
/// Serializes `DBTEAMUsersSelectorArg` instances.
///
/// @param instance An instance of the `DBTEAMUsersSelectorArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMUsersSelectorArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMUsersSelectorArg *)instance;

///
/// Deserializes `DBTEAMUsersSelectorArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMUsersSelectorArg` API object.
///
/// @return An instantiation of the `DBTEAMUsersSelectorArg` object.
///
+ (DBTEAMUsersSelectorArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
