///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMUserSelectorError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UserSelectorError` union.
///
/// Error that can be returned whenever a struct derived from UserSelectorArg is
/// used.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMUserSelectorError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMUserSelectorErrorTag` enum type represents the possible tag
/// states with which the `DBTEAMUserSelectorError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMUserSelectorErrorTag){
    /// No matching user found. The provided team_member_id, email, or
    /// external_id does not exist on this team.
    DBTEAMUserSelectorErrorUserNotFound,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMUserSelectorErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "user_not_found".
///
/// Description of the "user_not_found" tag state: No matching user found. The
/// provided team_member_id, email, or external_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserNotFound;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "user_not_found".
///
/// @return Whether the union's current tag state has value "user_not_found".
///
- (BOOL)isUserNotFound;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMUserSelectorError` union.
///
@interface DBTEAMUserSelectorErrorSerializer : NSObject

///
/// Serializes `DBTEAMUserSelectorError` instances.
///
/// @param instance An instance of the `DBTEAMUserSelectorError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMUserSelectorError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMUserSelectorError *)instance;

///
/// Deserializes `DBTEAMUserSelectorError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMUserSelectorError` API object.
///
/// @return An instantiation of the `DBTEAMUserSelectorError` object.
///
+ (DBTEAMUserSelectorError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
