///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMTeamFolderTeamSharedDropboxError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamFolderTeamSharedDropboxError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMTeamFolderTeamSharedDropboxError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMTeamFolderTeamSharedDropboxErrorTag` enum type represents the
/// possible tag states with which the `DBTEAMTeamFolderTeamSharedDropboxError`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMTeamFolderTeamSharedDropboxErrorTag){
    /// This action is not allowed for a shared team root.
    DBTEAMTeamFolderTeamSharedDropboxErrorDisallowed,

    /// (no description).
    DBTEAMTeamFolderTeamSharedDropboxErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMTeamFolderTeamSharedDropboxErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disallowed".
///
/// Description of the "disallowed" tag state: This action is not allowed for a
/// shared team root.
///
/// @return An initialized instance.
///
- (instancetype)initWithDisallowed;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disallowed".
///
/// @return Whether the union's current tag state has value "disallowed".
///
- (BOOL)isDisallowed;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMTeamFolderTeamSharedDropboxError`
/// union.
///
@interface DBTEAMTeamFolderTeamSharedDropboxErrorSerializer : NSObject

///
/// Serializes `DBTEAMTeamFolderTeamSharedDropboxError` instances.
///
/// @param instance An instance of the `DBTEAMTeamFolderTeamSharedDropboxError`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderTeamSharedDropboxError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderTeamSharedDropboxError *)instance;

///
/// Deserializes `DBTEAMTeamFolderTeamSharedDropboxError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderTeamSharedDropboxError` API object.
///
/// @return An instantiation of the `DBTEAMTeamFolderTeamSharedDropboxError`
/// object.
///
+ (DBTEAMTeamFolderTeamSharedDropboxError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
