///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMApiApp;
@class DBTEAMMemberLinkedApps;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberLinkedApps` struct.
///
/// Information on linked applications of a team member.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMemberLinkedApps : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The member unique Id.
@property (nonatomic, readonly, copy) NSString *teamMemberId;

/// List of third party applications linked by this team member.
@property (nonatomic, readonly) NSArray<DBTEAMApiApp *> *linkedApiApps;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param teamMemberId The member unique Id.
/// @param linkedApiApps List of third party applications linked by this team
/// member.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId linkedApiApps:(NSArray<DBTEAMApiApp *> *)linkedApiApps;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MemberLinkedApps` struct.
///
@interface DBTEAMMemberLinkedAppsSerializer : NSObject

///
/// Serializes `DBTEAMMemberLinkedApps` instances.
///
/// @param instance An instance of the `DBTEAMMemberLinkedApps` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMemberLinkedApps` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberLinkedApps *)instance;

///
/// Deserializes `DBTEAMMemberLinkedApps` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMemberLinkedApps` API object.
///
/// @return An instantiation of the `DBTEAMMemberLinkedApps` object.
///
+ (DBTEAMMemberLinkedApps *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
