///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDurationLogInfo;
@class DBTEAMLOGWebSessionsFixedLengthPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `WebSessionsFixedLengthPolicy` union.
///
/// Web sessions fixed length policy.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGWebSessionsFixedLengthPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGWebSessionsFixedLengthPolicyTag` enum type represents the
/// possible tag states with which the `DBTEAMLOGWebSessionsFixedLengthPolicy`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGWebSessionsFixedLengthPolicyTag){
    /// Defined fixed session length.
    DBTEAMLOGWebSessionsFixedLengthPolicyDefined,

    /// Undefined fixed session length.
    DBTEAMLOGWebSessionsFixedLengthPolicyUndefined,

    /// (no description).
    DBTEAMLOGWebSessionsFixedLengthPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGWebSessionsFixedLengthPolicyTag tag;

/// Defined fixed session length. @note Ensure the `isDefined` method returns
/// true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGDurationLogInfo *defined;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "defined".
///
/// Description of the "defined" tag state: Defined fixed session length.
///
/// @param defined Defined fixed session length.
///
/// @return An initialized instance.
///
- (instancetype)initWithDefined:(DBTEAMLOGDurationLogInfo *)defined;

///
/// Initializes union class with tag state of "undefined".
///
/// Description of the "undefined" tag state: Undefined fixed session length.
///
/// @return An initialized instance.
///
- (instancetype)initWithUndefined;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "defined".
///
/// @note Call this method and ensure it returns true before accessing the
/// `defined` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "defined".
///
- (BOOL)isDefined;

///
/// Retrieves whether the union's current tag state has value "undefined".
///
/// @return Whether the union's current tag state has value "undefined".
///
- (BOOL)isUndefined;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGWebSessionsFixedLengthPolicy`
/// union.
///
@interface DBTEAMLOGWebSessionsFixedLengthPolicySerializer : NSObject

///
/// Serializes `DBTEAMLOGWebSessionsFixedLengthPolicy` instances.
///
/// @param instance An instance of the `DBTEAMLOGWebSessionsFixedLengthPolicy`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGWebSessionsFixedLengthPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGWebSessionsFixedLengthPolicy *)instance;

///
/// Deserializes `DBTEAMLOGWebSessionsFixedLengthPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGWebSessionsFixedLengthPolicy` API object.
///
/// @return An instantiation of the `DBTEAMLOGWebSessionsFixedLengthPolicy`
/// object.
///
+ (DBTEAMLOGWebSessionsFixedLengthPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
