///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAccessLevel;
@class DBTEAMLOGSharedContentCopyDetails;
@class DBTEAMLOGUserLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedContentCopyDetails` struct.
///
/// Copied shared file/folder to own Dropbox.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSharedContentCopyDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Shared content link.
@property (nonatomic, readonly, copy) NSString *sharedContentLink;

/// The shared content owner.
@property (nonatomic, readonly, nullable) DBTEAMLOGUserLogInfo *sharedContentOwner;

/// Shared content access level.
@property (nonatomic, readonly) DBSHARINGAccessLevel *sharedContentAccessLevel;

/// The path where the member saved the content.
@property (nonatomic, readonly, copy) NSString *destinationPath;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sharedContentLink Shared content link.
/// @param sharedContentAccessLevel Shared content access level.
/// @param destinationPath The path where the member saved the content.
/// @param sharedContentOwner The shared content owner.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentLink:(NSString *)sharedContentLink
                 sharedContentAccessLevel:(DBSHARINGAccessLevel *)sharedContentAccessLevel
                          destinationPath:(NSString *)destinationPath
                       sharedContentOwner:(nullable DBTEAMLOGUserLogInfo *)sharedContentOwner;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param sharedContentLink Shared content link.
/// @param sharedContentAccessLevel Shared content access level.
/// @param destinationPath The path where the member saved the content.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentLink:(NSString *)sharedContentLink
                 sharedContentAccessLevel:(DBSHARINGAccessLevel *)sharedContentAccessLevel
                          destinationPath:(NSString *)destinationPath;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedContentCopyDetails` struct.
///
@interface DBTEAMLOGSharedContentCopyDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSharedContentCopyDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGSharedContentCopyDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedContentCopyDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSharedContentCopyDetails *)instance;

///
/// Deserializes `DBTEAMLOGSharedContentCopyDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedContentCopyDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGSharedContentCopyDetails` object.
///
+ (DBTEAMLOGSharedContentCopyDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
