///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGResellerRole;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ResellerRole` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGResellerRole : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGResellerRoleTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGResellerRole` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGResellerRoleTag){
    /// (no description).
    DBTEAMLOGResellerRoleNotReseller,

    /// (no description).
    DBTEAMLOGResellerRoleResellerAdmin,

    /// (no description).
    DBTEAMLOGResellerRoleOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGResellerRoleTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "not_reseller".
///
/// @return An initialized instance.
///
- (instancetype)initWithNotReseller;

///
/// Initializes union class with tag state of "reseller_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithResellerAdmin;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "not_reseller".
///
/// @return Whether the union's current tag state has value "not_reseller".
///
- (BOOL)isNotReseller;

///
/// Retrieves whether the union's current tag state has value "reseller_admin".
///
/// @return Whether the union's current tag state has value "reseller_admin".
///
- (BOOL)isResellerAdmin;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGResellerRole` union.
///
@interface DBTEAMLOGResellerRoleSerializer : NSObject

///
/// Serializes `DBTEAMLOGResellerRole` instances.
///
/// @param instance An instance of the `DBTEAMLOGResellerRole` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGResellerRole` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGResellerRole *)instance;

///
/// Deserializes `DBTEAMLOGResellerRole` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGResellerRole` API object.
///
/// @return An instantiation of the `DBTEAMLOGResellerRole` object.
///
+ (DBTEAMLOGResellerRole *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
