///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGLegalHoldsActivateAHoldDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldsActivateAHoldDetails` struct.
///
/// Activated a hold.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGLegalHoldsActivateAHoldDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Hold ID.
@property (nonatomic, readonly, copy) NSString *legalHoldId;

/// Hold name.
@property (nonatomic, readonly, copy) NSString *name;

/// Hold start date.
@property (nonatomic, readonly) NSDate *startDate;

/// Hold end date.
@property (nonatomic, readonly, nullable) NSDate *endDate;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param legalHoldId Hold ID.
/// @param name Hold name.
/// @param startDate Hold start date.
/// @param endDate Hold end date.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldId:(NSString *)legalHoldId
                               name:(NSString *)name
                          startDate:(NSDate *)startDate
                            endDate:(nullable NSDate *)endDate;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param legalHoldId Hold ID.
/// @param name Hold name.
/// @param startDate Hold start date.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldId:(NSString *)legalHoldId name:(NSString *)name startDate:(NSDate *)startDate;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `LegalHoldsActivateAHoldDetails` struct.
///
@interface DBTEAMLOGLegalHoldsActivateAHoldDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGLegalHoldsActivateAHoldDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGLegalHoldsActivateAHoldDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGLegalHoldsActivateAHoldDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGLegalHoldsActivateAHoldDetails *)instance;

///
/// Deserializes `DBTEAMLOGLegalHoldsActivateAHoldDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGLegalHoldsActivateAHoldDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGLegalHoldsActivateAHoldDetails`
/// object.
///
+ (DBTEAMLOGLegalHoldsActivateAHoldDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
