///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GuestAdminSignedOutViaTrustedTeamsDetails` struct.
///
/// Ended trusted team admin session.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Host team name.
@property (nonatomic, readonly, copy, nullable) NSString *teamName;

/// Trusted team name.
@property (nonatomic, readonly, copy, nullable) NSString *trustedTeamName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param teamName Host team name.
/// @param trustedTeamName Trusted team name.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamName:(nullable NSString *)teamName trustedTeamName:(nullable NSString *)trustedTeamName;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GuestAdminSignedOutViaTrustedTeamsDetails`
/// struct.
///
@interface DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails *)instance;

///
/// Deserializes `DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails` object.
///
+ (DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
