///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGGeoLocationLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GeoLocationLogInfo` struct.
///
/// Geographic location details.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGeoLocationLogInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// City name.
@property (nonatomic, readonly, copy, nullable) NSString *city;

/// Region name.
@property (nonatomic, readonly, copy, nullable) NSString *region;

/// Country code.
@property (nonatomic, readonly, copy, nullable) NSString *country;

/// IP address.
@property (nonatomic, readonly, copy) NSString *ipAddress;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param ipAddress IP address.
/// @param city City name.
/// @param region Region name.
/// @param country Country code.
///
/// @return An initialized instance.
///
- (instancetype)initWithIpAddress:(NSString *)ipAddress
                             city:(nullable NSString *)city
                           region:(nullable NSString *)region
                          country:(nullable NSString *)country;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param ipAddress IP address.
///
/// @return An initialized instance.
///
- (instancetype)initWithIpAddress:(NSString *)ipAddress;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GeoLocationLogInfo` struct.
///
@interface DBTEAMLOGGeoLocationLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGGeoLocationLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGGeoLocationLogInfo` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGeoLocationLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGeoLocationLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGGeoLocationLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGeoLocationLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGGeoLocationLogInfo` object.
///
+ (DBTEAMLOGGeoLocationLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
