///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DropboxPasswordsNewDeviceEnrolledDetails` struct.
///
/// Enrolled new Dropbox Passwords device.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Whether it's a first device enrolled.
@property (nonatomic, readonly) NSNumber *isFirstDevice;

/// The platform the device is enrolled.
@property (nonatomic, readonly, copy) NSString *platform;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param isFirstDevice Whether it's a first device enrolled.
/// @param platform The platform the device is enrolled.
///
/// @return An initialized instance.
///
- (instancetype)initWithIsFirstDevice:(NSNumber *)isFirstDevice platform:(NSString *)platform;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DropboxPasswordsNewDeviceEnrolledDetails`
/// struct.
///
@interface DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails *)instance;

///
/// Deserializes `DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails` object.
///
+ (DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
