///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMExcludedUsersListError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ExcludedUsersListError` union.
///
/// Excluded users list error.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMExcludedUsersListError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMExcludedUsersListErrorTag` enum type represents the possible tag
/// states with which the `DBTEAMExcludedUsersListError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMExcludedUsersListErrorTag){
    /// An error occurred.
    DBTEAMExcludedUsersListErrorListError,

    /// (no description).
    DBTEAMExcludedUsersListErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMExcludedUsersListErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "list_error".
///
/// Description of the "list_error" tag state: An error occurred.
///
/// @return An initialized instance.
///
- (instancetype)initWithListError;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "list_error".
///
/// @return Whether the union's current tag state has value "list_error".
///
- (BOOL)isListError;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMExcludedUsersListError` union.
///
@interface DBTEAMExcludedUsersListErrorSerializer : NSObject

///
/// Serializes `DBTEAMExcludedUsersListError` instances.
///
/// @param instance An instance of the `DBTEAMExcludedUsersListError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMExcludedUsersListError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersListError *)instance;

///
/// Deserializes `DBTEAMExcludedUsersListError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMExcludedUsersListError` API object.
///
/// @return An instantiation of the `DBTEAMExcludedUsersListError` object.
///
+ (DBTEAMExcludedUsersListError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
