///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBPAPERCursor;
@class DBPAPERListUsersOnFolderResponse;
@class DBSHARINGInviteeInfo;
@class DBSHARINGUserInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListUsersOnFolderResponse` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBPAPERListUsersOnFolderResponse : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// List of email addresses that are invited on the Paper folder.
@property (nonatomic, readonly) NSArray<DBSHARINGInviteeInfo *> *invitees;

/// List of users that are invited on the Paper folder.
@property (nonatomic, readonly) NSArray<DBSHARINGUserInfo *> *users;

/// Pass the cursor into `docsFolderUsersListContinue` to paginate through all
/// users. The cursor preserves all properties as specified in the original call
/// to `docsFolderUsersList`.
@property (nonatomic, readonly) DBPAPERCursor *cursor;

/// Will be set to True if a subsequent call with the provided cursor to
/// `docsFolderUsersListContinue` returns immediately with some results. If set
/// to False please allow some delay before making another call to
/// `docsFolderUsersListContinue`.
@property (nonatomic, readonly) NSNumber *hasMore;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param invitees List of email addresses that are invited on the Paper
/// folder.
/// @param users List of users that are invited on the Paper folder.
/// @param cursor Pass the cursor into `docsFolderUsersListContinue` to paginate
/// through all users. The cursor preserves all properties as specified in the
/// original call to `docsFolderUsersList`.
/// @param hasMore Will be set to True if a subsequent call with the provided
/// cursor to `docsFolderUsersListContinue` returns immediately with some
/// results. If set to False please allow some delay before making another call
/// to `docsFolderUsersListContinue`.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvitees:(NSArray<DBSHARINGInviteeInfo *> *)invitees
                           users:(NSArray<DBSHARINGUserInfo *> *)users
                          cursor:(DBPAPERCursor *)cursor
                         hasMore:(NSNumber *)hasMore;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListUsersOnFolderResponse` struct.
///
@interface DBPAPERListUsersOnFolderResponseSerializer : NSObject

///
/// Serializes `DBPAPERListUsersOnFolderResponse` instances.
///
/// @param instance An instance of the `DBPAPERListUsersOnFolderResponse` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBPAPERListUsersOnFolderResponse` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersOnFolderResponse *)instance;

///
/// Deserializes `DBPAPERListUsersOnFolderResponse` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBPAPERListUsersOnFolderResponse` API object.
///
/// @return An instantiation of the `DBPAPERListUsersOnFolderResponse` object.
///
+ (DBPAPERListUsersOnFolderResponse *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
