///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESSearchOrderBy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SearchOrderBy` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSearchOrderBy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESSearchOrderByTag` enum type represents the possible tag states
/// with which the `DBFILESSearchOrderBy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESSearchOrderByTag){
    /// (no description).
    DBFILESSearchOrderByRelevance,

    /// (no description).
    DBFILESSearchOrderByLastModifiedTime,

    /// (no description).
    DBFILESSearchOrderByOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESSearchOrderByTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "relevance".
///
/// @return An initialized instance.
///
- (instancetype)initWithRelevance;

///
/// Initializes union class with tag state of "last_modified_time".
///
/// @return An initialized instance.
///
- (instancetype)initWithLastModifiedTime;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "relevance".
///
/// @return Whether the union's current tag state has value "relevance".
///
- (BOOL)isRelevance;

///
/// Retrieves whether the union's current tag state has value
/// "last_modified_time".
///
/// @return Whether the union's current tag state has value
/// "last_modified_time".
///
- (BOOL)isLastModifiedTime;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESSearchOrderBy` union.
///
@interface DBFILESSearchOrderBySerializer : NSObject

///
/// Serializes `DBFILESSearchOrderBy` instances.
///
/// @param instance An instance of the `DBFILESSearchOrderBy` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSearchOrderBy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSearchOrderBy *)instance;

///
/// Deserializes `DBFILESSearchOrderBy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSearchOrderBy` API object.
///
/// @return An instantiation of the `DBFILESSearchOrderBy` object.
///
+ (DBFILESSearchOrderBy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
