///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESGetTemporaryLinkError;
@class DBFILESLookupError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GetTemporaryLinkError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESGetTemporaryLinkError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESGetTemporaryLinkErrorTag` enum type represents the possible tag
/// states with which the `DBFILESGetTemporaryLinkError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESGetTemporaryLinkErrorTag){
    /// (no description).
    DBFILESGetTemporaryLinkErrorPath,

    /// This user's email address is not verified. This functionality is only
    /// available on accounts with a verified email address. Users can verify
    /// their email address here https://www.dropbox.com/help/317.
    DBFILESGetTemporaryLinkErrorEmailNotVerified,

    /// Cannot get temporary link to this file type; use `export` instead.
    DBFILESGetTemporaryLinkErrorUnsupportedFile,

    /// The user is not allowed to request a temporary link to the specified
    /// file. For example, this can occur if the file is restricted or if the
    /// user's links are banned
    /// https://help.dropbox.com/files-folders/share/banned-links.
    DBFILESGetTemporaryLinkErrorNotAllowed,

    /// (no description).
    DBFILESGetTemporaryLinkErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESGetTemporaryLinkErrorTag tag;

/// (no description). @note Ensure the `isPath` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESLookupError *path;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "path".
///
/// @param path (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBFILESLookupError *)path;

///
/// Initializes union class with tag state of "email_not_verified".
///
/// Description of the "email_not_verified" tag state: This user's email address
/// is not verified. This functionality is only available on accounts with a
/// verified email address. Users can verify their email address here
/// https://www.dropbox.com/help/317.
///
/// @return An initialized instance.
///
- (instancetype)initWithEmailNotVerified;

///
/// Initializes union class with tag state of "unsupported_file".
///
/// Description of the "unsupported_file" tag state: Cannot get temporary link
/// to this file type; use `export` instead.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnsupportedFile;

///
/// Initializes union class with tag state of "not_allowed".
///
/// Description of the "not_allowed" tag state: The user is not allowed to
/// request a temporary link to the specified file. For example, this can occur
/// if the file is restricted or if the user's links are banned
/// https://help.dropbox.com/files-folders/share/banned-links.
///
/// @return An initialized instance.
///
- (instancetype)initWithNotAllowed;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `path` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value
/// "email_not_verified".
///
/// @return Whether the union's current tag state has value
/// "email_not_verified".
///
- (BOOL)isEmailNotVerified;

///
/// Retrieves whether the union's current tag state has value
/// "unsupported_file".
///
/// @return Whether the union's current tag state has value "unsupported_file".
///
- (BOOL)isUnsupportedFile;

///
/// Retrieves whether the union's current tag state has value "not_allowed".
///
/// @return Whether the union's current tag state has value "not_allowed".
///
- (BOOL)isNotAllowed;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESGetTemporaryLinkError` union.
///
@interface DBFILESGetTemporaryLinkErrorSerializer : NSObject

///
/// Serializes `DBFILESGetTemporaryLinkError` instances.
///
/// @param instance An instance of the `DBFILESGetTemporaryLinkError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESGetTemporaryLinkError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESGetTemporaryLinkError *)instance;

///
/// Deserializes `DBFILESGetTemporaryLinkError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESGetTemporaryLinkError` API object.
///
/// @return An instantiation of the `DBFILESGetTemporaryLinkError` object.
///
+ (DBFILESGetTemporaryLinkError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
