///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEREQUESTSCreateFileRequestArgs;
@class DBFILEREQUESTSFileRequestDeadline;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `CreateFileRequestArgs` struct.
///
/// Arguments for `create`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEREQUESTSCreateFileRequestArgs : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The title of the file request. Must not be empty.
@property (nonatomic, readonly, copy) NSString *title;

/// The path of the folder in the Dropbox where uploaded files will be sent. For
/// apps with the app folder permission, this will be relative to the app
/// folder.
@property (nonatomic, readonly, copy) NSString *destination;

/// The deadline for the file request. Deadlines can only be set by Professional
/// and Business accounts.
@property (nonatomic, readonly, nullable) DBFILEREQUESTSFileRequestDeadline *deadline;

/// Whether or not the file request should be open. If the file request is
/// closed, it will not accept any file submissions, but it can be opened later.
@property (nonatomic, readonly) NSNumber *open;

/// A description of the file request.
@property (nonatomic, readonly, copy, nullable) NSString *description_;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param title The title of the file request. Must not be empty.
/// @param destination The path of the folder in the Dropbox where uploaded
/// files will be sent. For apps with the app folder permission, this will be
/// relative to the app folder.
/// @param deadline The deadline for the file request. Deadlines can only be set
/// by Professional and Business accounts.
/// @param open Whether or not the file request should be open. If the file
/// request is closed, it will not accept any file submissions, but it can be
/// opened later.
/// @param description_ A description of the file request.
///
/// @return An initialized instance.
///
- (instancetype)initWithTitle:(NSString *)title
                  destination:(NSString *)destination
                     deadline:(nullable DBFILEREQUESTSFileRequestDeadline *)deadline
                         open:(nullable NSNumber *)open
                 description_:(nullable NSString *)description_;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param title The title of the file request. Must not be empty.
/// @param destination The path of the folder in the Dropbox where uploaded
/// files will be sent. For apps with the app folder permission, this will be
/// relative to the app folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithTitle:(NSString *)title destination:(NSString *)destination;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `CreateFileRequestArgs` struct.
///
@interface DBFILEREQUESTSCreateFileRequestArgsSerializer : NSObject

///
/// Serializes `DBFILEREQUESTSCreateFileRequestArgs` instances.
///
/// @param instance An instance of the `DBFILEREQUESTSCreateFileRequestArgs` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEREQUESTSCreateFileRequestArgs` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSCreateFileRequestArgs *)instance;

///
/// Deserializes `DBFILEREQUESTSCreateFileRequestArgs` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEREQUESTSCreateFileRequestArgs` API object.
///
/// @return An instantiation of the `DBFILEREQUESTSCreateFileRequestArgs`
/// object.
///
+ (DBFILEREQUESTSCreateFileRequestArgs *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
