//
//  UIViewController+Additions.m
//
//
//  Created by Mike on 13/4/25.
//  
//

#import "UIViewController+Additions.h"
#import <objc/runtime.h>

static char UIViewController_PopoverController;
static char UIViewController_ViewWillDiss;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UIViewController (Additions)
@dynamic privatePopoverController;






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//==============================================================================
//
//==============================================================================
- (void)setPrivatePopoverController:(UIPopoverController *)privatePopoverController
{
    objc_setAssociatedObject(self, &UIViewController_PopoverController, privatePopoverController, OBJC_ASSOCIATION_ASSIGN);
}


//===============================================================================
//
//===============================================================================
- (UIPopoverController*)privatePopoverController
{
    return (UIPopoverController*)objc_getAssociatedObject(self, &UIViewController_PopoverController);
}


//================================================================================
//
//================================================================================
- (void)setViewWillDismiss:(BOOL)viewWillDismiss
{
    objc_setAssociatedObject(self, &UIViewController_ViewWillDiss, @(viewWillDismiss), OBJC_ASSOCIATION_RETAIN);
}


//================================================================================
//
//================================================================================
- (BOOL)viewWillDismiss
{
    return [objc_getAssociatedObject(self, &UIViewController_ViewWillDiss) boolValue];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"


//===============================================================================
//
//===============================================================================
- (void)dismissAnimated:(BOOL)animated recursive:(BOOL)recursive completion: (void (^)(void))completion
{
    [self setViewWillDismiss:YES];
    
    //////////////////////////////////////////////////
    
    
    UIViewController *viewController = nil;
    if (recursive)
    {
        viewController = [self presentedViewController];
    }

    if(viewController)
    {
        [viewController dismissAnimated:animated completion:^{
            
            if([self respondsToSelector:@selector(dismissViewControllerAnimated:completion:)]==YES)
            {
                [self dismissViewControllerAnimated:animated completion:completion];
            }
            else
            {
                [self dismissModalViewControllerAnimated:animated];
                
                if (completion)
                {
                    completion();
                }
            }
        }];
    }
    else
    {
        if([self respondsToSelector:@selector(dismissViewControllerAnimated:completion:)]==YES)
        {
            [self dismissViewControllerAnimated:animated completion:completion];
        }
        else
        {
            [self dismissModalViewControllerAnimated:animated];
            if (completion)
            {
                completion();
            }
        }
    }
}


//===============================================================================
//
//===============================================================================
- (void)dismissAnimated:(BOOL)animated completion: (void (^)(void))completion
{
    [self dismissAnimated:animated recursive:NO completion:completion];
}

#pragma clang diagnostic pop


//===============================================================================
//
//===============================================================================
- (void)goBackToViewController:(UIViewController *)viewController animated:(BOOL)animated
{
    [self setViewWillDismiss:YES];
    
    //////////////////////////////////////////////////

    if([self privatePopoverController]!=nil)
    {
        if([self privatePopoverController].contentViewController==self.navigationController && [self.navigationController.viewControllers count]>1)
        {
            if(viewController!=nil)
            {
                if(viewController!=self && [self.navigationController.viewControllers indexOfObject:viewController]!=NSNotFound)
                {
                    [self.navigationController popToViewController:viewController animated:animated];
                }
                else
                {
                    [self.navigationController popViewControllerAnimated:animated];
                }
            }
            else
            {
                [self.navigationController popToRootViewControllerAnimated:animated];
            }
        }
        else
        {
            [[self privatePopoverController] dismissPopoverAnimated:YES];
            
            //////////////////////////////////////////////////
            
            if([self privatePopoverController].delegate!=nil && [[self privatePopoverController].delegate respondsToSelector:@selector(popoverControllerDidDismissPopover:)]==YES)
            {
                [[self privatePopoverController].delegate popoverControllerDidDismissPopover:[self privatePopoverController]];
            }
        }
    }
    else
    {
        if(self.navigationController!=nil)
        {
            if([self.navigationController.viewControllers count]>1)
            {
                if(viewController!=nil)
                {
                    if(viewController!=self && [self.navigationController.viewControllers indexOfObject:viewController]!=NSNotFound)
                    {
                        [self.navigationController popToViewController:viewController animated:animated];
                    }
                    else
                    {
                        [self.navigationController popViewControllerAnimated:animated];
                    }
                }
                else
                {
                    [self.navigationController popToRootViewControllerAnimated:animated];
                }
            }
            else
            {
                [self.navigationController dismissAnimated:animated completion:nil];
            }
        }
        else
        {
            [self dismissAnimated:animated completion:nil];
        }
    }
}

//===============================================================================
//
//===============================================================================
- (void)goBackAnimated:(BOOL)animated;
{
    [self setViewWillDismiss:YES];
    
    //////////////////////////////////////////////////
    
    [self goBackToViewController:self animated:animated];
}

//===============================================================================
//
//===============================================================================
- (void)goRootAnimated:(BOOL)animated;
{
    [self setViewWillDismiss:YES];
    
    //////////////////////////////////////////////////
    
    [self goBackToViewController:nil animated:animated];
}



@end
