//
//  UIViewController+Additions.h
//
//
//  Created by Mike on 13/4/25.
//  
//

#import <UIKit/UIKit.h>

@interface UIViewController (Additions)

@property (nonatomic, assign) UIPopoverController *privatePopoverController;
@property (nonatomic, readonly) BOOL              viewWillDismiss;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -  Instance Method

//- (UIPopoverController *)privatePopoverController;

/// recursive==YES，把接收到的viewController present出來的viewController也一起關閉；NO:只關接收到這一層
- (void)dismissAnimated:(BOOL)animated recursive:(BOOL)recursive completion: (void (^)(void))completion;

- (void)dismissAnimated:(BOOL)animated completion: (void (^)(void))completion;
- (void)goBackToViewController:(UIViewController *)viewController animated:(BOOL)animated;
- (void)goBackAnimated:(BOOL)animated;
- (void)goRootAnimated:(BOOL)animated;


@end
