//
//  UIView+Hierarchy.m
//  
//
//  Created by Mike on 13/5/2.
//  
//

#import "UIView+Hierarchy.h"

@implementation UIView (Hierarchy)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//===============================================================================
//
//===============================================================================
- (UIView *)firstResponderView
{
    UIView *firstResponderView = nil;
    
    //////////////////////////////////////////////////
    
    if([self isFirstResponder]==YES)
    {
        firstResponderView = self;
    }
    else
    {
        for(UIView *subView in self.subviews)
        {
            firstResponderView = [subView firstResponderView];
            
            if(firstResponderView!=nil)
            {
                break;
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    return firstResponderView;
}

//===============================================================================
//
//===============================================================================
- (void)logHierarchy
{
    NSLog(@"%@", [self stringOfHierarchyLevel:0]);
}

//===============================================================================
//
//===============================================================================
- (NSString *)stringOfHierarchyLevel:(NSInteger)level
{
    NSString *log = @"\n";
    
    //////////////////////////////////////////////////
    
    for(int i=0; i<level; i++)
    {
        log = [log stringByAppendingString:@"\t|"];
    }
    
    log = [log stringByAppendingFormat:@"view:%@ [x:%f y:%f width:%f height:%f]",
           [[self class ] description],
           self.frame.origin.x,
           self.frame.origin.y,
           self.frame.size.width,
           self.frame.size.height];
    
    //////////////////////////////////////////////////
	
	for(UIView *subView in self.subviews)
	{
        log = [log stringByAppendingString:[subView stringOfHierarchyLevel:(level+1)]];
	}
    
    return log;
}

@end
