//
//  UILabel+Additions.m
//

#import "UILabel+Additions.h"
#import <objc/runtime.h>

static char UILabelAdditions_ParagraphStyle;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UILabel (Additions)
@dynamic paragraphStyle;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - dynamic

//================================================================================
//
//================================================================================
- (NSMutableParagraphStyle *)paragraphStyle
{
    return objc_getAssociatedObject(self, &UILabelAdditions_ParagraphStyle);
}

//================================================================================
//
//================================================================================
- (void)setParagraphStyle:(NSMutableParagraphStyle *)style
{
    objc_setAssociatedObject(self, &UILabelAdditions_ParagraphStyle, style, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Pricate Methods

//================================================================================
// 取得項目編號
//================================================================================
- (NSString *)numberingPrefixWithString:(NSString *)string
{
    NSString *pattern = @"[0-9]+. ";
    NSError *error = nil;
    NSRegularExpression *expression = [NSRegularExpression regularExpressionWithPattern:pattern options:NSRegularExpressionCaseInsensitive error:&error];
    
    if(error != nil)
    {
        return nil;
    }
    
    NSRange range = [expression rangeOfFirstMatchInString:string options:NSMatchingReportCompletion range:NSMakeRange(0, [string length])];
    
    if (range.length == 0)
    {
        return nil;
    }
    
    return [string substringWithRange:range];
}

//================================================================================
// 取得項目編號
//================================================================================
- (void)numberingPrefixWithString:(NSString *)string matchingHandler:(void(^)(NSRange matchRange, NSString *matchingText))matchingHandler
{
    NSString *pattern = @"[0-9]+. ";
    NSError *error = nil;
    NSRegularExpression *expression = [NSRegularExpression regularExpressionWithPattern:pattern options:NSRegularExpressionCaseInsensitive error:&error];
    
    if(error != nil)
    {
        return;
    }
    
    [expression enumerateMatchesInString:string options:NSMatchingReportCompletion range:NSMakeRange(0, [string length]) usingBlock:^(NSTextCheckingResult * _Nullable result, NSMatchingFlags flags, BOOL * _Nonnull stop) {
        
        if(matchingHandler)
        {
            matchingHandler(result.range, [string substringWithRange:result.range]);
        }
    }];
    
}


//================================================================================
//
//================================================================================
- (CGSize)sizeOfTextWithMaxWidth:(CGFloat)maxWidth style:(NSParagraphStyle *)style
{
    if([self.text length] == 0)
    {
        return CGSizeZero;
    }

    //////////////////////////////////////////////////
    if(style==nil)
    {
        style = [NSParagraphStyle defaultParagraphStyle];
    }
    CGSize size = [self.text boundingRectWithSize:CGSizeMake(maxWidth, CGFLOAT_MAX)
                                          options:NSStringDrawingUsesLineFragmentOrigin
                                       attributes:@{NSFontAttributeName : self.font,
                                                    NSParagraphStyleAttributeName : style}
                                          context:nil].size;
    
    return CGSizeMake(ceil(size.width), ceil(size.height));
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods

//===============================================================================
//
//===============================================================================
- (void)setNumberingText:(NSString *)text leftInset:(CGFloat)leftInset
{
    [self setNumberingText:text leftInset:leftInset lineSpace:0];
}


//===============================================================================
//
//===============================================================================
- (void)setNumberingText:(NSString *)text leftInset:(CGFloat)leftInset lineSpace:(CGFloat)lineSpace
{
    [self setNumberingText:text leftInset:leftInset lineSpace:0 numberingTextColor:nil contentColor:nil];
}


//==============================================================================
//
//==============================================================================
- (void)setNumberingText:(NSString *)text leftInset:(CGFloat)leftInset lineSpace:(CGFloat)lineSpace numberingTextColor:(UIColor *)numberingTextColor contentColor:(UIColor *)contentColor
{
    if([text length] == 0)
    {
        return;
    }
    
    //////////////////////////////////////////////////
    
    NSString *numberingPrefix = [self numberingPrefixWithString:text];
    CGSize prefixSize = CGSizeZero;
    
    if([numberingPrefix length] > 0)
    {
        CGSize size = [numberingPrefix boundingRectWithSize:CGSizeMake(CGFLOAT_MAX, CGFLOAT_MAX)
                                                    options:NSStringDrawingUsesLineFragmentOrigin
                                                 attributes:@{NSFontAttributeName : self.font}
                                                    context:nil].size;
        
        prefixSize = CGSizeMake(ceil(size.width), ceil(size.height));
    }
    
    //////////////////////////////////////////////////
    
    self.paragraphStyle = [[[NSMutableParagraphStyle alloc] init] autorelease];
    
    if(self.paragraphStyle == nil)
    {
        return;
    }
    
    self.paragraphStyle.alignment = NSTextAlignmentLeft;
    self.paragraphStyle.firstLineHeadIndent = leftInset; // 整體左側內縮
    self.paragraphStyle.headIndent = leftInset + prefixSize.width; // 除了首行以外的內縮
    
    if(lineSpace > 0)
    {
        self.paragraphStyle.lineSpacing = lineSpace;
    }
    
    NSMutableAttributedString *attributeString = [[[NSMutableAttributedString alloc] initWithString:text] autorelease];
    
    [attributeString setAttributes:@{NSParagraphStyleAttributeName:self.paragraphStyle}
                             range:NSMakeRange(0, attributeString.length)];
    
    // 先全部設為一樣顏色
    if(contentColor!=nil)
    {
        [attributeString addAttributes:@{NSForegroundColorAttributeName:contentColor} range:NSMakeRange([numberingPrefix length], [attributeString length]-[numberingPrefix length])];
    }
    
    // 數字另外設定
    if(numberingTextColor!=nil)
    {
        [self numberingPrefixWithString:text matchingHandler:^(NSRange matchRange, NSString *matchingText) {
            
            if(matchRange.length>0)
            {
                [attributeString addAttributes:@{NSForegroundColorAttributeName:numberingTextColor} range:matchRange];
            }
        }];
    }
    self.attributedText = attributeString;
}



//================================================================================
//
//================================================================================
- (CGSize)sizeOfNumberingTextWithMaxWidth:(CGFloat)maxWidth
{
    if([self.text length] == 0)
    {
        return CGSizeZero;
    }
    
    //////////////////////////////////////////////////
    
    NSAssert(self.paragraphStyle!=nil, @"需要呼叫過 setNumberingText:leftInset: 才能使用");
    
    //////////////////////////////////////////////////
    
    CGSize size = [self.text boundingRectWithSize:CGSizeMake(maxWidth, CGFLOAT_MAX)
                                          options:NSStringDrawingUsesLineFragmentOrigin
                                       attributes:@{NSFontAttributeName : self.font,
                                                    NSParagraphStyleAttributeName : self.paragraphStyle}
                                          context:nil].size;
    
    return CGSizeMake(ceil(size.width), ceil(size.height));
}


//==============================================================================
//
//==============================================================================
- (CGFloat)heightForTextWithParagraphStle:(NSParagraphStyle *)paragraphStle
{
    return [self sizeOfTextWithMaxWidth:self.bounds.size.width style:paragraphStle].height;
}

@end
