//
//  UIImage+Exif.h
//  Pods
//
//  Created by sanhue cheng on 25/10/2022.
//

#import <UIKit/UIKit.h>
#import <CoreLocation/CoreLocation.h>

@interface UIImage (Exif)

// 在imagedata中加入location資訊
+ (NSData *)imageDataWithWithLocation:(CLLocation*)location sourceImageData:(NSData*)sourceImageData;

// 把meta dictionary加到 imagedata中
+ (NSData *)imageDataWithWithMetaDictionary:(NSDictionary *)metaDictionary sourceImageData:(NSData*)sourceImageData;

// 取得imagedata中的metaDictionary
+ (NSDictionary *)metaDictionaryFromImageData:(NSData*)imageData;
@end
