//
//  UIDevice+DeviceModel.h
//  
//
//  Created by Mike on 2010/10/4.
//  
//	Last updated time: 2011/07/19

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPDeviceModelName_Unknown			@"Unknown"
#define PPDeviceModelName_Simulator         @"Simulator"
#define PPDeviceModelName_iPhone1G          @"iPhone 1G"
#define PPDeviceModelName_iPhone3G          @"iPhone 3G"
#define PPDeviceModelName_iPhone3GS         @"iPhone 3GS"
#define PPDeviceModelName_iPhone4			@"iPhone 4"
#define PPDeviceModelName_iPhone4S          @"iPhone 4S"
#define PPDeviceModelName_iPhone5			@"iPhone 5"			
#define PPDeviceModelName_iPhone5C			@"iPhone 5c"
#define PPDeviceModelName_iPhone5S			@"iPhone 5s"
#define PPDeviceModelName_iPhone6			@"iPhone 6"
#define PPDeviceModelName_iPhone6Plus		@"iPhone 6 Plus"
#define PPDeviceModelName_iPhone6s			@"iPhone 6s"
#define PPDeviceModelName_iPhone6sPlus		@"iPhone 6s Plus"
#define PPDeviceModelName_iPhoneSE          @"iPhone SE"
#define PPDeviceModelName_iPhone7           @"iPhone 7"
#define PPDeviceModelName_iPhone7Plus       @"iPhone 7 Plus"
#define PPDeviceModelName_iPhone8           @"iPhone 8"
#define PPDeviceModelName_iPhone8Plus       @"iPhone 8 Plus"
#define PPDeviceModelName_iPhoneX           @"iPhone X"
#define PPDeviceModelName_iPhoneXR          @"iPhone XR"
#define PPDeviceModelName_iPhoneXS          @"iPhone XS"
#define PPDeviceModelName_iPhoneXSMax       @"iPhone XS Max"
#define PPDeviceModelName_iPhone11          @"iPhone 11"
#define PPDeviceModelName_iPhone11Pro       @"iPhone 11 Pro"
#define PPDeviceModelName_iPhone11ProMax    @"iPhone 11 Pro Max"
#define PPDeviceModelName_iPhoneSE2          @"iPhone SE 2"
#define PPDeviceModelName_iPhone12          @"iPhone 12"
#define PPDeviceModelName_iPhone12Pro       @"iPhone 12 Pro"
#define PPDeviceModelName_iPhone12ProMax    @"iPhone 12 Pro Max"
#define PPDeviceModelName_iPhone12Mini      @"iPhone 12 Mini"
#define PPDeviceModelName_iPhone13          @"iPhone 13"
#define PPDeviceModelName_iPhone13Pro       @"iPhone 13 Pro"
#define PPDeviceModelName_iPhone13ProMax    @"iPhone 13 Pro Max"
#define PPDeviceModelName_iPhone13Mini      @"iPhone 13 Mini"
#define PPDeviceModelName_iPhoneSE3          @"iPhone SE 3"
#define PPDeviceModelName_iPhone14          @"iPhone 14"
#define PPDeviceModelName_iPhone14Pro       @"iPhone 14 Pro"
#define PPDeviceModelName_iPhone14ProMax    @"iPhone 14 Pro Max"
#define PPDeviceModelName_iPhone14Plus      @"iPhone 14 Plus"
#define PPDeviceModelName_iPhone15          @"iPhone 15"
#define PPDeviceModelName_iPhone15Pro       @"iPhone 15 Pro"
#define PPDeviceModelName_iPhone15ProMax    @"iPhone 15 Pro Max"
#define PPDeviceModelName_iPhone15Plus      @"iPhone 15 Plus"
#define PPDeviceModelName_iPhone15          @"iPhone 15"
#define PPDeviceModelName_iPhone15Pro       @"iPhone 15 Pro"
#define PPDeviceModelName_iPhone15ProMax    @"iPhone 15 Pro Max"
#define PPDeviceModelName_iPhone15Plus      @"iPhone 15 Plus"
#define PPDeviceModelName_iPhone16e          @"iPhone 16e"
#define PPDeviceModelName_iPhone16          @"iPhone 16"
#define PPDeviceModelName_iPhone16Pro       @"iPhone 16 Pro"
#define PPDeviceModelName_iPhone16ProMax    @"iPhone 16 Pro Max"
#define PPDeviceModelName_iPhone16Plus      @"iPhone 16 Plus"

#define PPDeviceModelName_iPad1             @"iPad"
#define PPDeviceModelName_iPad2             @"iPad 2"
#define PPDeviceModelName_iPad3             @"The new iPad"
#define PPDeviceModelName_iPad4             @"iPad 4"
#define PPDeviceModelName_iPadMini          @"iPad Mini"
#define PPDeviceModelName_iPadMini2         @"iPad Mini 2"
#define PPDeviceModelName_iPadMini3         @"iPad Mini 3"
#define PPDeviceModelName_iPadMini4         @"iPad Mini 4"
#define PPDeviceModelName_iPadAir           @"iPad Air"
#define PPDeviceModelName_iPadAir2          @"iPad Air 2"
#define PPDeviceModelName_iPadPro           @"iPad Pro"
#define PPDeviceModelName_iPadPro2          @"iPad Pro 2"
#define PPDeviceModelName_iPad5             @"iPad 5"
#define PPDeviceModelName_iPadPro_10_5      @"iPad Pro 10.5 inch"
#define PPDeviceModelName_iPad6             @"iPad 6"
#define PPDeviceModelName_iPadPro3          @"iPad Pro3"
#define PPDeviceModelName_iPadMini5         @"iPad Mini5"
#define PPDeviceModelName_iPadAir3          @"iPad Air 3"
#define PPDeviceModelName_iPad7            @"iPad  7"
#define PPDeviceModelName_iPadPro4            @"iPad Pro 4"
#define PPDeviceModelName_iPad8            @"iPad 8"
#define PPDeviceModelName_iPad9            @"iPad 9"
#define PPDeviceModelName_iPadAir4            @"iPad Air 4"
#define PPDeviceModelName_iPadPro5            @"iPad Pro 5"
#define PPDeviceModelName_iPadAir5            @"iPad Air 5"
#define PPDeviceModelName_iPad10            @"iPad 10"
#define PPDeviceModelName_iPadmini6            @"iPad mini 6"
#define PPDeviceModelName_iPadPro6            @"iPad Pro 6"
#define PPDeviceModelName_iPadAir6            @"iPad Air 6"
#define PPDeviceModelName_iPadmini7            @"iPad mini 7"
#define PPDeviceModelName_iPadPro7            @"iPad Pro 7"
#define PPDeviceModelName_iPadAir7            @"iPad Air 7"
#define PPDeviceModelName_iPad11            @"iPad 11"

#define PPDeviceModelName_iPodTouch1G		@"iPod Touch 1G"
#define PPDeviceModelName_iPodTouch2G		@"iPod Touch 2G"
#define PPDeviceModelName_iPodTouch2_5G     @"iPod Touch 2.5G"
#define PPDeviceModelName_iPodTouch3G		@"iPod Touch 3G"
#define PPDeviceModelName_iPodTouch4G		@"iPod Touch 4G"
#define PPDeviceModelName_iPodTouch5G		@"iPod Touch 5G"
#define PPDeviceModelName_iPodTouch6G		@"iPod Touch 6G"
#define PPDeviceModelName_iPodTouch7G       @"iPod Touch 7G"
#define PPDeviceModelName_AppleTV			@"AppleTV"
#define PPDeviceModelName_AppleTV2          @"AppleTV 2"
#define PPDeviceModelName_AppleTV3          @"AppleTV 3"
#define PPDeviceModelName_AppleTV4          @"AppleTV 4"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPDeviceModelID)
{
	PPDeviceModelID_Unknown = 0,
	PPDeviceModelID_Simulator,
    PPDeviceModelID_iPhone = 1000,
	PPDeviceModelID_iPhone_1G,
	PPDeviceModelID_iPhone_3G,
	PPDeviceModelID_iPhone_3GS,
	PPDeviceModelID_iPhone_4,
	PPDeviceModelID_iPhone_4S,
	PPDeviceModelID_iPhone_5,	
	PPDeviceModelID_iPhone_5C,
	PPDeviceModelID_iPhone_5S,
    PPDeviceModelID_iPhone_6,
    PPDeviceModelID_iPhone_6Plus,
    PPDeviceModelID_iPhone_6s,
    PPDeviceModelID_iPhone_6sPlus,
    PPDeviceModelID_iPhone_SE,
    PPDeviceModelID_iPhone_7,
    PPDeviceModelID_iPhone_7Plus,
    PPDeviceModelID_iPhone_8,
    PPDeviceModelID_iPhone_8Plus,
    PPDeviceModelID_iPhone_X,
    PPDeviceModelID_iPhone_XR,
    PPDeviceModelID_iPhone_XS,
    PPDeviceModelID_iPhone_XSMax,
    PPDeviceModelID_iPhone_11,
    PPDeviceModelID_iPhone_11Pro,
    PPDeviceModelID_iPhone_11ProMax,
    PPDeviceModelID_iPhone_SE2,
    PPDeviceModelID_iPhone_12Mini,
    PPDeviceModelID_iPhone_12,
    PPDeviceModelID_iPhone_12Pro,
    PPDeviceModelID_iPhone_12ProMax,
    PPDeviceModelID_iPhone_13Mini,
    PPDeviceModelID_iPhone_13,
    PPDeviceModelID_iPhone_13Pro,
    PPDeviceModelID_iPhone_13ProMax,
    PPDeviceModelID_iPhone_SE3,
    PPDeviceModelID_iPhone_14,
    PPDeviceModelID_iPhone_14Pro,
    PPDeviceModelID_iPhone_14ProMax,
    PPDeviceModelID_iPhone_14Plus,
    PPDeviceModelID_iPhone_15,
    PPDeviceModelID_iPhone_15Pro,
    PPDeviceModelID_iPhone_15ProMax,
    PPDeviceModelID_iPhone_15Plus,
    PPDeviceModelID_iPhone_16,
    PPDeviceModelID_iPhone_16Pro,
    PPDeviceModelID_iPhone_16ProMax,
    PPDeviceModelID_iPhone_16Plus,
    PPDeviceModelID_iPhone_16e,
    PPDeviceModelID_iPad = 2000,
	PPDeviceModelID_iPad_1,
	PPDeviceModelID_iPad_2,
	PPDeviceModelID_iPad_3, 
	PPDeviceModelID_iPad_4,
	PPDeviceModelID_iPad_Air,
    PPDeviceModelID_iPad_mini,
	PPDeviceModelID_iPad_mini2,
    PPDeviceModelID_iPad_mini3,
    PPDeviceModelID_iPad_Air2,
    PPDeviceModelID_iPad_mini4,
    PPDeviceModelID_iPad_Pro,
    PPDeviceModelID_iPad_5,
    PPDeviceModelID_iPad_Pro2,
    PPDeviceModelID_iPad_Pro_10_5,
    PPDeviceModelID_iPad_6,
    PPDeviceModelID_iPad_Pro3,
    PPDeviceModelID_iPad_mini5,
    PPDeviceModelID_iPad_Air3,
    PPDeviceModelID_iPad_7,
    PPDeviceModelID_iPad_Pro4,
    PPDeviceModelID_iPad_8,
    PPDeviceModelID_iPad_9,
    PPDeviceModelID_iPad_Air4,
    PPDeviceModelID_iPad_Pro5,
    PPDeviceModelID_iPad_Air5,
    PPDeviceModelID_iPad_10,
    PPDeviceModelID_iPad_mini6,
    PPDeviceModelID_iPad_Pro6,
    PPDeviceModelID_iPad_Air6,
    PPDeviceModelID_iPad_mini7,
    PPDeviceModelID_iPad_Pro7,
    PPDeviceModelID_iPad_Air7,
    PPDeviceModelID_iPad_11,
    PPDeviceModelID_iPod = 3000,
	PPDeviceModelID_iPod_1G ,
	PPDeviceModelID_iPod_2G,
	PPDeviceModelID_iPod_2_5G,
	PPDeviceModelID_iPod_3G,
	PPDeviceModelID_iPod_4G,
	PPDeviceModelID_iPod_5G,
    PPDeviceModelID_iPod_6G,
    PPDeviceModelID_iPod_7G,
    PPDeviceModelID_AppleTV = 4000,
	PPDeviceModelID_AppleTV1,
	PPDeviceModelID_AppleTV2,
	PPDeviceModelID_AppleTV3,
    PPDeviceModelID_AppleTV4,
    PPDeviceModelID_AppleTV_4K,
    PPDeviceModelID_AppleTV_4K2,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface UIDevice(DeviceModel)

/**
 * 檢查是否支援SIRI
 * @return BOOL YES if support siri, otherwise NO
 */
+ (BOOL)isSupportSiri;

/**
 * 取得Device model
 * @return NSString device model string
 */
+ (NSString *)deviceModel;

/**
 * 取得device model name
 * @return NSString device model name define above
 */
+ (NSString *)deviceModelName;

/**
 * 取得device model id
 * @return PPDeviceModelID device model id as PPDeviceModelID
 */
+ (PPDeviceModelID)deviceModelID;


/**
* 判斷機置是否有home indicator
* @return YES if has home indicator
*/
+ (BOOL)hasHomeIndicator;

@end


