//
//  UIColor+PropertyDictionary.m
//  
//
//  Created by Mike on 13/4/30.
//  
//

#import "UIColor+PropertyDictionary.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *DefaultColor_Background   = @"DefaultColor_Background";
NSString *DefaultColor_BarTint      = @"DefaultColor_BarTint";
NSString *DefaultColor_HyperLink    = @"DefaultColor_HyperLink";
NSString *DefaultColor_SectionIndex = @"DefaultColor_SectionIndex";
NSString *DefaultColor_Seprator     = @"DefaultColor_Seprator";
NSString *DefaultColor_Tint         = @"DefaultColor_Tint";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIColorPropertyDictionary_Key

NSString *UIColorPropertyDictionary_Key_Alpha = @"Alpha";
NSString *UIColorPropertyDictionary_Key_Blue  = @"Blue";
NSString *UIColorPropertyDictionary_Key_Green = @"Green";
NSString *UIColorPropertyDictionary_Key_Red   = @"Red";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UIColor (PropertyDictionary)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Class Methods

//===============================================================================
//
//===============================================================================
+ (NSMutableDictionary *)colorPropertyListDictionary
{
    static NSMutableDictionary *colorPropertyListDictionary = nil;
    
    if(colorPropertyListDictionary==nil)
    {
        colorPropertyListDictionary = [[NSMutableDictionary alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"DefaultColor" ofType:@"plist"]];
    }
    
    return colorPropertyListDictionary;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//===============================================================================
//
//===============================================================================
+ (BOOL)addColorPropertyFromDictionary:(NSDictionary *)dictionary
{
    BOOL result = NO;
    
    do
    {
        if(dictionary==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSMutableDictionary *colorPropertyListDictionary = [UIColor colorPropertyListDictionary];
        
        if(colorPropertyListDictionary==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        [colorPropertyListDictionary addEntriesFromDictionary:dictionary];
        
        result = YES;
        
    }while(0);
    
    return result;
}

//===============================================================================
//
//===============================================================================
+ (UIColor *)colorForKey:(NSString *)key
{
    UIColor *color = nil;
    
    do
    {
        if(key==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSMutableDictionary *colorPropertyListDictionary = [UIColor colorPropertyListDictionary];
        
        if(colorPropertyListDictionary==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSDictionary *colorPropertyDictionary = [colorPropertyListDictionary objectForKey:key];
        if(colorPropertyDictionary==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSNumber *alphaNumber = [colorPropertyDictionary objectForKey:UIColorPropertyDictionary_Key_Alpha];
        if(alphaNumber==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSNumber *blueNumber = [colorPropertyDictionary objectForKey:UIColorPropertyDictionary_Key_Blue];
        if(blueNumber==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSNumber *greenNumber = [colorPropertyDictionary objectForKey:UIColorPropertyDictionary_Key_Green];
        if(greenNumber==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSNumber *redNumber = [colorPropertyDictionary objectForKey:UIColorPropertyDictionary_Key_Red];
        if(redNumber==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        color = [UIColor colorWithRed:[redNumber intValue]/255.0
                                green:[greenNumber intValue]/255.0
                                 blue:[blueNumber intValue]/255.0
                                alpha:[alphaNumber doubleValue]];
        
    }while(0);
    
    return color;
}

@end
