//
//  UIButton+Additions.m
//  
//
//  Created by Mike on 13/5/17.
//  
//

#import "UIButton+Additions.h"

@implementation UIButton (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//===============================================================================
//
//===============================================================================
- (void)setBackgroundImage:(UIImage *)image
{
    [self setBackgroundImage:image	forState:UIControlStateNormal];
	[self setBackgroundImage:image	forState:UIControlStateHighlighted];
	[self setBackgroundImage:image	forState:UIControlStateDisabled];
    [self setBackgroundImage:image	forState:UIControlStateSelected];
}

//===============================================================================
//
//===============================================================================
- (void)setBackgroundImageWithName:(NSString *)name
{
    self.titleEdgeInsets = [UIImage capInsetsForImageName:name];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    UIImage *imageNormal        = [UIImage imageWithName:name forState:UIControlStateNormal         resizableCapInsets:self.titleEdgeInsets];
    UIImage *imageHighlighted   = [UIImage imageWithName:name forState:UIControlStateHighlighted    resizableCapInsets:self.titleEdgeInsets];
    UIImage *imageDisabled      = [UIImage imageWithName:name forState:UIControlStateDisabled       resizableCapInsets:self.titleEdgeInsets];
    UIImage *imageSelected      = [UIImage imageWithName:name forState:UIControlStateSelected       resizableCapInsets:self.titleEdgeInsets];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	if(imageNormal!=nil)
	{
        if(CGRectIsEmpty(self.frame)==true)
        {
            self.frame = CGRectMake(0, 0, imageNormal.size.width, imageNormal.size.height);
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
		if(imageHighlighted==nil)
		{
			imageHighlighted    = imageNormal;
		}
		
		if(imageDisabled==nil)
		{
			imageDisabled		= imageNormal;
		}
        
        if(imageSelected==nil)
		{
			imageSelected       = imageNormal;
		}
	}
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[self setBackgroundImage:imageNormal		forState:UIControlStateNormal];
	[self setBackgroundImage:imageHighlighted	forState:UIControlStateHighlighted];
	[self setBackgroundImage:imageDisabled      forState:UIControlStateDisabled];
    [self setBackgroundImage:imageSelected      forState:UIControlStateSelected];
}

//===============================================================================
//
//===============================================================================
- (void)setImage:(UIImage *)image
{
    [self setImage:image	forState:UIControlStateNormal];
	[self setImage:image	forState:UIControlStateHighlighted];
	[self setImage:image	forState:UIControlStateDisabled];
    [self setImage:image	forState:UIControlStateSelected];
}

//===============================================================================
//
//===============================================================================
- (void)setImageTransformByOrientation:(UIDeviceOrientation)orientation
{
	[UIView beginAnimations:nil context:nil];
	[UIView setAnimationBeginsFromCurrentState:YES];
	[UIView setAnimationDuration:UIButtonAdditions_TransformAnimationDuration];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    CGAffineTransform transform = CGAffineTransformIdentity;
    
    switch(orientation)
    {
        case UIDeviceOrientationLandscapeLeft:
        {
            transform = CGAffineTransformMakeRotation(M_PI_2);
            break;
        }
        case UIDeviceOrientationLandscapeRight:
        {
            transform = CGAffineTransformMakeRotation(-M_PI_2);
            break;
        }
        case UIDeviceOrientationPortraitUpsideDown:
        {
            transform = CGAffineTransformMakeRotation(-M_PI);
            break;
        }
        case UIDeviceOrientationPortrait:
        default:
        {
            break;
        }
    }
    
    [self.imageView setTransform:transform];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[UIView commitAnimations];
}

//===============================================================================
//
//===============================================================================
- (void)setImageWithName:(NSString *)name
{
    UIImage *imageNormal        = [UIImage imageWithName:name forState:UIControlStateNormal];
    UIImage *imageHighlighted   = [UIImage imageWithName:name forState:UIControlStateHighlighted];
    UIImage *imageDisabled      = [UIImage imageWithName:name forState:UIControlStateDisabled];
    UIImage *imageSelected      = [UIImage imageWithName:name forState:UIControlStateSelected];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	if(imageNormal!=nil)
	{
        if(CGRectIsEmpty(self.frame)==true)
        {
            self.frame = CGRectMake(0, 0, imageNormal.size.width, imageNormal.size.height);
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
		if(imageHighlighted==nil)
		{
			imageHighlighted    = imageNormal;
		}
		
		if(imageDisabled==nil)
		{
			imageDisabled		= imageNormal;
		}

        if(imageSelected==nil)
		{
			imageSelected       = imageNormal;
		}
	}
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[self setImage:imageNormal		forState:UIControlStateNormal];
	[self setImage:imageHighlighted	forState:UIControlStateHighlighted];
	[self setImage:imageDisabled	forState:UIControlStateDisabled];
    [self setImage:imageSelected	forState:UIControlStateSelected];
}

//===============================================================================
//
//===============================================================================
- (void)setTitleText:(NSString *)title
{
    [self setTitle:title	forState:UIControlStateNormal];
    [self setTitle:title    forState:UIControlStateSelected];
	[self setTitle:title	forState:UIControlStateHighlighted];
    [self setTitle:title    forState:UIControlStateDisabled];
}


//===============================================================================
//
//===============================================================================
- (void)setTitle:(NSString *)title
{
    [self setTitleText:title];
}


//===============================================================================
//
//===============================================================================
- (void)setTitle:(NSString *)title maxWidth:(CGFloat)maxWidth
{
    CGSize frameSize = [title sizeWithAttributes:@{NSFontAttributeName:self.titleLabel.font}];
    
    frameSize.width		+= (self.titleEdgeInsets.left+self.titleEdgeInsets.right);
    frameSize.height	+= (self.titleEdgeInsets.top+self.titleEdgeInsets.bottom);
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    frameSize.width		= MAX(ceil(frameSize.width), UIButtonAdditions_DefaultTitleLabelMinWidth);
    frameSize.height	= MAX(ceil(frameSize.height), UIButtonAdditions_DefaultTitleLabelMinHeight);
    
    // 如果有影像，要把影像的大小考慮進來
    if ([self.imageView image]!=nil)
    {
        frameSize.width		+= (self.imageEdgeInsets.left+self.imageEdgeInsets.right) + CGRectGetWidth(self.imageView.frame);
        frameSize.height	+= (self.imageEdgeInsets.top+self.imageEdgeInsets.bottom) + CGRectGetHeight(self.imageView.frame);
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(maxWidth>0)
    {
        frameSize.width = MIN(frameSize.width, maxWidth);
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    self.frame = CGRectMake(self.frame.origin.x,
                            self.frame.origin.y,
                            MAX(frameSize.width, self.frame.size.width),
                            MAX(frameSize.height, self.frame.size.height));
	
	[self setTitleText:title];
}


//===============================================================================
//
//===============================================================================
- (void)setTitleColor:(UIColor *)color
{
    [self setTitleColor:color	forState:UIControlStateNormal];
	[self setTitleColor:color	forState:UIControlStateHighlighted];
	[self setTitleColor:color	forState:UIControlStateDisabled];
    [self setTitleColor:color	forState:UIControlStateSelected];
}

//===============================================================================
//
//===============================================================================
- (void)setTitleShadowColor:(UIColor *)color
{
    [self setTitleShadowColor:color	forState:UIControlStateNormal];
	[self setTitleShadowColor:color	forState:UIControlStateHighlighted];
	[self setTitleShadowColor:color	forState:UIControlStateDisabled];
    [self setTitleShadowColor:color	forState:UIControlStateSelected];
}

@end
