//
//  UIApplication+URL.h
//  
//
//  Created by Mike on 13/12/20.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, UIApplicationURLType)
{
    UIApplicationURLType_None = 0,
    UIApplicationURLType_Email,
    UIApplicationURLType_Facebook,
    UIApplicationURLType_FaceTime,
    UIApplicationURLType_GoogleMap,
    UIApplicationURLType_BaiduMap,
    UIApplicationURLType_LinkedIn,
    UIApplicationURLType_NaviCon,
    UIApplicationURLType_SMS,
    UIApplicationURLType_Tel,
    UIApplicationURLType_Twitter,
    UIApplicationURLType_Web,
    UIApplicationURLType_Skype,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface UIApplication (URL)

+ (BOOL)canOpenURLType:(UIApplicationURLType)type;
+ (BOOL)openURLType:(UIApplicationURLType)type withParameter:(NSString *)parameter;
+ (NSString *)parameterForNaviConWithAddress:(NSString *)address appName:(NSString *)appName title:(NSString *)title text:(NSString *)text;
+ (NSString *)parameterForLinkedInWithFirstName:(NSString *)firstName lastName:(NSString *)lastName;

@end
