//
//  UIAlertView+Additions.m
//  
//
//  Created by Mike on 13/6/3.
//  
//

#import "UIAlertView+Additions.h"

static char UIAlertViewAdditions_UserInfo;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UIAlertView (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - dynamic

@dynamic
userInfo;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
- (id)userInfo
{
    return objc_getAssociatedObject(self, &UIAlertViewAdditions_UserInfo);
}

//================================================================================
//
//================================================================================
- (void)setUserInfo:(id)userInfo
{
    objc_setAssociatedObject(self, &UIAlertViewAdditions_UserInfo, userInfo, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (UILabel *)privateTitleLabel
{
    return [self valueForKey:@"_titleLabel"];
}

- (UILabel *)privateSubtitleLabel
{
    return [self valueForKey:@"_subtitleLabel"];
}

- (UILabel *)privateBodyTextLabel
{
    return [self valueForKey:@"_bodyTextLabel"];
}

- (UILabel *)privateTaglineTextLabel
{
    return [self valueForKey:@"_taglineTextLabel"];
}

- (UIToolbar *)privateToolbar
{
    return [self valueForKey:@"_toolbar"];
}

- (UIWindow  *)privateOriginalWindow
{
    return [self valueForKey:@"_originalWindow"];
}

- (UIWindow  *)privateDimWindow
{
    return [self valueForKey:@"_dimWindow"];
}

- (NSMutableArray *)privateButtons
{
    return [self valueForKey:@"_buttons"];
}

- (NSMutableArray *)privateTextFields
{
    return [self valueForKey:@"_textFields"];
}

- (UIView *)privateKeyboard
{
    return [self valueForKey:@"_keyboard"];
}

- (UIView *)privateTable
{
    return [self valueForKey:@"_table"];
}

- (UIView *)privateDimView
{
    return [self valueForKey:@"_dimView"];
}

- (UIView *)privateBackgroundImageView
{
    return [self valueForKey:@"_backgroundImageView"];
}

@end
