//
//  NSUserDefaults+PreferredLanguageFixForiOs.m
//  WorldNote
//
//  Created by sanhue on 2014/3/28.
//  Copyright (c) 2014年 Eddie. All rights reserved.
//

#import "NSUserDefaults+PreferredLanguagesFixForiOS.h"

//////////////////////////////////////////////////////////////////////////////////////////

static NSString* const keyLanguages = @"AppleLanguages";

//////////////////////////////////////////////////////////////////////////////////////////

@implementation NSUserDefaults (PreferredLanguageFixForiOs)

//////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (void)setAppLanguage:(NSString *)language
{
    NSMutableArray* langs = [NSMutableArray arrayWithArray:
                             [[NSUserDefaults standardUserDefaults] valueForKey:keyLanguages]];
    
    NSUInteger index = [langs indexOfObject:language];
    
    if(NSNotFound!=index)
    {
        [langs removeObjectAtIndex:index];
        [langs insertObject:language atIndex:0];
    }
    else
    {
        [langs removeAllObjects];
        [langs insertObject:language atIndex:0];
    }
    
    [[NSUserDefaults standardUserDefaults] setValue:langs forKey:keyLanguages];
    [[NSUserDefaults standardUserDefaults] synchronize];
}


//================================================================================
//
//================================================================================
+ (void)fixPrefferedLanguagesWithDefaultLanguage:(NSString*)defaultLanguage
{
    // remove what was previously stored in NSUserDefaults (otherwise the previously selected language will be still the first one in the list and your app won't be localized in the language selected in settings)
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    
    [userDefaults setObject:nil forKey:keyLanguages];
    [userDefaults synchronize]; // make the change immediate
    
    // reorder the languages so English is always the default fallback
    NSMutableArray *mutableLanguages = [[NSLocale preferredLanguages] mutableCopy];
    if (mutableLanguages)
    {
        if ([mutableLanguages count]>2)
        {
            NSInteger enIndex = NSNotFound;
            for (NSString *lang in mutableLanguages) { if ([lang isEqualToString:defaultLanguage]) { enIndex = [mutableLanguages indexOfObject:lang]; break; } }
            @try {
                if ((enIndex != 0) && (enIndex != 1)) { [mutableLanguages exchangeObjectAtIndex:1 withObjectAtIndex:enIndex]; }
            } @catch (NSException *exception) {
                
            }
            // save the changes
            [userDefaults setObject:mutableLanguages forKey:keyLanguages];
            [userDefaults synchronize]; // to make the change immediate
        }
        [mutableLanguages release];
    }
}
@end
