//
//  NSDate+Format.h
//  
//
//  Created by Mike on 13/4/25.
//  
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

extern NSString *NSDateFormat_Year;
extern NSString *NSDateFormat_Month;
extern NSString *NSDateFormat_Day;
extern NSString *NSDateFormat_Hour;
extern NSString *NSDateFormat_Minute;
extern NSString *NSDateFormat_Second;
extern NSString *NSDateFormat_MonthAndDay;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NSDate (Format)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (NSString *)stringWithFormat:(NSString *)format;
- (NSString *)stringWithFormat:(NSString *)format timeZone:(NSTimeZone *)timeZone;
- (NSString *)stringWithFormat:(NSString *)format timeZone:(NSTimeZone *)timeZone locale:(NSLocale *)locale;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (NSDate *)dateFromString:(NSString *)string format:(NSString *)format;
+ (NSDate *)dateFromString:(NSString *)string format:(NSString *)format timeZone:(NSTimeZone *)timeZone;

@end
