//
//  HWRDefine.h
//
//  Created by Howard on 2015/5/4.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#ifndef HWRDefine_h
#define HWRDefine_h

#define LOWER_ALPHA_TYPE        1
#define UPPER_ALPHA_TYPE        2
#define NUMA_TYPE               4
#define NUMERIC_TYPE            4
#define GENERAL_PUNCT_TYPE      8
#define EXTEND_PUNCT_TYPE       16
#define GENERAL_SYMBOL_TYPE     32
#define EXTEND_SYMBOL_TYPE      64
#define GESTURE_TYPE            128
#define RADICAL_TYPE            256
#define CHINESE_1_TYPE          512
#define CHINESE_2_TYPE          1024

#define IN_HK_TYPE              2048
#define SIMPLIFIED_ONLY         4096
#define TRADITIONAL_ONLY        8192

#define IN_KSC_TYPE             2048
#define PINYIN_LOWER_TYPE       4096
#define PINYIN_UPPER_TYPE       8192
#define HIRA_TYPE               16384 // 平假名
#define KATA_TYPE               32768 // 片假名
#define KSC_TYPE                IN_KSC_TYPE
#define HANGUL_TYPE             IN_KSC_TYPE

#define VALID_TYPE              (0x000007FF|HIRA_TYPE|KATA_TYPE)

#define IN_5401_TYPE            CHINESE_1_TYPE
#define IN_13052_TYPE           CHINESE_2_TYPE
#define CURSIVE_TYPE            (ALPHA_TYPE|NUMA_TYPE|SYMBOL_TYPE|GESTURE_TYPE)

#define IN_JIS1_TYPE            CHINESE_1_TYPE
#define IN_JIS2_TYPE            CHINESE_2_TYPE
#define SYMBOL_TYPE             120
#define ALPHA_TYPE              (UPPER_ALPHA_TYPE+LOWER_ALPHA_TYPE)
#define KANA_TYPE               (HIRA_TYPE+KATA_TYPE)
#define ASCII_TYPE              (ALPHA_TYPE+NUMA_TYPE+SYMBOL_TYPE)
#define CHINESE_TYPE            (IN_5401_TYPE|IN_13052_TYPE)

#define ALL_TYPE                VALID_TYPE

#define AI_ONLY_TYPE            65536L

#define AI_OK                   0
#define AI_OVERFLOW             1
#define UNABLE_DO_AI            2
#define AI_DISABLE              3

#define FULL_TYPE               0
#define HALF_TYPE               1

#define SHAPE_TYPE              0x0001  /* FULL_TYPE ==0 HALF_TYPE == 1 */
#define TURN_ON_HK              0x0002  /* open HK characters */
#define TURN_ON_BIG_ONLY        0x0004  /* 只出現繁體字 */
#define TURN_ON_GB_ONLY         0x0008  /* 只出現簡體字 */
#define TURN_ON_BIG_AND_GB      0x000C  /* 寫繁得繁 寫簡得簡 */
#define TURN_ON_FULL_UNICODE    0x0010  /* 寫繁得繁 寫簡得簡 全字集 含罕用字 */
#define TURN_ON_GBB_ONLY        0x0020  /* 寫繁得簡 only for 大陸版*/
#define TURN_ON_OCR             0x0040  /* turn on off-line recognition */

//新增一個flag控制香港補充字集6000字是否要辨識
#define SUPPLEMENT_HK_TYPE		0x00040000

#define UNKNOWN_PHRASE          0  //Disable all phrases
#define TAIWAN_PHRASE           1  //Traditional/Taiwan Phrase
#define HONGKONG_PHRASE         2  //Traditional/HongKong Phrase
#define MAINLAND_PHRASE         4  //Simplified/China Mainland Phrase
#define JAPAN_PHRASE            8  //Japanese Phrase
#define KOREAN_PHRASE           16 //Korean Phrase

#define JPN_SHIFT_JIS           932  //日本地區使用
#define SIMPLIFIED_CHINESE      936  //大陸地區使用
#define HANGEUL_TongHabHyung	949  //南韓Windows使用
#define TRADITIONAL_CHINESE     950  //台灣香港地區使用
#define TC_SC_COMBINATION       1024 //簡體(GB2312)+繁體(BIG5 13060)
//#define HANGEUL_JOHAB         1361

// mode define
enum
{
    TRADITIONAL_MODE = 0x00000001, // 中文繁體
    SIMPLIFIED_MODE  = 0x00000002, // 中文簡體
    JAPAN_MODE       = 0x00000003, // 日文
    KOREA_MODE       = 0x00000004, // 韓文
    ENGLISH_MODE     = 0x00000005, // 英文
    FRANCE_MODE      = 0x00000006, // 法文
    GERMAN_MODE      = 0x00000007, // 德文
    HOLLAND_MODE     = 0x00000008, // 荷蘭文
    ITALY_MODE       = 0x00000009, // 義大利文
    SPAIN_MODE       = 0x0000000A, // 西班牙文
    SWEDEN_MODE      = 0x0000000B, // 瑞典文
    PORTUGAL_MODE    = 0x0000000C, // 葡萄牙文
    NORWAY_MODE      = 0x0000000D, // 挪威文
    DENMARK_MODE     = 0x0000000E, // 丹麥文
    FINLAND_MODE     = 0x0000000F, // 芬蘭文
    TURKY_MODE       = 0x00000010, // 土耳其文
    RUSSIA_MODE      = 0x00000011, // 俄文
    POLAND_MODE      = 0x00000012, // 波蘭文
    HUNGARY_MODE     = 0x00000013, // 匈牙利文
    SLOVENIA_MODE    = 0x00000014, // 斯洛維尼亞文
    ROMANIA_MODE     = 0x00000015, // 羅馬尼亞文
    CZECH_MODE       = 0x00000016, // 捷克文
    SLOVAKIA_MODE    = 0x00000017, // 斯洛伐克文
    CROATIA_MODE     = 0x00000018, // 克羅埃西亞文
    GREEK_MODE       = 0x00000019, // 希臘文
    OCRAB_MODE       = 0x0000001A, // OCRAB
    INDONESIA_MODE   = 0x0000001B, // 印尼文
};

enum
{
    NOT_GET_LINE  = 0x00080000,  // 不作抽行
};

/* Following are the return value definition for the mandatory API functions */
#define STATUS_OK                           0x0000	/* Function finished without error */
#define STATUS_NO_DICT                      0x0001	/* No dictionary assigned */
#define STATUS_INVALID_DICT                 0x0002	/* Dictionary format wrong */
#define STATUS_INVALID_TYPE                 0x0003	/* Required range not in current dictionary */
#define STATUS_INVALID_NUMBER               0x0004	/* Required candidate number is invalid */
#define STATUS_NO_ENOUGH_MEMORY             0x0005	/* Dynamic memory assigned not enough */
#define STATUS_INVALID_HWRDATA_PTR          0x0006	/* NULL HWRDATA Pointer */
#define STATUS_INVALID_PRIVATE_PTR          0x0007	/* NULL Private Data Pointer */
#define STATUS_INVALID_BOX_PTR              0x0008	/* NULL Box Pointer */
#define STATUS_INVALID_TRACE_PTR            0x0009	/* NULL TRACE PTR */
#define STATUS_INVALID_RESULT_PTR           0x000A	/* NULL RESULT PTR */
#define STATUS_INVALID_DBENDIAN             0x000B	/* Incorrect Database Endian */
#define STATUS_CANNOT_BUILD_LEARN_RECORD    0x0010
#define STATUS_INVALID_LEARN_STRING_PTR     0x0011
#define STATUS_INVALID_LEARN_STRING_LENGTH  0x0012
#define STATUS_RECORD_CANNOT_BE_FOUND       0x0013
#define STATUS_CHECKSUM_ERROR               0x00FF
#define STATUS_UNKNOWN                      0x00FE	/* Unspecified error occured */

typedef struct NormalPointType{
    unsigned char x;
    unsigned char y;
} NORMALPOINTTYPE, *LPNORMALPOINTTYPE;

typedef struct
{
    short first_stroke;
    short last_stroke;
    HWRBOX Box;
} BOUNDBOX, *LPBOUNDBOX;

#ifdef REDUCE_RESOURCE
#define REAL_MAX_NO_CHAR        20
#define MAX_POINT_IN_ONE_STROKE 256
#define MAX_NO_POINT_IN_SCREEN  2048
#define MAX_LEARN_CHAR          512
#else
#define REAL_MAX_NO_CHAR        40
#define MAX_POINT_IN_ONE_STROKE 400
#define MAX_NO_POINT_IN_SCREEN  4097
#define MAX_LEARN_CHAR          512
#endif

#if defined(CANDS_100)
#define MAX_RADCOUNT            100
#define MAX_BUFFER_RETURN_SIZE  8192
#else
#define MAX_RADCOUNT            29
#define MAX_BUFFER_RETURN_SIZE  1028 //1024
#endif

typedef struct LearnRecordStruct{
    short CodeLength;
    short InkLength;
    unsigned short LearnString[MAX_LEARN_CHAR];
    short Width;
    short Height;
    NORMALPOINTTYPE InkData[1024];
} LEARNRECORD, *LPLEARNRECORD;

typedef struct
{
    short Normalized_Fontsize;			   //美化拉直後平均高最接近的Fontsize
    short UpperBound_Fontsize;			   //可調整上限的Fontsize
    short UpperBound_Fontsize_SelectGrid;  //可調整上限的Fontsize(勾選Grid)
    short Grid_Width;					   //回傳格子高度
    short Grid_Height;					   //回傳格子寬度
}CALC_SIZE_INFO,*pCALC_SIZE_INFO;

//////////////////////////////////////////////////

// line direction define
enum
{
    Horizontal_Line  = 0x00001000,
    Vertical_Line    = 0x00002000,
};

typedef struct
{
    short  x;
    short  y;
} POINT_TYPE, *LPPOINT_TYPE;

typedef struct
{
    signed char*	pInternalDict; // The pointer to standard HWR dictionary
    signed char*	pExternalDict; // The pointer to external / customer HWR dictionary, maybe used for user customization
    signed char*	pPrivate;      // The pointer to RAM for HWR engine internal usage
    
    signed char*   pLearnDict;    // 指向學習數據庫的地址, 192 KB
    signed char*	pExternalDict_multi;
    signed char*	pUserDict;
    signed char*   pUserSupplement;
} HWRData, *LPHWRData;

#endif
