//
//  AVCaptureDevice+RequestAuthorization.m
//  WorldCardMobile
//
//  Created by sanhue on 2014/9/24.
//
//

#import "AVCaptureDevice+RequestAuthorization.h"

@implementation AVCaptureDevice (RequestAuthorization)
+ (void)requestAccessCameraWithSuccessHandler:(void (^)(void))successHandler failedHandler:(void (^)(void))failedHandler
{
    if ([AVCaptureDevice respondsToSelector:@selector(requestAccessForMediaType:completionHandler:)])
    {
        [AVCaptureDevice requestAccessForMediaType:AVMediaTypeVideo completionHandler:^(BOOL granted) {
            // !! 會在background thread call進來，所以要再dispatch到main thread
            dispatch_async(dispatch_get_main_queue(), ^{
                if (granted)
                {
                    if (successHandler)
                    {
                        successHandler();
                    }
                }
                else
                {
                    if (failedHandler)
                    {
                        failedHandler();
                    }
                }
            });
        }];
    }
    else
    {
        if (successHandler)
        {
            successHandler();
        }
    }
}

@end
