/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.signature.sdk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class SignFileOutputStream
extends FileOutputStream {
    private byte[] BYTE_MAP = new byte[256];

    public SignFileOutputStream(String name) throws IOException {
        this(new File(name));
    }

    public SignFileOutputStream(File file) throws IOException {
        super(file);
        for (int i = 0; i < 256; ++i) {
            this.BYTE_MAP[i] = (byte)i;
        }
        Random random = new Random();
        for (int i = 0; i < this.BYTE_MAP.length; ++i) {
            int p = random.nextInt(256);
            byte b = this.BYTE_MAP[i];
            this.BYTE_MAP[i] = this.BYTE_MAP[p];
            this.BYTE_MAP[p] = b;
        }
        super.write(new byte[]{26, 42}, 0, 2);
        super.write(this.BYTE_MAP, 0, 256);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            b[i] = this.BYTE_MAP[b[i] & 0xFF];
        }
        super.write(b, off, len);
    }
}

