/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.signature.sdk;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import com.penpower.signature.sdk.BitmapConverter;
import com.penpower.signature.sdk.PenDeviceInfo;
import com.penpower.signature.sdk.TouchEvent;
import com.zc_hwpad_util.HW_padOperation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class CanvasView
extends View {
    public static final String ACTION = "com.penpower.signature.USB_PERMISSION";
    public static final int BUTTON_OK = 0;
    public static final int BUTTON_CANCEL = 1;
    public static final int STROKE_STYLE_PRESSURE = 0;
    public static final int STROKE_STYLE_FIXED = 1;
    public static final int IMAGE_FORMAT_BITMAP = 0;
    public static final int IMAGE_FORMAT_JPEG = 1;
    public static final int IMAGE_FORMAT_PNG = 2;
    public static final int L370 = 0;
    public static final int L500 = 1;
    public static final int L500P = 2;
    public static final int STROKE_PEN_WIDTH_LEVEL_1 = 1;
    public static final int STROKE_PEN_WIDTH_LEVEL_2 = 2;
    public static final int STROKE_PEN_WIDTH_LEVEL_3 = 3;
    public static final int STROKE_PEN_WIDTH_LEVEL_4 = 4;
    public static final int STROKE_PEN_WIDTH_LEVEL_5 = 5;
    private final float STROKE_WIDTH_LEVEL_1 = 2.5f;
    private final float STROKE_WIDTH_LEVEL_2 = 3.5f;
    private final float STROKE_WIDTH_LEVEL_3 = 5.0f;
    private final float STROKE_WIDTH_LEVEL_4 = 6.5f;
    private final float STROKE_WIDTH_LEVEL_5 = 7.5f;
    private final int L370_HW_PAD_WIDTH = 800;
    private final int L370_HW_PAD_HEIGHT = 490;
    private final int L500_HW_PAD_WIDTH = 800;
    private final int L500_HW_PAD_HEIGHT = 450;
    private final int L500P_HW_PAD_WIDTH = 800;
    private final int L500P_HW_PAD_HEIGHT = 420;
    private final int TOUCH_EVENT = 13;
    private final int CLOSE_EVENT = 999;
    private final int PID = 22290;
    private final int VID = 1155;
    private final int TOUCH_DOWN = 0;
    private final int TOUCH_UP = 3;
    private final int TOUCH_CANCEL = 1;
    private final int TOUCH_OK = 2;
    private HW_padOperation mOperation;
    private Context mContext;
    private UsbManager mUsbManager;
    private UsbDevice mUsbDevice;
    private UsbInterface mInterface;
    private UsbDeviceConnection mDeviceConnection;
    private PendingIntent mPermissionIntent;
    private Handler mHidHandler;
    private int mPadType = 0;
    private int gPenDown = 0;
    private int xOld = -1;
    private int yOld = -1;
    private int pOld = 0;
    private int mPreTouchStatus = 0;
    private Paint mPaint = null;
    private Bitmap mCanvasBitmap = null;
    private Path mPath;
    private ArrayList<Path> mPaths = new ArrayList();
    private ArrayList<Float> mPressures = new ArrayList();
    private float mStartX = 0.0f;
    private float mStartY = 0.0f;
    private float mStartP = 0.0f;
    private int mDefaultColor = -16777216;
    private float mStrokeWidth = 5.0f;
    private int gInvalidateCount = 0;
    private final RectF mDirtyRect = new RectF();
    private int mStrokeStyle = 0;
    private int mImageFormat = 1;
    private String mFileDir = "/mnt/sdcard/penpower";
    private int mBackgroundColor = -1;
    private Rect mMaxRect = new Rect();
    private boolean mIsFitBitmap = false;
    private EventListener mEventListener;
    private boolean mIsConnect = false;
    private Canvas mBitmapCanvas = null;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context aContext, Intent aIntent) {
            String action = aIntent.getAction();
            if (CanvasView.ACTION.equals(action)) {
                2 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)aIntent.getParcelableExtra("device");
                    if (aIntent.getBooleanExtra("permission", false) && device != null && CanvasView.this.mDeviceConnection == null) {
                        CanvasView.this.openConnection();
                    }
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                CanvasView.this.disconnect();
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                // empty if block
            }
        }
    };

    public CanvasView(Context aContext) {
        this(aContext, null, 0);
    }

    public CanvasView(Context aContext, AttributeSet aAttrs) {
        this(aContext, aAttrs, 0);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.disconnect();
    }

    public CanvasView(Context aContext, AttributeSet aAttrs, int aDefStyleAttr) {
        super(aContext, aAttrs, aDefStyleAttr);
        this.mContext = aContext;
        this.mOperation = new HW_padOperation();
        this.openConnection();
        this.initPaint();
        switch (this.mPadType) {
            case 0: {
                this.mCanvasBitmap = Bitmap.createBitmap((int)800, (int)490, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                break;
            }
            case 1: {
                this.mCanvasBitmap = Bitmap.createBitmap((int)800, (int)450, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                break;
            }
            case 2: {
                this.mCanvasBitmap = Bitmap.createBitmap((int)800, (int)420, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
        }
        this.mPath = new Path();
        if (this.mDeviceConnection != null) {
            this.mOperation.OpenLED_c(this.mDeviceConnection);
        }
        this.mHidHandler = new Handler(){

            public void handleMessage(Message msg) {
                if (msg.what == 13) {
                    TouchEvent obj = (TouchEvent)msg.obj;
                    if (obj.mType == 2) {
                        File dir = new File(CanvasView.this.mFileDir);
                        if (dir != null && !dir.exists()) {
                            dir.mkdirs();
                        }
                        if (CanvasView.this.mFileDir != null && CanvasView.this.mFileDir.lastIndexOf(47) == -1) {
                            CanvasView.this.mFileDir = CanvasView.this.mFileDir + "/";
                        }
                        String fileName = CanvasView.this.mFileDir + "ppsign";
                        switch (CanvasView.this.mImageFormat) {
                            case 1: {
                                CanvasView.this.saveImage(1, fileName + ".jpg");
                                break;
                            }
                            case 2: {
                                CanvasView.this.saveImage(2, fileName + ".png");
                                break;
                            }
                            case 0: {
                                CanvasView.this.saveImage(0, fileName + ".bmp");
                            }
                        }
                        CanvasView.this.resetRect();
                        CanvasView.this.penClear();
                        CanvasView.this.gPenDown = 0;
                        CanvasView.this.xOld = -1;
                        CanvasView.this.yOld = -1;
                        CanvasView.this.mOperation.ClearLCD_c(CanvasView.this.mDeviceConnection);
                        if (CanvasView.this.mEventListener != null) {
                            CanvasView.this.mEventListener.onButtonEvent(0);
                        }
                    } else if (obj.mType == 1) {
                        CanvasView.this.resetRect();
                        CanvasView.this.penClear();
                        CanvasView.this.gPenDown = 0;
                        CanvasView.this.xOld = -1;
                        CanvasView.this.yOld = -1;
                        if (CanvasView.this.mEventListener != null) {
                            CanvasView.this.mEventListener.onButtonEvent(1);
                        }
                    } else {
                        int x = obj.mX;
                        int y = obj.mY;
                        int p = obj.mP;
                        if (CanvasView.this.mPadType == 2) {
                            y -= 45;
                        }
                        if (x != -1) {
                            if (obj.mType == 3) {
                                if (x >= 0 && (CanvasView.this.xOld != x || CanvasView.this.yOld != y)) {
                                    CanvasView.this.penMove((short)x, (short)y, (short)p);
                                }
                                CanvasView.this.gPenDown = 0;
                                CanvasView.this.penUp();
                            } else if (CanvasView.this.gPenDown == 0) {
                                CanvasView.this.gPenDown = 1;
                                CanvasView.this.penDown((short)x, (short)y, (short)p);
                            } else {
                                if (CanvasView.this.gPenDown > 2 && x >= 0 && (CanvasView.this.xOld != x || CanvasView.this.yOld != y)) {
                                    CanvasView.this.penMove((short)x, (short)y, (short)p);
                                }
                                CanvasView.this.xOld = x;
                                CanvasView.this.yOld = y;
                                CanvasView.this.pOld = p;
                                CanvasView.this.gPenDown++;
                            }
                        } else {
                            CanvasView.this.gPenDown = 0;
                            CanvasView.this.penUp();
                        }
                    }
                } else if (msg.what == 999) {
                    CanvasView.this.disconnect();
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.mContext.registerReceiver(this.mUsbReceiver, filter);
    }

    private void computeRect(float x, float y) {
        int margin = 15;
        if (x < (float)this.mMaxRect.left) {
            this.mMaxRect.left = (int)x - margin;
        }
        if (x > (float)this.mMaxRect.right) {
            this.mMaxRect.right = (int)x + margin;
        }
        if (y < (float)this.mMaxRect.top) {
            this.mMaxRect.top = (int)y - margin;
        }
        if (y > (float)this.mMaxRect.bottom) {
            this.mMaxRect.bottom = (int)y + margin;
        }
        this.mMaxRect.left = Math.max(this.mMaxRect.left, 0);
        this.mMaxRect.top = Math.max(this.mMaxRect.top, 0);
        switch (this.mPadType) {
            case 0: {
                this.mMaxRect.right = Math.min(this.mMaxRect.right, 799);
                this.mMaxRect.bottom = Math.min(this.mMaxRect.bottom, 489);
                break;
            }
            case 1: {
                this.mMaxRect.right = Math.min(this.mMaxRect.right, 799);
                this.mMaxRect.bottom = Math.min(this.mMaxRect.bottom, 449);
                break;
            }
            case 2: {
                this.mMaxRect.right = Math.min(this.mMaxRect.right, 799);
                this.mMaxRect.bottom = Math.min(this.mMaxRect.bottom, 419);
            }
        }
    }

    private void resetRect() {
        if (this.mMaxRect == null) {
            this.mMaxRect = new Rect();
        }
        if (this.mMaxRect != null) {
            switch (this.mPadType) {
                case 0: {
                    this.mMaxRect.left = 800;
                    this.mMaxRect.top = 490;
                    break;
                }
                case 1: {
                    this.mMaxRect.left = 800;
                    this.mMaxRect.top = 450;
                    break;
                }
                case 2: {
                    this.mMaxRect.left = 800;
                    this.mMaxRect.top = 420;
                }
            }
            this.mMaxRect.right = 0;
            this.mMaxRect.bottom = 0;
        }
    }

    public void setOnEventListener(EventListener listener) {
        this.mEventListener = listener;
    }

    public boolean connect(int aPadType) {
        if (aPadType < 0) {
            return false;
        }
        this.disconnect();
        if (this.mPadType != aPadType) {
            if (this.mCanvasBitmap != null) {
                this.mCanvasBitmap.recycle();
                this.mCanvasBitmap = null;
            }
            this.mBitmapCanvas = null;
            this.mPadType = aPadType;
            switch (this.mPadType) {
                case 0: {
                    this.mCanvasBitmap = Bitmap.createBitmap((int)800, (int)490, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    break;
                }
                case 1: {
                    this.mCanvasBitmap = Bitmap.createBitmap((int)800, (int)450, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    break;
                }
                case 2: {
                    this.mCanvasBitmap = Bitmap.createBitmap((int)800, (int)420, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
            }
            this.invalidate();
        }
        if (this.mDeviceConnection == null) {
            this.openConnection();
        }
        if (this.mDeviceConnection != null) {
            this.mOperation.OpenLED_c(this.mDeviceConnection);
            this.resetRect();
            this.mIsConnect = true;
            return true;
        }
        return false;
    }

    public void disconnect() {
        this.mIsConnect = false;
        if (this.mDeviceConnection != null) {
            this.resetRect();
            this.penClear();
            this.mOperation.CloseLED_c(this.mDeviceConnection);
            this.mDeviceConnection.close();
            this.mDeviceConnection = null;
        }
    }

    public void clearPad() {
        if (this.mDeviceConnection != null) {
            this.mOperation.ClearLCD_c(this.mDeviceConnection);
        }
    }

    public void setFilePath(String aFileDir) {
        File dir = new File(aFileDir);
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        this.mFileDir = aFileDir;
    }

    public void setClipStroke(boolean aIsFitBitmap) {
        this.mIsFitBitmap = aIsFitBitmap;
    }

    public PenDeviceInfo queryDeviceInfo() {
        PenDeviceInfo deviceInfo = null;
        if (this.mDeviceConnection != null) {
            deviceInfo = new PenDeviceInfo();
            deviceInfo.mPenID = this.mOperation.GetZC_penID_c(this.mDeviceConnection);
            deviceInfo.mPadID = this.mOperation.GetZC_padID_c(this.mDeviceConnection);
            deviceInfo.mPadType = this.mOperation.GetZC_pad_type_c(this.mDeviceConnection);
        }
        return deviceInfo;
    }

    public void setStrokeWidth(int aWidthLevel) {
        this.mStrokeWidth = 5.0f;
        switch (aWidthLevel) {
            case 1: {
                this.mStrokeWidth = 2.5f;
                break;
            }
            case 2: {
                this.mStrokeWidth = 3.5f;
                break;
            }
            case 3: {
                this.mStrokeWidth = 5.0f;
                break;
            }
            case 4: {
                this.mStrokeWidth = 6.5f;
                break;
            }
            case 5: {
                this.mStrokeWidth = 7.5f;
            }
        }
    }

    public void setStrokeColor(int aColor) {
        this.mDefaultColor = aColor;
        if (this.mPaint != null) {
            this.mPaint.setColor(this.mDefaultColor);
        } else {
            this.initPaint();
        }
    }

    public void setBackgroundColor(int aColor) {
        this.mBackgroundColor = aColor;
        this.invalidate();
    }

    public void setStrokeStyle(int aStrokeStyle) {
        this.mStrokeStyle = aStrokeStyle;
    }

    public void saveImageFormat(int aImageFormat) {
        this.mImageFormat = aImageFormat;
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.drawColor(this.mBackgroundColor, PorterDuff.Mode.CLEAR);
            this.mBitmapCanvas.drawColor(this.mBackgroundColor);
        }
    }

    public boolean saveImage(int aImageFormat, String aFilePath) {
        if (this.mCanvasBitmap != null) {
            switch (aImageFormat) {
                case 0: {
                    Bitmap saveBitmap = null;
                    switch (this.mPadType) {
                        case 0: {
                            saveBitmap = this.writerPic(Bitmap.createBitmap((int)800, (int)490, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                            break;
                        }
                        case 1: {
                            saveBitmap = this.writerPic(Bitmap.createBitmap((int)800, (int)450, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                            break;
                        }
                        case 2: {
                            saveBitmap = this.writerPic(Bitmap.createBitmap((int)800, (int)420, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                        }
                    }
                    if (saveBitmap == null) break;
                    if (this.mIsFitBitmap) {
                        Bitmap fitBitmap = Bitmap.createBitmap((Bitmap)saveBitmap, (int)this.mMaxRect.left, (int)this.mMaxRect.top, (int)this.mMaxRect.width(), (int)this.mMaxRect.height());
                        if (fitBitmap != null) {
                            this.saveJpeg(fitBitmap, aFilePath);
                            fitBitmap.recycle();
                            fitBitmap = null;
                        }
                    } else {
                        this.saveJpeg(saveBitmap, aFilePath);
                    }
                    saveBitmap.recycle();
                    saveBitmap = null;
                    break;
                }
                case 1: {
                    Bitmap saveBitmap = null;
                    switch (this.mPadType) {
                        case 0: {
                            saveBitmap = this.writerPic(Bitmap.createBitmap((int)800, (int)490, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                            break;
                        }
                        case 1: {
                            saveBitmap = this.writerPic(Bitmap.createBitmap((int)800, (int)450, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                            break;
                        }
                        case 2: {
                            saveBitmap = this.writerPic(Bitmap.createBitmap((int)800, (int)420, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                        }
                    }
                    if (saveBitmap == null) break;
                    if (this.mIsFitBitmap) {
                        Bitmap fitBitmap = Bitmap.createBitmap((Bitmap)saveBitmap, (int)this.mMaxRect.left, (int)this.mMaxRect.top, (int)this.mMaxRect.width(), (int)this.mMaxRect.height());
                        if (fitBitmap != null) {
                            this.saveJpeg(fitBitmap, aFilePath);
                            fitBitmap.recycle();
                            fitBitmap = null;
                        }
                    } else {
                        this.saveJpeg(saveBitmap, aFilePath);
                    }
                    saveBitmap.recycle();
                    saveBitmap = null;
                    break;
                }
                case 2: {
                    Bitmap saveBitmap = null;
                    switch (this.mPadType) {
                        case 0: {
                            saveBitmap = this.writerPng(Bitmap.createBitmap((int)800, (int)490, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                            break;
                        }
                        case 1: {
                            saveBitmap = this.writerPng(Bitmap.createBitmap((int)800, (int)450, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                            break;
                        }
                        case 2: {
                            saveBitmap = this.writerPng(Bitmap.createBitmap((int)800, (int)420, (Bitmap.Config)Bitmap.Config.ARGB_8888));
                        }
                    }
                    if (saveBitmap == null) break;
                    if (this.mIsFitBitmap) {
                        Bitmap fitBitmap = Bitmap.createBitmap((Bitmap)saveBitmap, (int)this.mMaxRect.left, (int)this.mMaxRect.top, (int)this.mMaxRect.width(), (int)this.mMaxRect.height());
                        if (fitBitmap != null) {
                            this.savePng(fitBitmap, aFilePath);
                            fitBitmap.recycle();
                            fitBitmap = null;
                        }
                    } else {
                        this.savePng(saveBitmap, aFilePath);
                    }
                    saveBitmap.recycle();
                    Object var3_5 = null;
                }
            }
            this.resetRect();
            return true;
        }
        this.resetRect();
        return false;
    }

    private Bitmap writerPic(Bitmap aBitmap) {
        this.initPaint();
        Canvas canvas = new Canvas(aBitmap);
        if (canvas != null && this.mPaths != null) {
            canvas.drawColor(-1);
            for (int i = 0; i < this.mPaths.size(); ++i) {
                this.setPenPressure(this.mPressures.get(i).floatValue());
                canvas.drawPath(this.mPaths.get(i), this.mPaint);
            }
        }
        return aBitmap;
    }

    private Bitmap writerPng(Bitmap aBitmap) {
        this.initPaint();
        Canvas canvas = new Canvas(aBitmap);
        if (canvas != null && this.mPaths != null) {
            for (int i = 0; i < this.mPaths.size(); ++i) {
                this.setPenPressure(this.mPressures.get(i).floatValue());
                canvas.drawPath(this.mPaths.get(i), this.mPaint);
            }
        }
        return aBitmap;
    }

    public void doStrokeClear() {
        this.penClear();
        this.clearPad();
    }

    private void saveBitmap(Bitmap aBitmap, String aFilePath) {
        try {
            FileOutputStream fOut = new FileOutputStream(aFilePath);
            BitmapConverter obj = new BitmapConverter();
            byte[] data = obj.CreateGrayBitmapArray(aBitmap);
            if (data != null) {
                fOut.write(data);
            }
            fOut.flush();
            fOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"WrongThread"})
    private void saveJpeg(Bitmap aBitmap, String aFilePath) {
        try {
            FileOutputStream fOut = new FileOutputStream(aFilePath);
            aBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fOut);
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"WrongThread"})
    private void savePng(Bitmap aBitmap, String aFilePath) {
        try {
            FileOutputStream fOut = new FileOutputStream(aFilePath);
            aBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void setPenPressure(float aPressure) {
        if (this.mPaint != null) {
            if (this.mStrokeStyle == 0) {
                this.mPaint.setStrokeWidth(this.mStrokeWidth * aPressure);
            } else {
                this.mPaint.setStrokeWidth(this.mStrokeWidth);
            }
        }
    }

    protected void onDraw(Canvas aCanvas) {
        super.onDraw(aCanvas);
        aCanvas.drawBitmap(this.writer(this.mCanvasBitmap), 0.0f, 0.0f, null);
    }

    private void penDown(short x0, short y0, short p0) {
        float fP = (float)(p0 / 100) / 4.0f;
        if (fP == 0.0f) {
            fP = 1.0f;
        }
        this.mStartX = x0;
        this.mStartY = y0;
        this.mStartP = fP;
        this.mPath = new Path();
        this.mPath.moveTo((float)x0, (float)y0);
        this.computeRect(this.mStartX, this.mStartY);
    }

    private void penUp() {
        this.mPaths.add(this.mPath);
        this.mPressures.add(Float.valueOf(this.mStartP));
    }

    private void penClear() {
        this.mPath.reset();
        this.mPath = new Path();
        this.mPaths.clear();
        this.mPressures.clear();
        this.clear();
    }

    private void clear() {
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.drawColor(this.mBackgroundColor, PorterDuff.Mode.CLEAR);
            this.mBitmapCanvas.drawColor(this.mBackgroundColor);
            this.invalidate();
        }
    }

    private void penMove(short x0, short y0, short p0) {
        float fP = (float)p0 / 100.0f / 4.0f;
        if (fP == 0.0f) {
            fP = 1.0f;
        }
        if (this.mStartP != fP) {
            float cX = ((float)x0 + this.mStartX) / 2.0f;
            float cY = ((float)y0 + this.mStartY) / 2.0f;
            this.mPath.quadTo(this.mStartX, this.mStartY, cX, cY);
            this.mStartX = cX;
            this.mStartY = cY;
            this.computeRect(this.mStartX, this.mStartY);
            this.mPaths.add(this.mPath);
            this.mPressures.add(Float.valueOf(this.mStartP));
            this.mPath = new Path();
            this.mPath.moveTo(this.mStartX, this.mStartY);
            this.mStartP = fP;
        } else {
            float cX = ((float)x0 + this.mStartX) / 2.0f;
            float cY = ((float)y0 + this.mStartY) / 2.0f;
            this.mPath.quadTo(this.mStartX, this.mStartY, cX, cY);
            this.mStartX = cX;
            this.mStartY = cY;
            this.mStartP = fP;
        }
        this.expandDirtyRect(this.mStartX, this.mStartY);
        ++this.gInvalidateCount;
        if (this.gInvalidateCount % 3 == 0) {
            this.postInvalidate((int)(this.mDirtyRect.left - this.mStrokeWidth), (int)(this.mDirtyRect.top - this.mStrokeWidth), (int)(this.mDirtyRect.right + this.mStrokeWidth), (int)(this.mDirtyRect.bottom + this.mStrokeWidth));
        }
    }

    private Bitmap writer(Bitmap pic) {
        this.initPaint();
        if (this.mBitmapCanvas == null) {
            this.mBitmapCanvas = new Canvas(pic);
        }
        this.mBitmapCanvas.drawColor(this.mBackgroundColor);
        for (int i = 0; i < this.mPaths.size(); ++i) {
            if (i < this.mPaths.size() - 1) {
                float pressure = (this.mPressures.get(i).floatValue() + this.mPressures.get(i + 1).floatValue()) / 2.0f;
                this.setPenPressure(pressure);
            } else {
                this.setPenPressure(this.mPressures.get(i).floatValue());
            }
            this.mBitmapCanvas.drawPath(this.mPaths.get(i), this.mPaint);
        }
        this.setPenPressure(this.mStartP);
        return pic;
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mDefaultColor);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setDither(true);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setPathEffect((PathEffect)new CornerPathEffect(200.0f));
    }

    private void expandDirtyRect(float aHistoricalX, float aHistoricalY) {
        if (aHistoricalX < this.mDirtyRect.left) {
            this.mDirtyRect.left = aHistoricalX;
        } else if (aHistoricalX > this.mDirtyRect.right) {
            this.mDirtyRect.right = aHistoricalX;
        }
        if (aHistoricalY < this.mDirtyRect.top) {
            this.mDirtyRect.top = aHistoricalY;
        } else if (aHistoricalY > this.mDirtyRect.bottom) {
            this.mDirtyRect.bottom = aHistoricalY;
        }
    }

    private void openConnection() {
        HashMap deviceList;
        if (this.mUsbManager == null) {
            this.mUsbManager = (UsbManager)this.mContext.getSystemService("usb");
        }
        if (!(deviceList = this.mUsbManager.getDeviceList()).isEmpty()) {
            for (UsbDevice device : deviceList.values()) {
                UsbInterface usbInterface;
                int i;
                if (device.getVendorId() != 1155 || device.getProductId() != 22290 || (i = 0) >= device.getInterfaceCount() || (usbInterface = device.getInterface(i)).getInterfaceClass() != 3 || usbInterface.getInterfaceSubclass() != 0 || usbInterface.getInterfaceProtocol() != 0) continue;
                this.mUsbDevice = device;
                if (this.mUsbManager.hasPermission(device)) {
                    this.mDeviceConnection = this.mUsbManager.openDevice(device);
                    if (this.mDeviceConnection.claimInterface(usbInterface, true)) {
                        this.mInterface = usbInterface;
                        this.mOperation.getEndpoint(this.mDeviceConnection, this.mInterface);
                        this.workThread();
                        continue;
                    }
                    this.mDeviceConnection.close();
                    continue;
                }
                IntentFilter filter = new IntentFilter(ACTION);
                this.mContext.registerReceiver(this.mUsbReceiver, filter);
                this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION), (int)0);
                this.mUsbManager.requestPermission(this.mUsbDevice, this.mPermissionIntent);
            }
        }
    }

    public void workThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CanvasView.this.mIsConnect = true;
                while (CanvasView.this.mDeviceConnection != null && CanvasView.this.mIsConnect) {
                    String sRet = CanvasView.this.mOperation.GetHW_padData_c(CanvasView.this.mDeviceConnection);
                    TouchEvent event = CanvasView.this.dateOperation(sRet);
                    if (event == null || CanvasView.this.mHidHandler == null) continue;
                    Message msg = CanvasView.this.mHidHandler.obtainMessage();
                    msg.obj = event;
                    msg.what = 13;
                    CanvasView.this.mHidHandler.sendMessage(msg);
                }
            }
        });
        thread.start();
    }

    public TouchEvent dateOperation(String sRet) {
        TouchEvent event = null;
        String[] sXY = sRet.split(",");
        int type = Integer.parseInt(sXY[0]);
        int x = (Integer.parseInt(sXY[1]) - 160) / 3;
        int y = (Integer.parseInt(sXY[2]) - 190) / 3;
        int p = Integer.parseInt(sXY[3]);
        if (this.mPreTouchStatus != type) {
            this.mPreTouchStatus = type;
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    event = new TouchEvent();
                    event.mType = 1;
                    break;
                }
                case 2: {
                    event = new TouchEvent();
                    event.mType = 2;
                    break;
                }
                case 3: {
                    if (this.mPreTouchStatus == 1 || this.mPreTouchStatus == 2) break;
                    event = new TouchEvent();
                    event.mType = 3;
                    event.mX = x;
                    event.mY = y;
                    event.mP = p;
                }
            }
        } else if (this.mPreTouchStatus == 0 && p != 0) {
            event = new TouchEvent();
            event.mType = 0;
            event.mX = x;
            event.mY = y;
            event.mP = p;
        }
        return event;
    }

    public static interface EventListener {
        public void onButtonEvent(int var1);
    }
}

