#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QScreen>
#include <QMessageBox>
#include <QDebug>
#include <QLibrary>
#include <QCloseEvent>
#include <QDir>
#include <qmutex.h>
// ============================================================================================================================
// by Julio at 2024.10.03.
typedef unsigned short WORD;
typedef long LONG;
typedef unsigned long DWORD;

#define LOWORD(l)           ((WORD)(((DWORD)(l)) & 0xffff))
#define HIWORD(l)           ((WORD)((((DWORD)(l)) >> 16) & 0xffff))

typedef unsigned long WPARAM;
typedef long LPARAM;
// ============================================================================================================================

enum GET_INK_DATA_TYPE_ID
{
    INKDATATYPE_X = 1,
    INKDATATYPE_Y,
    INKDATATYPE_STROKEEND
};

enum ENCODE_BASE64_IMAGE_TYPE_ID
{
    EBITI_BITMAP = 1,
    EBITI_JPEG,
    EBITI_PNG,
    EBITI_INK = 6,
};

typedef struct _tagPPSDKVERSION
{
    int nMajorVersion;
    int nMinorVersion;

} PPSDKVERSION, *PPPSDKVERSION;

typedef struct _tagPPAXIS
{
    int nAXMin;
    int nAXMax;

} PPAXIS, *PPPAXIS;

enum GET_DEVICE_INFO_ID_LIST
{
    DIID_GET_STATUS = 1,
    DIID_GET_AXIS_X,
    DIID_GET_AXIS_Y,
    DIID_GET_PRESSURE,
    DIID_GET_VENDOR,
    DIID_GET_PRODUCT,
    DIID_GET_DRV_VER
};

enum IMAGE_TYPE_ID
{
    ITI_BITMAP = 1,
    ITI_JPEG,
    ITI_PNG,
    ITI_PDF = 7,
    ITI_SVG
};

enum DEVICE_TYPE_ID
{
    NONE_DEVICE = 0,
    PPL398_DEVICE = 2,
    PPL500_DEVICE = 5,
    PPL501F_DEVICE = 7,
    PPLC700_DEVICE = 3,
    PPE640_DEVICE = 4,
};

enum API_RETURN_ID
{
    ARI_SUCCESS = 0,
    ARI_FAIL = -1,
    ARI_INVALID_PARAMETERS = -2,
    ARI_DRIVER_INIT_FAIL = -3,
    ARI_DRIVER_OPEN_DEVICE_FAIL = -4,
    ARI_DRIVER_CLAIM_INTERFACE_FAIL = -5,
    ARI_DRIVER_CREATE_THREAD_FAIL = -6,
    ARI_DRIVER_SENT_CMD_FAIL = -7,
    ARI_INK_EMPTY = -8,
    ARI_SAVE_FAILE = -9,

};

typedef struct _PACKETS
{
    int nIndex;
    short nX;
    short nY;
    short nPressureValue;
    bool bStrokeEnd;

} PACKETS, *PPACKETS;

#define UNUSED(x)   (void)(x)
#define RX_DEVICE_DATA_MAX_SIZE 32

#define SIGNPAD_ENTER_BUTTON    1
#define SIGNPAD_CANCEL_BUTTON   0
#define MAX_PATH    256
#define SIGN_CANVAS_WIDTH    710
#define SIGN_CANVAS_HEIGHT   430

typedef void (*NOTIFYSIGNSTATUS)(int nEventID);
typedef void (*NOTIFYREALTIMESIGNDATA)(WPARAM wParam, LPARAM lParam);

// declare APIs...

// ==================================
// L398 APIs...
// ==================================
//
typedef bool (*PPL398_InitialDeviceByWId)(int nDeviceType, WId parentWId, int nX, int nY, int nWidth, int nHeight);
typedef bool (*PPL398_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPL398_UnInitialDevice)(int nDeviceType);
typedef int (*PPL398_OpenLCD)(int nDeviceType, bool bOn);
typedef int (*PPL398_Clear)(int nDeviceType);
typedef int (*PPL398_GetHWPenID)(int nDeviceType, char* pPenID, int nMaxCount);
typedef int (*PPL398_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPL398_GetHWVersionID)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPL398_DisplayHWVersion)(int nDeviceType, bool bOn);
typedef int (*PPL398_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPL398_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPL398_SignatureStatusCallback)(int nDeviceType, NOTIFYSIGNSTATUS pStatus);
typedef int (*PPL398_GetTotalPacketsNumber)(int nDeviceType);
typedef int (*PPL398_getPackets)(int nDeviceType, PACKETS& currentInkPoint);
typedef char* (*PPL398_GetInkPointTime)(int nDeviceType, int nIndex);
typedef void (*PPL398_FreeInkPointTime)(int nDeviceType, char* pInkPointTime);
typedef int (*PPL398_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPL398_SetSaveCenterImageClip)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPL398_getDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPL398_AboutBoxByWId)(WId parentWId);
typedef void (*PPL398_AboutBox)(QWidget *pParent);
typedef char* (*PPL398_PacketsBase64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPL398_PacketsBase64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPL398_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPL398_GetTotalDecodePacketsNumber)(int nDeviceType);
typedef int (*PPL398_GetDecodePacketsData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPL398_SetPenColor)(int nDeviceType, int nR, int nG, int nB);
typedef bool (*PPL398_RealTimeSignatureDataCallback)(int nDeviceType, NOTIFYREALTIMESIGNDATA pfnRealTimeSignDataCallback);

// ==================================
// L500 APIs...
// ==================================
//
typedef bool (*PPL500_InitialDeviceByWId)(int nDeviceType, WId parentWId, int nX, int nY, int nWidth, int nHeight);
typedef bool (*PPL500_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPL500_UnInitialDevice)(int nDeviceType);
typedef int (*PPL500_OpenLCD)(int nDeviceType, bool bOn);
typedef int (*PPL500_Clear)(int nDeviceType);
typedef int (*PPL500_GetHWPenID)(int nDeviceType, char* pPenID, int nMaxCount);
typedef int (*PPL500_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPL500_GetHWVersionID)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPL500_DisplayHWVersion)(int nDeviceType, bool bOn);
typedef int (*PPL500_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPL500_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPL500_SignatureStatusCallback)(int nDeviceType, NOTIFYSIGNSTATUS pStatus);
typedef int (*PPL500_GetTotalPacketsNumber)(int nDeviceType);
typedef int (*PPL500_getPackets)(int nDeviceType, PACKETS& currentInkPoint);
typedef char* (*PPL500_GetInkPointTime)(int nDeviceType, int nIndex);
typedef void (*PPL500_FreeInkPointTime)(int nDeviceType, char* pInkPointTime);
typedef int (*PPL500_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPL500_SetSaveCenterImageClip)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPL500_getDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPL500_AboutBoxByWId)(WId parentWId);
typedef void (*PPL500_AboutBox)(QWidget *pParent);
typedef char* (*PPL500_PacketsBase64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPL500_PacketsBase64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPL500_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPL500_GetTotalDecodePacketsNumber)(int nDeviceType);
typedef int (*PPL500_GetDecodePacketsData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPL500_SetPenColor)(int nDeviceType, int nR, int nG, int nB);
typedef bool (*PPL500_RealTimeSignatureDataCallback)(int nDeviceType, NOTIFYREALTIMESIGNDATA pfnRealTimeSignDataCallback);

// ==================================
// L501F APIs...
// ==================================
typedef bool (*PPL501F_InitialDeviceByWId)(int nDeviceType, WId parentWId, int nX, int nY, int nWidth, int nHeight);
typedef bool (*PPL501F_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPL501F_UnInitialDevice)(int nDeviceType);
typedef int (*PPL501F_OpenLCD)(int nDeviceType, bool bOn);
typedef int (*PPL501F_Clear)(int nDeviceType);
typedef int (*PPL501F_GetHWPenID)(int nDeviceType, char* pPenID, int nMaxCount);
typedef int (*PPL501F_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPL501F_GetHWVersionID)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPL501F_DisplayHWVersion)(int nDeviceType, bool bOn);
typedef int (*PPL501F_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPL501F_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPL501F_SignatureStatusCallback)(int nDeviceType, NOTIFYSIGNSTATUS pStatus);
typedef int (*PPL501F_GetTotalPacketsNumber)(int nDeviceType);
typedef int (*PPL501F_getPackets)(int nDeviceType, PACKETS& currentInkPoint);
typedef char* (*PPL501F_GetInkPointTime)(int nDeviceType, int nIndex);
typedef void (*PPL501F_FreeInkPointTime)(int nDeviceType, char* pInkPointTime);
typedef int (*PPL501F_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPL501F_SetSaveCenterImageClip)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPL501F_getDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPL501F_AboutBoxByWId)(WId parentWId);
typedef void (*PPL501F_AboutBox)(QWidget *pParent);
typedef char* (*PPL501F_PacketsBase64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPL501F_PacketsBase64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPL501F_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPL501F_GetTotalDecodePacketsNumber)(int nDeviceType);
typedef int (*PPL501F_GetDecodePacketsData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPL501F_SetPenColor)(int nDeviceType, int nR, int nG, int nB);
typedef int (* PPL501F_SetDisplayedFPImageAtByWId)(int nDeviceType, WId parentWId, int nCanvasWidth, int nCanvasHeight, int nFPLeft, int nFPTop, int nFPWidth, int nFPHeight);
typedef int (* PPL501F_SetDisplayedFPImageAt)(int nDeviceType, QWidget *pParentWidget, int nCanvasWidth, int nCanvasHeight, int nFPLeft, int nFPTop, int nFPWidth, int nFPHeight);
typedef char* (*PPL501F_GetFPImageBase64Data)(int nDeviceType, int nImageTypeID, bool bFPImageOnly);
typedef void (*PPL501F_FreeFPImageBase64Data)(int nDeviceType, char* pFPImageBase64Data);
typedef bool (*PPL501F_RealTimeSignatureDataCallback)(int nDeviceType, NOTIFYREALTIMESIGNDATA pfnRealTimeSignDataCallback);

// ==================================
// LC700 APIs...
// ==================================
//
typedef bool (*PPLC700_InitialDeviceByWId)(int nDeviceType, WId parentWId, int nX, int nY, int nWidth, int nHeight);
typedef bool (*PPLC700_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPLC700_UnInitialDevice)(int nDeviceType);
typedef int (*PPLC700_Clear)(int nDeviceType);
typedef int (*PPLC700_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPLC700_GetHWVersionID)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPLC700_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPLC700_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPLC700_SignatureStatusCallback)(int nDeviceType, NOTIFYSIGNSTATUS pStatus);
typedef int (*PPLC700_GetTotalPacketsNumber)(int nDeviceType);
typedef int (*PPLC700_getPackets)(int nDeviceType, PACKETS& currentInkPoint);
typedef char* (*PPLC700_GetInkPointTime)(int nDeviceType, int nIndex);
typedef void (*PPLC700_FreeInkPointTime)(int nDeviceType, char* pInkPointTime);
typedef int (*PPLC700_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPLC700_SetSaveCenterImageClip)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPLC700_getDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPLC700_AboutBoxByWId)(WId parentWId);
typedef void (*PPLC700_AboutBox)(QWidget *pParent);
typedef char* (*PPLC700_PacketsBase64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPLC700_PacketsBase64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPLC700_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPLC700_GetTotalDecodePacketsNumber)(int nDeviceType);
typedef int (*PPLC700_GetDecodePacketsData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPLC700_SetPenColor)(int nDeviceType, int nR, int nG, int nB);
typedef bool (*PPLC700_RealTimeSignatureDataCallback)(int nDeviceType, NOTIFYREALTIMESIGNDATA pfnRealTimeSignDataCallback);

// ==================================
// E640 APIs...
// ==================================
//
typedef bool (*PPE640_InitialDeviceByWId)(int nDeviceType, WId parentWId, int nX, int nY, int nWidth, int nHeight);
typedef bool (*PPE640_InitialDevice)(int nDeviceType, QWidget *pParentWidget, int nX, int nY, int nWidth, int nHeight);
typedef int (*PPE640_UnInitialDevice)(int nDeviceType);
typedef int (*PPE640_Clear)(int nDeviceType);
typedef int (*PPE640_GetHWPadID)(int nDeviceType, char* pPadID, int nMaxCount);
typedef int (*PPE640_GetHWVersionID)(int nDeviceType, char* pVersion, int nMaxCount);
typedef int (*PPE640_SetPenStyle)(int nDeviceType, bool bPressureOn);
typedef int (*PPE640_SetPenWidth)(int nDeviceType, int nPenWidth);
typedef int (*PPE640_SignatureStatusCallback)(int nDeviceType, NOTIFYSIGNSTATUS pStatus);
typedef int (*PPE640_GetTotalPacketsNumber)(int nDeviceType);
typedef int (*PPE640_getPackets)(int nDeviceType, PACKETS& currentInkPoint);
typedef char* (*PPE640_GetInkPointTime)(int nDeviceType, int nIndex);
typedef void (*PPE640_FreeInkPointTime)(int nDeviceType, char* pInkPointTime);
typedef int (*PPE640_SaveDrawingImage)(int nDeviceType, int nImageTypeID, wchar_t* pImageFilePath, int nDPILevel);
typedef int (*PPE640_SetSaveCenterImageClip)(int nDeviceType, bool bClipImage, int nClipMarginX, int nClipMarginY);
typedef int (*PPE640_getDeviceInfo)(int nDeviceType, int nIndex, void* pOutput);
typedef void (*PPE640_AboutBoxByWId)(WId parentWId);
typedef void (*PPE640_AboutBox)(QWidget *pParent);
typedef char* (*PPE640_PacketsBase64Encode)(int nDeviceType, int nImageTypeID);
typedef void (*PPE640_PacketsBase64EncodeFree)(int nDeviceType, char* pData);
typedef int (*PPE640_Base64Decode)(int nDeviceType, int nImageTypeID, const char* pEncodedData, wchar_t* pImageFilePath);
typedef int (*PPE640_GetTotalDecodePacketsNumber)(int nDeviceType);
typedef int (*PPE640_GetDecodePacketsData)(int nDeviceType, int nIndex, int nTypeID);
typedef int (*PPE640_SetPenColor)(int nDeviceType, int nR, int nG, int nB);
typedef bool (*PPE640_RealTimeSignatureDataCallback)(int nDeviceType, NOTIFYREALTIMESIGNDATA pfnRealTimeSignDataCallback);

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow();
    bool LoadPPSignPadSDK();
    void ProcessSignPadEvent(int nEventID);
    void ProcessRealTimeSignatureData(WPARAM wParam, LPARAM lParam);

private slots:
    void on_InitButton_clicked();
    void on_UnInitButton_clicked();
    void on_ClearButton_clicked();
    void on_OpenLCDButton_clicked();
    void on_CloseLCDButton_clicked();
    void on_PenIDButton_clicked();
    void on_PadIDButton_clicked();
    void on_HWVersionButton_clicked();
    void on_cbPenWidth_currentIndexChanged(int index);
    void on_GetSizeButton_clicked();
    void on_GetPointButton_clicked();
    void on_EncodeButton_clicked();
    void on_DecodeButton_clicked();
    void on_AboutButton_clicked();
    void on_getDeviceInfoButton_clicked();
    void on_SetClipMarginButton_clicked();
    void on_SaveDrawingImageButton_clicked();
    void on_ShowVersionOnDeviceButton_clicked();
    void on_cbPenStyle_currentIndexChanged(int index);
    void on_cbSelectDevice_currentIndexChanged(int index);
    void on_cbPenColor_currentIndexChanged(int index);

private:
    Ui::MainWindow *ui;
    QLibrary *m_plibPPSignPadSDK;

    // ==================================
    // L398 APIs...
    // ==================================
    //
    PPL398_InitialDeviceByWId m_pfn_PPL398_InitialDeviceByWId;
    PPL398_InitialDevice m_pfn_PPL398_InitialDevice;
    PPL398_UnInitialDevice m_pfn_PPL398_UnInitialDevice;
    PPL398_OpenLCD m_pfn_PPL398_OpenLCD;
    PPL398_Clear m_pfn_PPL398_Clear;
    PPL398_GetHWPenID m_pfn_PPL398_GetHWPenID;
    PPL398_GetHWPadID m_pfn_PPL398_GetHWPadID;
    PPL398_GetHWVersionID m_pfn_PPL398_GetHWVersionID;
    PPL398_DisplayHWVersion m_pfn_PPL398_DisplayHWVersion;
    PPL398_SetPenStyle m_pfn_PPL398_SetPenStyle;
    PPL398_SetPenWidth m_pfn_PPL398_SetPenWidth;
    PPL398_SignatureStatusCallback m_pfn_PPL398_SignatureStatusCallback;
    PPL398_GetTotalPacketsNumber m_pfn_PPL398_GetTotalPacketsNumber;
    PPL398_getPackets m_pfn_PPL398_getPackets;
    PPL398_GetInkPointTime m_pfn_PPL398_GetInkPointTime;
    PPL398_FreeInkPointTime m_pfn_PPL398_FreeInkPointTime;
    PPL398_SaveDrawingImage m_pfn_PPL398_SaveDrawingImage;
    PPL398_SetSaveCenterImageClip m_pfn_PPL398_SetSaveCenterImageClip;
    PPL398_getDeviceInfo m_pfn_PPL398_getDeviceInfo;
    PPL398_AboutBoxByWId m_pfn_PPL398_AboutBoxByWId;
    PPL398_AboutBox m_pfn_PPL398_AboutBox;
    PPL398_PacketsBase64Encode m_pfn_PPL398_PacketsBase64Encode;
    PPL398_PacketsBase64EncodeFree m_pfn_PPL398_PacketsBase64EncodeFree;
    PPL398_Base64Decode m_pfn_PPL398_Base64Decode;
    PPL398_GetTotalDecodePacketsNumber m_pfn_PPL398_GetTotalDecodePacketsNumber;
    PPL398_GetDecodePacketsData m_pfn_PPL398_GetDecodePacketsData;
    PPL398_SetPenColor m_pfn_PPL398_SetPenColor;
    PPL398_RealTimeSignatureDataCallback m_pfn_PPL398_RealTimeSignatureDataCallback;

    // ==================================
    // L500 APIs...
    // ==================================
    //
    PPL500_InitialDeviceByWId m_pfn_PPL500_InitialDeviceByWId;
    PPL500_InitialDevice m_pfn_PPL500_InitialDevice;
    PPL500_UnInitialDevice m_pfn_PPL500_UnInitialDevice;
    PPL500_OpenLCD m_pfn_PPL500_OpenLCD;
    PPL500_Clear m_pfn_PPL500_Clear;
    PPL500_GetHWPenID m_pfn_PPL500_GetHWPenID;
    PPL500_GetHWPadID m_pfn_PPL500_GetHWPadID;
    PPL500_GetHWVersionID m_pfn_PPL500_GetHWVersionID;
    PPL500_DisplayHWVersion m_pfn_PPL500_DisplayHWVersion;
    PPL500_SetPenStyle m_pfn_PPL500_SetPenStyle;
    PPL500_SetPenWidth m_pfn_PPL500_SetPenWidth;
    PPL500_SignatureStatusCallback m_pfn_PPL500_SignatureStatusCallback;
    PPL500_GetTotalPacketsNumber m_pfn_PPL500_GetTotalPacketsNumber;
    PPL500_getPackets m_pfn_PPL500_getPackets;
    PPL500_GetInkPointTime m_pfn_PPL500_GetInkPointTime;
    PPL500_FreeInkPointTime m_pfn_PPL500_FreeInkPointTime;
    PPL500_SaveDrawingImage m_pfn_PPL500_SaveDrawingImage;
    PPL500_SetSaveCenterImageClip m_pfn_PPL500_SetSaveCenterImageClip;
    PPL500_getDeviceInfo m_pfn_PPL500_getDeviceInfo;
    PPL500_AboutBoxByWId m_pfn_PPL500_AboutBoxByWId;
    PPL500_AboutBox m_pfn_PPL500_AboutBox;
    PPL500_PacketsBase64Encode m_pfn_PPL500_PacketsBase64Encode;
    PPL500_PacketsBase64EncodeFree m_pfn_PPL500_PacketsBase64EncodeFree;
    PPL500_Base64Decode m_pfn_PPL500_Base64Decode;
    PPL500_GetTotalDecodePacketsNumber m_pfn_PPL500_GetTotalDecodePacketsNumber;
    PPL500_GetDecodePacketsData m_pfn_PPL500_GetDecodePacketsData;
    PPL500_SetPenColor m_pfn_PPL500_SetPenColor;
    PPL500_RealTimeSignatureDataCallback m_pfn_PPL500_RealTimeSignatureDataCallback;

    // ==================================
    // L501F APIs...
    // ==================================
    //
    PPL501F_InitialDeviceByWId m_pfn_PPL501F_InitialDeviceByWId;
    PPL501F_InitialDevice m_pfn_PPL501F_InitialDevice;
    PPL501F_UnInitialDevice m_pfn_PPL501F_UnInitialDevice;
    PPL501F_OpenLCD m_pfn_PPL501F_OpenLCD;
    PPL501F_Clear m_pfn_PPL501F_Clear;
    PPL501F_GetHWPenID m_pfn_PPL501F_GetHWPenID;
    PPL501F_GetHWPadID m_pfn_PPL501F_GetHWPadID;
    PPL501F_GetHWVersionID m_pfn_PPL501F_GetHWVersionID;
    PPL501F_DisplayHWVersion m_pfn_PPL501F_DisplayHWVersion;
    PPL501F_SetPenStyle m_pfn_PPL501F_SetPenStyle;
    PPL501F_SetPenWidth m_pfn_PPL501F_SetPenWidth;
    PPL501F_SignatureStatusCallback m_pfn_PPL501F_SignatureStatusCallback;
    PPL501F_GetTotalPacketsNumber m_pfn_PPL501F_GetTotalPacketsNumber;
    PPL501F_getPackets m_pfn_PPL501F_getPackets;
    PPL501F_GetInkPointTime m_pfn_PPL501F_GetInkPointTime;
    PPL501F_FreeInkPointTime m_pfn_PPL501F_FreeInkPointTime;
    PPL501F_SaveDrawingImage m_pfn_PPL501F_SaveDrawingImage;
    PPL501F_SetSaveCenterImageClip m_pfn_PPL501F_SetSaveCenterImageClip;
    PPL501F_getDeviceInfo m_pfn_PPL501F_getDeviceInfo;
    PPL501F_AboutBoxByWId m_pfn_PPL501F_AboutBoxByWId;
    PPL501F_AboutBox m_pfn_PPL501F_AboutBox;
    PPL501F_PacketsBase64Encode m_pfn_PPL501F_PacketsBase64Encode;
    PPL501F_PacketsBase64EncodeFree m_pfn_PPL501F_PacketsBase64EncodeFree;
    PPL501F_Base64Decode m_pfn_PPL501F_Base64Decode;
    PPL501F_GetTotalDecodePacketsNumber m_pfn_PPL501F_GetTotalDecodePacketsNumber;
    PPL501F_GetDecodePacketsData m_pfn_PPL501F_GetDecodePacketsData;
    PPL501F_SetPenColor m_pfn_PPL501F_SetPenColor;
    PPL501F_SetDisplayedFPImageAtByWId m_pfn_PPL501F_SetDisplayedFPImageAtByWId;
    PPL501F_SetDisplayedFPImageAt m_pfn_PPL501F_SetDisplayedFPImageAt;
    PPL501F_GetFPImageBase64Data m_pfn_PPL501F_GetFPImageBase64Data;
    PPL501F_FreeFPImageBase64Data m_pfn_PPL501F_FreeFPImageBase64Data;
    PPL501F_RealTimeSignatureDataCallback m_pfn_PPL501F_RealTimeSignatureDataCallback;

    // ==================================
    // LC700 APIs...
    // ==================================
    //
    PPLC700_InitialDeviceByWId m_pfn_PPLC700_InitialDeviceByWId;
    PPLC700_InitialDevice m_pfn_PPLC700_InitialDevice;
    PPLC700_UnInitialDevice m_pfn_PPLC700_UnInitialDevice;
    PPLC700_Clear m_pfn_PPLC700_Clear;
    PPLC700_GetHWPadID m_pfn_PPLC700_GetHWPadID;
    PPLC700_GetHWVersionID m_pfn_PPLC700_GetHWVersionID;
    PPLC700_SetPenStyle m_pfn_PPLC700_SetPenStyle;
    PPLC700_SetPenWidth m_pfn_PPLC700_SetPenWidth;
    PPLC700_SignatureStatusCallback m_pfn_PPLC700_SignatureStatusCallback;
    PPLC700_GetTotalPacketsNumber m_pfn_PPLC700_GetTotalPacketsNumber;
    PPLC700_getPackets m_pfn_PPLC700_getPackets;
    PPLC700_GetInkPointTime m_pfn_PPLC700_GetInkPointTime;
    PPLC700_FreeInkPointTime m_pfn_PPLC700_FreeInkPointTime;
    PPLC700_SaveDrawingImage m_pfn_PPLC700_SaveDrawingImage;
    PPLC700_SetSaveCenterImageClip m_pfn_PPLC700_SetSaveCenterImageClip;
    PPLC700_getDeviceInfo m_pfn_PPLC700_getDeviceInfo;
    PPLC700_AboutBoxByWId m_pfn_PPLC700_AboutBoxByWId;
    PPLC700_AboutBox m_pfn_PPLC700_AboutBox;
    PPLC700_PacketsBase64Encode m_pfn_PPLC700_PacketsBase64Encode;
    PPLC700_PacketsBase64EncodeFree m_pfn_PPLC700_PacketsBase64EncodeFree;
    PPLC700_Base64Decode m_pfn_PPLC700_Base64Decode;
    PPLC700_GetTotalDecodePacketsNumber m_pfn_PPLC700_GetTotalDecodePacketsNumber;
    PPLC700_GetDecodePacketsData m_pfn_PPLC700_GetDecodePacketsData;
    PPLC700_SetPenColor m_pfn_PPLC700_SetPenColor;
    PPLC700_RealTimeSignatureDataCallback m_pfn_PPLC700_RealTimeSignatureDataCallback;

    // ==================================
    // E640 APIs...
    // ==================================
    //
    PPE640_InitialDeviceByWId m_pfn_PPE640_InitialDeviceByWId;
    PPE640_InitialDevice m_pfn_PPE640_InitialDevice;
    PPE640_UnInitialDevice m_pfn_PPE640_UnInitialDevice;
    PPE640_Clear m_pfn_PPE640_Clear;
    PPE640_GetHWPadID m_pfn_PPE640_GetHWPadID;
    PPE640_GetHWVersionID m_pfn_PPE640_GetHWVersionID;
    PPE640_SetPenStyle m_pfn_PPE640_SetPenStyle;
    PPE640_SetPenWidth m_pfn_PPE640_SetPenWidth;
    PPE640_SignatureStatusCallback m_pfn_PPE640_SignatureStatusCallback;
    PPE640_GetTotalPacketsNumber m_pfn_PPE640_GetTotalPacketsNumber;
    PPE640_getPackets m_pfn_PPE640_getPackets;
    PPE640_GetInkPointTime m_pfn_PPE640_GetInkPointTime;
    PPE640_FreeInkPointTime m_pfn_PPE640_FreeInkPointTime;
    PPE640_SaveDrawingImage m_pfn_PPE640_SaveDrawingImage;
    PPE640_SetSaveCenterImageClip m_pfn_PPE640_SetSaveCenterImageClip;
    PPE640_getDeviceInfo m_pfn_PPE640_getDeviceInfo;
    PPE640_AboutBoxByWId m_pfn_PPE640_AboutBoxByWId;
    PPE640_AboutBox m_pfn_PPE640_AboutBox;
    PPE640_PacketsBase64Encode m_pfn_PPE640_PacketsBase64Encode;
    PPE640_PacketsBase64EncodeFree m_pfn_PPE640_PacketsBase64EncodeFree;
    PPE640_Base64Decode m_pfn_PPE640_Base64Decode;
    PPE640_GetTotalDecodePacketsNumber m_pfn_PPE640_GetTotalDecodePacketsNumber;
    PPE640_GetDecodePacketsData m_pfn_PPE640_GetDecodePacketsData;
    PPE640_SetPenColor m_pfn_PPE640_SetPenColor;
    PPE640_RealTimeSignatureDataCallback m_pfn_PPE640_RealTimeSignatureDataCallback;

    bool m_bShowHWVersion;
    int m_nSelectedDeviceID;
    QMutex m_mutex;

protected:
    void closeEvent(QCloseEvent *event);

signals:
    void RealTimeDataAvailable(int nX, int nY, int nP, bool bPenDown);

public slots:
    void StartDecodeRealTimeData(int nX, int nY, int nP, bool bPenDown);
};

#endif // MAINWINDOW_H
