#=====================================================
# -*- coding: utf-8 -*-
# author : Julio - PenPower Digital Development Dept.
# Creation : 2024.09.16.
# Target Platform : Python v2.x Runtime Environment
#=====================================================

from enum import Enum
from ctypes import *
from structdefs import *

#--------------------------------------------------------------------------
# PPL500 APIs Definitions
#--------------------------------------------------------------------------
#
#==========================================================================
# PPL500_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight)
#==========================================================================
def API_PPL500_InitialDevice():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_InitialDevice
    func.argtypes = [c_int32, c_void_p, c_int32, c_int32, c_int32, c_int32]
    func.restype = c_bool
    return func

__PPL500_InitialDevice = API_PPL500_InitialDevice()

def PPL500_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight):
    m_deviceID = c_int32(deviceID)
    m_pWidget = cast(widgetPtr, c_void_p)
    m_x = c_int32(x)
    m_y = c_int32(y)
    m_Width = c_int32(nWidth)
    m_Height = c_int32(nHeight)
    m_bResult = c_bool()
    m_bResult = __PPL500_InitialDevice(m_deviceID, m_pWidget, m_x, m_y, m_Width, m_Height)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPL500_UnInitialDevice(deviceID)
#==========================================================================
def API_PPL500_UnInitialDevice():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_UnInitialDevice
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL500_UnInitialDevice = API_PPL500_UnInitialDevice()

def PPL500_UnInitialDevice(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL500_UnInitialDevice(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_AboutBox(widgetPtr)
#==========================================================================
def API_PPL500_AboutBox():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_AboutBox
    func.argtypes = [c_void_p]
    return func

__PPL500_AboutBox = API_PPL500_AboutBox()

def PPL500_AboutBox(widgetPtr):
    m_pWidget = cast(widgetPtr, c_void_p)
    __PPL500_AboutBox(m_pWidget)
#==========================================================================
#
#==========================================================================
# PPL500_SetPenColor(deviceID, nR, nG, nB)
#==========================================================================
def API_PPL500_SetPenColor():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_SetPenColor
    func.argtypes = [c_int32, c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL500_SetPenColor = API_PPL500_SetPenColor()

def PPL500_SetPenColor(deviceID, nR, nG, nB):
    m_deviceID = c_int32(deviceID)
    m_nR = c_int32(nR)
    m_nG = c_int32(nG)
    m_nB = c_int32(nB)
    m_nResult = c_int32()
    m_nResult = __PPL500_SetPenColor(m_deviceID, m_nR, m_nG, m_nB)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_SetPenWidth(deviceID, nWidth)
#==========================================================================
def API_PPL500_SetPenWidth():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_SetPenWidth
    func.argtypes = [c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL500_SetPenWidth = API_PPL500_SetPenWidth()

def PPL500_SetPenWidth(deviceID, nWidth):
    m_deviceID = c_int32(deviceID)
    m_nWidth = c_int32(nWidth)
    m_nResult = c_int32()
    m_nResult = __PPL500_SetPenWidth(m_deviceID, m_nWidth)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_SetPenStyle(deviceID, bPressureOn)
#==========================================================================
def API_PPL500_SetPenStyle():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_SetPenStyle
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL500_SetPenStyle = API_PPL500_SetPenStyle()

def PPL500_SetPenStyle(deviceID, bPressureOn):
    m_deviceID = c_int32(deviceID)
    m_bPressureOn = c_bool(bPressureOn)
    m_nResult = c_int32()
    m_nResult = __PPL500_SetPenStyle(m_deviceID, m_bPressureOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_Clear(deviceID)
#==========================================================================
def API_PPL500_Clear():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_Clear
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL500_Clear = API_PPL500_Clear()

def PPL500_Clear(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL500_Clear(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_PacketsBase64Encode(deviceID, nImageTypeID)
#==========================================================================
def API_PPL500_PacketsBase64Encode():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_PacketsBase64Encode
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPL500_PacketsBase64Encode = API_PPL500_PacketsBase64Encode()

def PPL500_PacketsBase64Encode(deviceID, nImageTypeID):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pChar = POINTER(c_char)
    m_pChar = __PPL500_PacketsBase64Encode(m_deviceID, m_nImageTypeID)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPL500_PacketsBase64EncodeFree(deviceID, pData)
#==========================================================================
def API_PPL500_PacketsBase64EncodeFree():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_PacketsBase64EncodeFree
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPL500_PacketsBase64EncodeFree = API_PPL500_PacketsBase64EncodeFree()

def PPL500_PacketsBase64EncodeFree(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPL500_PacketsBase64EncodeFree(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPL500_GetTotalPacketsNumber(deviceID)
#==========================================================================
def PPL500_GetTotalPacketsNumber():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_GetTotalPacketsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL500_GetTotalPacketsNumber = PPL500_GetTotalPacketsNumber()

def PPL500_GetTotalPacketsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetTotalPacketsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath)
#==========================================================================
def API_PPL500_Base64Decode():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_Base64Decode
    func.argtypes = [c_int32, c_int32, c_char_p, c_wchar_p]
    func.restype = c_int32
    return func

__PPL500_Base64Decode = API_PPL500_Base64Decode()

def PPL500_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pEncodeString = c_char_p(encodeString)
    m_pwDecodeFilePath = wDecodeFilePath
    m_nResult = c_int32()
    m_nResult = __PPL500_Base64Decode(m_deviceID, m_nImageTypeID, m_pEncodeString, m_pwDecodeFilePath)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetDecodePacketsData(deviceID, nIndex, nTypeID)
#==========================================================================
def API_PPL500_GetDecodePacketsData():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_GetDecodePacketsData
    func.argtypes = [c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL500_GetDecodePacketsData = API_PPL500_GetDecodePacketsData()

def PPL500_GetDecodePacketsData(deviceID, nIndex, nTypeID):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_nTypeID = c_int32(nTypeID)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetDecodePacketsData(m_deviceID, m_nIndex, m_nTypeID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetTotalDecodePacketsNumber(deviceID)
#==========================================================================
def API_PPL500_GetTotalDecodePacketsNumber():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_GetTotalDecodePacketsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL500_GetTotalDecodePacketsNumber = API_PPL500_GetTotalDecodePacketsNumber()

def PPL500_GetTotalDecodePacketsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetTotalDecodePacketsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_SetSaveCenterImageClip(deviceID, bClipImage, nClipMarginX, nClipMarginY)
#==========================================================================
def API_PPL500_SetSaveCenterImageClip():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_SetSaveCenterImageClip
    func.argtypes = [c_int32, c_bool, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL500_SetSaveCenterImageClip = API_PPL500_SetSaveCenterImageClip()

def PPL500_SetSaveCenterImageClip(deviceID, bClipImage, nClipMarginX, nClipMarginY):
    m_deviceID = c_int32(deviceID)
    m_bClipImage = c_bool(bClipImage)
    m_nClipMarginX = c_int32(nClipMarginX)
    m_nClipMarginY = c_int32(nClipMarginY)
    m_bResult = c_int32()
    m_bResult = __PPL500_SetSaveCenterImageClip(m_deviceID, m_bClipImage, m_nClipMarginX, m_nClipMarginY)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPL500_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel)
#==========================================================================
def API_PPL500_SaveDrawingImage():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_SaveDrawingImage
    func.argtypes = [c_int32, c_int32, c_wchar_p, c_int32]
    func.restype = c_int32
    return func

__PPL500_SaveDrawingImage = API_PPL500_SaveDrawingImage()

def PPL500_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pwImageFilePath = pwImageFilePath
    m_nDPILevel = c_int32(nDPILevel)
    m_nResult = c_int32()
    m_nResult = __PPL500_SaveDrawingImage(m_deviceID, m_nImageTypeID, m_pwImageFilePath, m_nDPILevel)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_getPackets(deviceID, currentInkPoint)
#==========================================================================
def API_PPL500_getPackets():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_getPackets
    func.argtypes = [c_int32, POINTER(PACKETS)]
    func.restype = c_int32
    return func

__PPL500_getPackets = API_PPL500_getPackets()

def PPL500_getPackets(deviceID, currentInkPoint):
    m_deviceID = c_int32(deviceID)
    m_pCurrentInkPoint = byref(currentInkPoint)
    m_nResult = c_int32()
    m_nResult = __PPL500_getPackets(m_deviceID, m_pCurrentInkPoint)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetInkPointTime(deviceID, nIndex)
#==========================================================================
def API_PPL500_GetInkPointTime():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_GetInkPointTime
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPL500_GetInkPointTime = API_PPL500_GetInkPointTime()

def PPL500_GetInkPointTime(deviceID, nIndex):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pChar = POINTER(c_char)
    m_pChar = __PPL500_GetInkPointTime(m_deviceID, m_nIndex)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPL500_FreeInkPointTime(deviceID, pData)
#==========================================================================
def API_PPL500_FreeInkPointTime():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_FreeInkPointTime
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPL500_FreeInkPointTime = API_PPL500_FreeInkPointTime()

def PPL500_FreeInkPointTime(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPL500_FreeInkPointTime(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPL500_getDeviceInfo(deviceID, nIndex, Output)
#==========================================================================
def API_PPL500_getDeviceInfo():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_getDeviceInfo
    func.argtypes = [c_int32, c_int32, c_void_p]
    func.restype = c_int32
    return func

__PPL500_getDeviceInfo = API_PPL500_getDeviceInfo()

def PPL500_getDeviceInfo(deviceID, nIndex, Output):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pOutput = byref(Output)
    m_nResult = c_int32()
    m_nResult = __PPL500_getDeviceInfo(m_deviceID, m_nIndex, m_pOutput)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_SignatureStatusCallback(deviceID, NOTIFYSIGNSTATUS pSignatureStatusCallback)
#==========================================================================
def API_PPL500_SignatureStatusCallback():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_SignatureStatusCallback
    func.argtypes = [c_int32, NOTIFYSIGNSTATUS]
    func.restype = c_int32
    return func

__PPL500_SignatureStatusCallback = API_PPL500_SignatureStatusCallback()

def PPL500_SignatureStatusCallback(deviceID, pSignatureStatusCallback):
    m_deviceID = c_int32(deviceID)
    m_pSignatureStatusCallback = pSignatureStatusCallback
    m_nResult = c_int32()
    m_nResult = __PPL500_SignatureStatusCallback(m_deviceID, m_pSignatureStatusCallback)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetHWPenID(deviceID, pPenID, nMaxCount)
#==========================================================================
def API_PPL500_GetHWPenID():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_GetHWPenID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL500_GetHWPenID = API_PPL500_GetHWPenID()

def PPL500_GetHWPenID(deviceID, pPenID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPenID = byref(pPenID)
    m_nMaxCount = c_int32(nMaxCount)
    m_nResult = c_int32()
    m_nResult = __PPL500_GetHWPenID(m_deviceID, m_pPenID, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetHWVersionID(deviceID, pVersion, nMaxCount)
#==========================================================================
def API_PPL500_GetHWVersionID():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_GetHWVersionID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL500_GetHWVersionID = API_PPL500_GetHWVersionID()

def PPL500_GetHWVersionID(deviceID, pVersion, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pVersion = byref(pVersion)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPL500_GetHWVersionID(m_deviceID, m_pVersion, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_GetHWPadID(deviceID, pPadID, nMaxCount)
#==========================================================================
def API_PPL500_GetHWPadID():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_GetHWPadID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL500_GetHWPadID = API_PPL500_GetHWPadID()

def PPL500_GetHWPadID(deviceID, pPadID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPadID = byref(pPadID)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPL500_GetHWPadID(m_deviceID, m_pPadID, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_DisplayHWVersion(deviceID, bOn)
#==========================================================================
def API_PPL500_DisplayHWVersion():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_DisplayHWVersion
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL500_DisplayHWVersion = API_PPL500_DisplayHWVersion()

def PPL500_DisplayHWVersion(deviceID, bOn):
    m_deviceID = c_int32(deviceID)
    m_bOn = c_bool(bOn)
    m_nResult = c_int32()
    m_nResult = __PPL500_DisplayHWVersion(m_deviceID, m_bOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL500_OpenLCD(deviceID, bOn)
#==========================================================================
def API_PPL500_OpenLCD():
    dll = CDLL('./libppcpsignpadsdk.so')
    func = dll.PPL500_OpenLCD
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL500_OpenLCD = API_PPL500_OpenLCD()

def PPL500_OpenLCD(deviceID, bOn):
    m_deviceID = c_int32(deviceID)
    m_bOn = c_bool(bOn)
    m_nResult = c_int32()
    m_nResult = __PPL500_OpenLCD(m_deviceID, m_bOn)
    return m_nResult
#==========================================================================
