#include "mainwindow.h"
#include "ui_mainwindow.h"

static void *g_pMainWnd = nullptr;

void SignPadEventCallback(int nEventID)
{
    MainWindow *pMainWnd = reinterpret_cast<MainWindow *>(g_pMainWnd);
    if(pMainWnd)
    {
        pMainWnd->ProcessSignPadEvent(nEventID);
    }
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    // initial vairables...
    m_plibPPSignPadSDK = nullptr;

    // ==================================
    // initial L398 APIs...
    // ==================================
    //
    m_pfn_PPL398_InitialDeviceByWId = nullptr;
    m_pfn_PPL398_InitialDevice = nullptr;
    m_pfn_PPL398_UnInitialDevice = nullptr;
    m_pfn_PPL398_OpenLCD = nullptr;
    m_pfn_PPL398_Clear = nullptr;
    m_pfn_PPL398_GetHWPenID = nullptr;
    m_pfn_PPL398_GetHWPadID = nullptr;
    m_pfn_PPL398_GetHWVersion = nullptr;
    m_pfn_PPL398_DisplayHWVersion = nullptr;
    m_pfn_PPL398_SetPenStyle = nullptr;
    m_pfn_PPL398_SetPenWidth = nullptr;
    m_pfn_PPL398_SignPadEventCallback = nullptr;
    m_pfn_PPL398_GetTotalInkPointsNumber = nullptr;
    m_pfn_PPL398_GetInkPointData = nullptr;
    m_pfn_PPL398_GetInkPointDataTimeInfo = nullptr;
    m_pfn_PPL398_FreeInkPointDataTimeInfo = nullptr;
    m_pfn_PPL398_SaveDrawingImage = nullptr;
    m_pfn_PPL398_SetSaveClipImageMargin = nullptr;
    m_pfn_PPL398_GetDeviceInfo = nullptr;
    m_pfn_PPL398_AboutBoxByWId = nullptr;
    m_pfn_PPL398_AboutBox = nullptr;
    m_pfn_PPL398_Base64Encode = nullptr;
    m_pfn_PPL398_Base64EncodeFree = nullptr;
    m_pfn_PPL398_Base64Decode = nullptr;
    m_pfn_PPL398_GetTotalDecodeInkPointsNumber = nullptr;
    m_pfn_PPL398_GetDecodeInkPointData = nullptr;
    m_pfn_PPL398_SetPenColor = nullptr;

    // ==================================
    // initial L500 APIs...
    // ==================================
    //
    m_pfn_PPL500_InitialDeviceByWId = nullptr;
    m_pfn_PPL500_InitialDevice = nullptr;
    m_pfn_PPL500_UnInitialDevice = nullptr;
    m_pfn_PPL500_OpenLCD = nullptr;
    m_pfn_PPL500_Clear = nullptr;
    m_pfn_PPL500_GetHWPenID = nullptr;
    m_pfn_PPL500_GetHWPadID = nullptr;
    m_pfn_PPL500_GetHWVersion = nullptr;
    m_pfn_PPL500_DisplayHWVersion = nullptr;
    m_pfn_PPL500_SetPenStyle = nullptr;
    m_pfn_PPL500_SetPenWidth = nullptr;
    m_pfn_PPL500_SignPadEventCallback = nullptr;
    m_pfn_PPL500_GetTotalInkPointsNumber = nullptr;
    m_pfn_PPL500_GetInkPointData = nullptr;
    m_pfn_PPL500_GetInkPointDataTimeInfo = nullptr;
    m_pfn_PPL500_FreeInkPointDataTimeInfo = nullptr;
    m_pfn_PPL500_SaveDrawingImage = nullptr;
    m_pfn_PPL500_SetSaveClipImageMargin = nullptr;
    m_pfn_PPL500_GetDeviceInfo = nullptr;
    m_pfn_PPL500_AboutBoxByWId = nullptr;
    m_pfn_PPL500_AboutBox = nullptr;
    m_pfn_PPL500_Base64Encode = nullptr;
    m_pfn_PPL500_Base64EncodeFree = nullptr;
    m_pfn_PPL500_Base64Decode = nullptr;
    m_pfn_PPL500_GetTotalDecodeInkPointsNumber = nullptr;
    m_pfn_PPL500_GetDecodeInkPointData = nullptr;
    m_pfn_PPL500_SetPenColor = nullptr;

    // ==================================
    // initial L501F APIs...
    // ==================================
    //
    m_pfn_PPL501F_InitialDeviceByWId = nullptr;
    m_pfn_PPL501F_InitialDevice = nullptr;
    m_pfn_PPL501F_UnInitialDevice = nullptr;
    m_pfn_PPL501F_OpenLCD = nullptr;
    m_pfn_PPL501F_Clear = nullptr;
    m_pfn_PPL501F_GetHWPenID = nullptr;
    m_pfn_PPL501F_GetHWPadID = nullptr;
    m_pfn_PPL501F_GetHWVersion = nullptr;
    m_pfn_PPL501F_DisplayHWVersion = nullptr;
    m_pfn_PPL501F_SetPenStyle = nullptr;
    m_pfn_PPL501F_SetPenWidth = nullptr;
    m_pfn_PPL501F_SignPadEventCallback = nullptr;
    m_pfn_PPL501F_GetTotalInkPointsNumber = nullptr;
    m_pfn_PPL501F_GetInkPointData = nullptr;
    m_pfn_PPL501F_GetInkPointDataTimeInfo = nullptr;
    m_pfn_PPL501F_FreeInkPointDataTimeInfo = nullptr;
    m_pfn_PPL501F_SaveDrawingImage = nullptr;
    m_pfn_PPL501F_SetSaveClipImageMargin = nullptr;
    m_pfn_PPL501F_GetDeviceInfo = nullptr;
    m_pfn_PPL501F_AboutBoxByWId = nullptr;
    m_pfn_PPL501F_AboutBox = nullptr;
    m_pfn_PPL501F_Base64Encode = nullptr;
    m_pfn_PPL501F_Base64EncodeFree = nullptr;
    m_pfn_PPL501F_Base64Decode = nullptr;
    m_pfn_PPL501F_GetTotalDecodeInkPointsNumber = nullptr;
    m_pfn_PPL501F_GetDecodeInkPointData = nullptr;
    m_pfn_PPL501F_SetPenColor = nullptr;
    m_pfn_PPL501F_SetDisplayedFPImageAtByWId = nullptr;
    m_pfn_PPL501F_SetDisplayedFPImageAt = nullptr;

    // ==================================
    // initial LC700 APIs...
    // ==================================
    //
    m_pfn_PPLC700_InitialDeviceByWId = nullptr;
    m_pfn_PPLC700_InitialDevice = nullptr;
    m_pfn_PPLC700_UnInitialDevice = nullptr;
    m_pfn_PPLC700_Clear = nullptr;
    m_pfn_PPLC700_GetHWPadID = nullptr;
    m_pfn_PPLC700_GetHWVersion = nullptr;
    m_pfn_PPLC700_SetPenStyle = nullptr;
    m_pfn_PPLC700_SetPenWidth = nullptr;
    m_pfn_PPLC700_SignPadEventCallback = nullptr;
    m_pfn_PPLC700_GetTotalInkPointsNumber = nullptr;
    m_pfn_PPLC700_GetInkPointData = nullptr;
    m_pfn_PPLC700_GetInkPointDataTimeInfo = nullptr;
    m_pfn_PPLC700_FreeInkPointDataTimeInfo = nullptr;
    m_pfn_PPLC700_SaveDrawingImage = nullptr;
    m_pfn_PPLC700_SetSaveClipImageMargin = nullptr;
    m_pfn_PPLC700_GetDeviceInfo = nullptr;
    m_pfn_PPLC700_AboutBoxByWId = nullptr;
    m_pfn_PPLC700_AboutBox = nullptr;
    m_pfn_PPLC700_Base64Encode = nullptr;
    m_pfn_PPLC700_Base64EncodeFree = nullptr;
    m_pfn_PPLC700_Base64Decode = nullptr;
    m_pfn_PPLC700_GetTotalDecodeInkPointsNumber = nullptr;
    m_pfn_PPLC700_GetDecodeInkPointData = nullptr;
    m_pfn_PPLC700_SetPenColor = nullptr;

    // ==================================
    // initial E640 APIs...
    // ==================================
    //
    m_pfn_PPE640_InitialDeviceByWId = nullptr;
    m_pfn_PPE640_InitialDevice = nullptr;
    m_pfn_PPE640_UnInitialDevice = nullptr;
    m_pfn_PPE640_Clear = nullptr;
    m_pfn_PPE640_GetHWPadID = nullptr;
    m_pfn_PPE640_GetHWVersion = nullptr;
    m_pfn_PPE640_SetPenStyle = nullptr;
    m_pfn_PPE640_SetPenWidth = nullptr;
    m_pfn_PPE640_SignPadEventCallback = nullptr;
    m_pfn_PPE640_GetTotalInkPointsNumber = nullptr;
    m_pfn_PPE640_GetInkPointData = nullptr;
    m_pfn_PPE640_GetInkPointDataTimeInfo = nullptr;
    m_pfn_PPE640_FreeInkPointDataTimeInfo = nullptr;
    m_pfn_PPE640_SaveDrawingImage = nullptr;
    m_pfn_PPE640_SetSaveClipImageMargin = nullptr;
    m_pfn_PPE640_GetDeviceInfo = nullptr;
    m_pfn_PPE640_AboutBoxByWId = nullptr;
    m_pfn_PPE640_AboutBox = nullptr;
    m_pfn_PPE640_Base64Encode = nullptr;
    m_pfn_PPE640_Base64EncodeFree = nullptr;
    m_pfn_PPE640_Base64Decode = nullptr;
    m_pfn_PPE640_GetTotalDecodeInkPointsNumber = nullptr;
    m_pfn_PPE640_GetDecodeInkPointData = nullptr;
    m_pfn_PPE640_SetPenColor = nullptr;

    m_bShowHWVersion = true;

    // disable all buttons except lable, cbSelectDevice, InitButton...
    ui->UnInitButton->setEnabled(false);
    ui->OpenLCDButton->setEnabled(false);
    ui->CloseLCDButton->setEnabled(false);
    ui->ClearButton->setEnabled(false);
    ui->GetSizeButton->setEnabled(false);
    ui->GetPointButton->setEnabled(false);
    ui->cbGetPoint->setEnabled(false);
    ui->PenIDButton->setEnabled(false);
    ui->PadIDButton->setEnabled(false);
    ui->EncodeButton->setEnabled(false);
    ui->cbEncode->setEnabled(false);
    ui->DecodeButton->setEnabled(false);
    ui->AboutButton->setEnabled(false);
    ui->HWVersionButton->setEnabled(false);
    ui->ShowVersionOnDeviceButton->setEnabled(false);
    ui->cbPenStyle->setEnabled(false);
    ui->cbPenWidth->setEnabled(false);
    ui->GetDeviceInfoButton->setEnabled(false);
    ui->cbGetDeviceInfo->setEnabled(false);
    ui->SetClipMarginButton->setEnabled(false);
    ui->lineEdit_SetClipMarginWidth->setEnabled(false);
    ui->lineEdit_SetClipMarginHeight->setEnabled(false);
    ui->SaveDrawingImageButton->setEnabled(false);
    ui->cbSaveDrawingImage->setEnabled(false);
    ui->cbSaveDrawingImageDPI->setEnabled(false);
    ui->label_2->setEnabled(false);
    ui->label_3->setEnabled(false);
    ui->label_4->setEnabled(false);
    ui->groupBox->setEnabled(false);
    ui->plainTextEdit_EncodeDecodeData->setEnabled(false);
    ui->cbPenColor->setEnabled(false);

    // initial Select Device combobox...
    ui->cbSelectDevice->addItem("E550/E560");
    ui->cbSelectDevice->addItem("L370/L398");
    ui->cbSelectDevice->addItem("L500");
    ui->cbSelectDevice->addItem("L501F/L501G");
    ui->cbSelectDevice->addItem("LC700");
    ui->cbSelectDevice->addItem("E640");
    ui->cbSelectDevice->setCurrentIndex(0);
    m_nSelectedDeviceID = PPL398_DEVICE;

    // initial encode combobox...
    ui->cbEncode->addItem("BMP");
    ui->cbEncode->addItem("JPG");
    ui->cbEncode->addItem("PNG");
    ui->cbEncode->addItem("INK");
    ui->cbEncode->setCurrentIndex(0);

    // initial Pen Style combobox...
    ui->cbPenStyle->addItem("Presssure sensitivity");
    ui->cbPenStyle->addItem("Fixed width");
    ui->cbPenStyle->setCurrentIndex(0);

    // initial Pen Width combobox...
    for(int i = 0; i < 10; i++)
    {
        ui->cbPenWidth->addItem(QString::number(i + 1));
    }
    ui->cbPenWidth->setCurrentIndex(2);

    // initial Pen Color combobox...
    ui->cbPenColor->addItem("Black");
    ui->cbPenColor->addItem("Red");
    ui->cbPenColor->addItem("Green");
    ui->cbPenColor->addItem("Blue");
    ui->cbPenColor->addItem("Yellow");
    ui->cbPenColor->setCurrentIndex(0);

    // initial Get Device Info combobox...
    for(int i = 0; i < 7; i++)
    {
        ui->cbGetDeviceInfo->addItem(QString::number(i + 1));
    }
    ui->cbGetDeviceInfo->setCurrentIndex(0);

    // initial Save Drawing Image combobox...
    ui->cbSaveDrawingImage->addItem("BMP");
    ui->cbSaveDrawingImage->addItem("JPG");
    ui->cbSaveDrawingImage->addItem("PNG");
    ui->cbSaveDrawingImage->addItem("PDF");
    ui->cbSaveDrawingImage->addItem("SVG");
    ui->cbSaveDrawingImage->setCurrentIndex(0);

    // initial Save Drawing Image DPI combobox...
    ui->cbSaveDrawingImageDPI->addItem("150 DPI");
    ui->cbSaveDrawingImageDPI->addItem("300 DPI");
    ui->cbSaveDrawingImageDPI->setCurrentIndex(0);

    // set lineEdit_SetClipMarginWidth/lineEdit_SetClipMarginHeight as number only...
    ui->lineEdit_SetClipMarginWidth->setValidator(new QIntValidator(0, 100, this));
    ui->lineEdit_SetClipMarginHeight->setValidator(new QIntValidator(0, 100, this));

    // center window on primary screen...
    move(QGuiApplication::screens().at(0)->geometry().center() - frameGeometry().center());
}

MainWindow::~MainWindow()
{
    if(m_plibPPSignPadSDK)
        m_plibPPSignPadSDK->unload();

    delete ui;
}

bool MainWindow::LoadPPSignPadSDK()
{
    bool bRet = false;

    // load libppsignpadsdk.so...
    QDir::setCurrent(qApp->applicationDirPath());
//    QDir::setCurrent("/tmp");
    m_plibPPSignPadSDK = new QLibrary("./libppsignpadsdk.so");

    if(m_plibPPSignPadSDK->load())
    {
        // ==================================
        // initial L398 APIs...
        // ==================================
        //
        m_pfn_PPL398_InitialDeviceByWId = reinterpret_cast<PPL398_InitialDeviceByWId>(m_plibPPSignPadSDK->resolve("PPL398_InitialDeviceByWId"));
        m_pfn_PPL398_InitialDevice = reinterpret_cast<PPL398_InitialDevice>(m_plibPPSignPadSDK->resolve("PPL398_InitialDevice"));
        m_pfn_PPL398_UnInitialDevice = reinterpret_cast<PPL398_UnInitialDevice>(m_plibPPSignPadSDK->resolve("PPL398_UnInitialDevice"));
        m_pfn_PPL398_OpenLCD = reinterpret_cast<PPL398_OpenLCD>(m_plibPPSignPadSDK->resolve("PPL398_OpenLCD"));
        m_pfn_PPL398_Clear = reinterpret_cast<PPL398_Clear>(m_plibPPSignPadSDK->resolve("PPL398_Clear"));
        m_pfn_PPL398_GetHWPenID = reinterpret_cast<PPL398_GetHWPenID>(m_plibPPSignPadSDK->resolve("PPL398_GetHWPenID"));
        m_pfn_PPL398_GetHWPadID = reinterpret_cast<PPL398_GetHWPadID>(m_plibPPSignPadSDK->resolve("PPL398_GetHWPadID"));
        m_pfn_PPL398_GetHWVersion = reinterpret_cast<PPL398_GetHWVersion>(m_plibPPSignPadSDK->resolve("PPL398_GetHWVersion"));
        m_pfn_PPL398_DisplayHWVersion = reinterpret_cast<PPL398_DisplayHWVersion>(m_plibPPSignPadSDK->resolve("PPL398_DisplayHWVersion"));
        m_pfn_PPL398_SetPenStyle = reinterpret_cast<PPL398_SetPenStyle>(m_plibPPSignPadSDK->resolve("PPL398_SetPenStyle"));
        m_pfn_PPL398_SetPenWidth = reinterpret_cast<PPL398_SetPenWidth>(m_plibPPSignPadSDK->resolve("PPL398_SetPenWidth"));
        m_pfn_PPL398_SignPadEventCallback = reinterpret_cast<PPL398_SignPadEventCallback>(m_plibPPSignPadSDK->resolve("PPL398_SignPadEventCallback"));
        m_pfn_PPL398_GetTotalInkPointsNumber = reinterpret_cast<PPL398_GetTotalInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPL398_GetTotalInkPointsNumber"));
        m_pfn_PPL398_GetInkPointData = reinterpret_cast<PPL398_GetInkPointData>(m_plibPPSignPadSDK->resolve("PPL398_GetInkPointData"));
        m_pfn_PPL398_GetInkPointDataTimeInfo = reinterpret_cast<PPL398_GetInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPL398_GetInkPointDataTimeInfo"));
        m_pfn_PPL398_FreeInkPointDataTimeInfo = reinterpret_cast<PPL398_FreeInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPL398_FreeInkPointDataTimeInfo"));
        m_pfn_PPL398_SaveDrawingImage = reinterpret_cast<PPL398_SaveDrawingImage>(m_plibPPSignPadSDK->resolve("PPL398_SaveDrawingImage"));
        m_pfn_PPL398_SetSaveClipImageMargin = reinterpret_cast<PPL398_SetSaveClipImageMargin>(m_plibPPSignPadSDK->resolve("PPL398_SetSaveClipImageMargin"));
        m_pfn_PPL398_GetDeviceInfo = reinterpret_cast<PPL398_GetDeviceInfo>(m_plibPPSignPadSDK->resolve("PPL398_GetDeviceInfo"));
        m_pfn_PPL398_AboutBoxByWId = reinterpret_cast<PPL398_AboutBoxByWId>(m_plibPPSignPadSDK->resolve("PPL398_AboutBoxByWId"));
        m_pfn_PPL398_AboutBox = reinterpret_cast<PPL398_AboutBox>(m_plibPPSignPadSDK->resolve("PPL398_AboutBox"));
        m_pfn_PPL398_Base64Encode = reinterpret_cast<PPL398_Base64Encode>(m_plibPPSignPadSDK->resolve("PPL398_Base64Encode"));
        m_pfn_PPL398_Base64EncodeFree = reinterpret_cast<PPL398_Base64EncodeFree>(m_plibPPSignPadSDK->resolve("PPL398_Base64EncodeFree"));
        m_pfn_PPL398_Base64Decode = reinterpret_cast<PPL398_Base64Decode>(m_plibPPSignPadSDK->resolve("PPL398_Base64Decode"));
        m_pfn_PPL398_GetTotalDecodeInkPointsNumber = reinterpret_cast<PPL398_GetTotalDecodeInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPL398_GetTotalDecodeInkPointsNumber"));
        m_pfn_PPL398_GetDecodeInkPointData = reinterpret_cast<PPL398_GetDecodeInkPointData>(m_plibPPSignPadSDK->resolve("PPL398_GetDecodeInkPointData"));
        m_pfn_PPL398_SetPenColor = reinterpret_cast<PPL398_SetPenColor>(m_plibPPSignPadSDK->resolve("PPL398_SetPenColor"));

        // ==================================
        // initial L500 APIs...
        // ==================================
        //
        m_pfn_PPL500_InitialDeviceByWId = reinterpret_cast<PPL500_InitialDeviceByWId>(m_plibPPSignPadSDK->resolve("PPL500_InitialDeviceByWId"));
        m_pfn_PPL500_InitialDevice = reinterpret_cast<PPL500_InitialDevice>(m_plibPPSignPadSDK->resolve("PPL500_InitialDevice"));
        m_pfn_PPL500_UnInitialDevice = reinterpret_cast<PPL500_UnInitialDevice>(m_plibPPSignPadSDK->resolve("PPL500_UnInitialDevice"));
        m_pfn_PPL500_OpenLCD = reinterpret_cast<PPL500_OpenLCD>(m_plibPPSignPadSDK->resolve("PPL500_OpenLCD"));
        m_pfn_PPL500_Clear = reinterpret_cast<PPL500_Clear>(m_plibPPSignPadSDK->resolve("PPL500_Clear"));
        m_pfn_PPL500_GetHWPenID = reinterpret_cast<PPL500_GetHWPenID>(m_plibPPSignPadSDK->resolve("PPL500_GetHWPenID"));
        m_pfn_PPL500_GetHWPadID = reinterpret_cast<PPL500_GetHWPadID>(m_plibPPSignPadSDK->resolve("PPL500_GetHWPadID"));
        m_pfn_PPL500_GetHWVersion = reinterpret_cast<PPL500_GetHWVersion>(m_plibPPSignPadSDK->resolve("PPL500_GetHWVersion"));
        m_pfn_PPL500_DisplayHWVersion = reinterpret_cast<PPL500_DisplayHWVersion>(m_plibPPSignPadSDK->resolve("PPL500_DisplayHWVersion"));
        m_pfn_PPL500_SetPenStyle = reinterpret_cast<PPL500_SetPenStyle>(m_plibPPSignPadSDK->resolve("PPL500_SetPenStyle"));
        m_pfn_PPL500_SetPenWidth = reinterpret_cast<PPL500_SetPenWidth>(m_plibPPSignPadSDK->resolve("PPL500_SetPenWidth"));
        m_pfn_PPL500_SignPadEventCallback = reinterpret_cast<PPL500_SignPadEventCallback>(m_plibPPSignPadSDK->resolve("PPL500_SignPadEventCallback"));
        m_pfn_PPL500_GetTotalInkPointsNumber = reinterpret_cast<PPL500_GetTotalInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPL500_GetTotalInkPointsNumber"));
        m_pfn_PPL500_GetInkPointData = reinterpret_cast<PPL500_GetInkPointData>(m_plibPPSignPadSDK->resolve("PPL500_GetInkPointData"));
        m_pfn_PPL500_GetInkPointDataTimeInfo = reinterpret_cast<PPL500_GetInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPL500_GetInkPointDataTimeInfo"));
        m_pfn_PPL500_FreeInkPointDataTimeInfo = reinterpret_cast<PPL500_FreeInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPL500_FreeInkPointDataTimeInfo"));
        m_pfn_PPL500_SaveDrawingImage = reinterpret_cast<PPL500_SaveDrawingImage>(m_plibPPSignPadSDK->resolve("PPL500_SaveDrawingImage"));
        m_pfn_PPL500_SetSaveClipImageMargin = reinterpret_cast<PPL500_SetSaveClipImageMargin>(m_plibPPSignPadSDK->resolve("PPL500_SetSaveClipImageMargin"));
        m_pfn_PPL500_GetDeviceInfo = reinterpret_cast<PPL500_GetDeviceInfo>(m_plibPPSignPadSDK->resolve("PPL500_GetDeviceInfo"));
        m_pfn_PPL500_AboutBoxByWId = reinterpret_cast<PPL500_AboutBoxByWId>(m_plibPPSignPadSDK->resolve("PPL500_AboutBoxByWId"));
        m_pfn_PPL500_AboutBox = reinterpret_cast<PPL500_AboutBox>(m_plibPPSignPadSDK->resolve("PPL500_AboutBox"));
        m_pfn_PPL500_Base64Encode = reinterpret_cast<PPL500_Base64Encode>(m_plibPPSignPadSDK->resolve("PPL500_Base64Encode"));
        m_pfn_PPL500_Base64EncodeFree = reinterpret_cast<PPL500_Base64EncodeFree>(m_plibPPSignPadSDK->resolve("PPL500_Base64EncodeFree"));
        m_pfn_PPL500_Base64Decode = reinterpret_cast<PPL500_Base64Decode>(m_plibPPSignPadSDK->resolve("PPL500_Base64Decode"));
        m_pfn_PPL500_GetTotalDecodeInkPointsNumber = reinterpret_cast<PPL500_GetTotalDecodeInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPL500_GetTotalDecodeInkPointsNumber"));
        m_pfn_PPL500_GetDecodeInkPointData = reinterpret_cast<PPL500_GetDecodeInkPointData>(m_plibPPSignPadSDK->resolve("PPL500_GetDecodeInkPointData"));
        m_pfn_PPL500_SetPenColor = reinterpret_cast<PPL500_SetPenColor>(m_plibPPSignPadSDK->resolve("PPL500_SetPenColor"));

        // ==================================
        // initial L501F APIs...
        // ==================================
        //
        m_pfn_PPL501F_InitialDeviceByWId = reinterpret_cast<PPL501F_InitialDeviceByWId>(m_plibPPSignPadSDK->resolve("PPL501F_InitialDeviceByWId"));
        m_pfn_PPL501F_InitialDevice = reinterpret_cast<PPL501F_InitialDevice>(m_plibPPSignPadSDK->resolve("PPL501F_InitialDevice"));
        m_pfn_PPL501F_UnInitialDevice = reinterpret_cast<PPL501F_UnInitialDevice>(m_plibPPSignPadSDK->resolve("PPL501F_UnInitialDevice"));
        m_pfn_PPL501F_OpenLCD = reinterpret_cast<PPL501F_OpenLCD>(m_plibPPSignPadSDK->resolve("PPL501F_OpenLCD"));
        m_pfn_PPL501F_Clear = reinterpret_cast<PPL501F_Clear>(m_plibPPSignPadSDK->resolve("PPL501F_Clear"));
        m_pfn_PPL501F_GetHWPenID = reinterpret_cast<PPL501F_GetHWPenID>(m_plibPPSignPadSDK->resolve("PPL501F_GetHWPenID"));
        m_pfn_PPL501F_GetHWPadID = reinterpret_cast<PPL501F_GetHWPadID>(m_plibPPSignPadSDK->resolve("PPL501F_GetHWPadID"));
        m_pfn_PPL501F_GetHWVersion = reinterpret_cast<PPL501F_GetHWVersion>(m_plibPPSignPadSDK->resolve("PPL501F_GetHWVersion"));
        m_pfn_PPL501F_DisplayHWVersion = reinterpret_cast<PPL501F_DisplayHWVersion>(m_plibPPSignPadSDK->resolve("PPL501F_DisplayHWVersion"));
        m_pfn_PPL501F_SetPenStyle = reinterpret_cast<PPL501F_SetPenStyle>(m_plibPPSignPadSDK->resolve("PPL501F_SetPenStyle"));
        m_pfn_PPL501F_SetPenWidth = reinterpret_cast<PPL501F_SetPenWidth>(m_plibPPSignPadSDK->resolve("PPL501F_SetPenWidth"));
        m_pfn_PPL501F_SignPadEventCallback = reinterpret_cast<PPL501F_SignPadEventCallback>(m_plibPPSignPadSDK->resolve("PPL501F_SignPadEventCallback"));
        m_pfn_PPL501F_GetTotalInkPointsNumber = reinterpret_cast<PPL501F_GetTotalInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPL501F_GetTotalInkPointsNumber"));
        m_pfn_PPL501F_GetInkPointData = reinterpret_cast<PPL501F_GetInkPointData>(m_plibPPSignPadSDK->resolve("PPL501F_GetInkPointData"));
        m_pfn_PPL501F_GetInkPointDataTimeInfo = reinterpret_cast<PPL501F_GetInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPL501F_GetInkPointDataTimeInfo"));
        m_pfn_PPL501F_FreeInkPointDataTimeInfo = reinterpret_cast<PPL501F_FreeInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPL501F_FreeInkPointDataTimeInfo"));
        m_pfn_PPL501F_SaveDrawingImage = reinterpret_cast<PPL501F_SaveDrawingImage>(m_plibPPSignPadSDK->resolve("PPL501F_SaveDrawingImage"));
        m_pfn_PPL501F_SetSaveClipImageMargin = reinterpret_cast<PPL501F_SetSaveClipImageMargin>(m_plibPPSignPadSDK->resolve("PPL501F_SetSaveClipImageMargin"));
        m_pfn_PPL501F_GetDeviceInfo = reinterpret_cast<PPL501F_GetDeviceInfo>(m_plibPPSignPadSDK->resolve("PPL501F_GetDeviceInfo"));
        m_pfn_PPL501F_AboutBoxByWId = reinterpret_cast<PPL501F_AboutBoxByWId>(m_plibPPSignPadSDK->resolve("PPL501F_AboutBoxByWId"));
        m_pfn_PPL501F_AboutBox = reinterpret_cast<PPL501F_AboutBox>(m_plibPPSignPadSDK->resolve("PPL501F_AboutBox"));
        m_pfn_PPL501F_Base64Encode = reinterpret_cast<PPL501F_Base64Encode>(m_plibPPSignPadSDK->resolve("PPL501F_Base64Encode"));
        m_pfn_PPL501F_Base64EncodeFree = reinterpret_cast<PPL501F_Base64EncodeFree>(m_plibPPSignPadSDK->resolve("PPL501F_Base64EncodeFree"));
        m_pfn_PPL501F_Base64Decode = reinterpret_cast<PPL501F_Base64Decode>(m_plibPPSignPadSDK->resolve("PPL501F_Base64Decode"));
        m_pfn_PPL501F_GetTotalDecodeInkPointsNumber = reinterpret_cast<PPL501F_GetTotalDecodeInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPL501F_GetTotalDecodeInkPointsNumber"));
        m_pfn_PPL501F_GetDecodeInkPointData = reinterpret_cast<PPL501F_GetDecodeInkPointData>(m_plibPPSignPadSDK->resolve("PPL501F_GetDecodeInkPointData"));
        m_pfn_PPL501F_SetPenColor = reinterpret_cast<PPL501F_SetPenColor>(m_plibPPSignPadSDK->resolve("PPL501F_SetPenColor"));
        m_pfn_PPL501F_SetDisplayedFPImageAtByWId = reinterpret_cast<PPL501F_SetDisplayedFPImageAtByWId>(m_plibPPSignPadSDK->resolve("PPL501F_SetDisplayedFPImageAtByWId"));
        m_pfn_PPL501F_SetDisplayedFPImageAt = reinterpret_cast<PPL501F_SetDisplayedFPImageAt>(m_plibPPSignPadSDK->resolve("PPL501F_SetDisplayedFPImageAt"));
        m_pfn_PPL501F_GetFPImageBase64Data = reinterpret_cast<PPL501F_GetFPImageBase64Data>(m_plibPPSignPadSDK->resolve("PPL501F_GetFPImageBase64Data"));
        m_pfn_PPL501F_FreeFPImageBase64Data = reinterpret_cast<PPL501F_FreeFPImageBase64Data>(m_plibPPSignPadSDK->resolve("PPL501F_FreeFPImageBase64Data"));

        // ==================================
        // initial LC700 APIs...
        // ==================================
        //
        m_pfn_PPLC700_InitialDeviceByWId = reinterpret_cast<PPLC700_InitialDeviceByWId>(m_plibPPSignPadSDK->resolve("PPLC700_InitialDeviceByWId"));
        m_pfn_PPLC700_InitialDevice = reinterpret_cast<PPLC700_InitialDevice>(m_plibPPSignPadSDK->resolve("PPLC700_InitialDevice"));
        m_pfn_PPLC700_UnInitialDevice = reinterpret_cast<PPLC700_UnInitialDevice>(m_plibPPSignPadSDK->resolve("PPLC700_UnInitialDevice"));
        m_pfn_PPLC700_Clear = reinterpret_cast<PPLC700_Clear>(m_plibPPSignPadSDK->resolve("PPLC700_Clear"));
        m_pfn_PPLC700_GetHWPadID = reinterpret_cast<PPLC700_GetHWPadID>(m_plibPPSignPadSDK->resolve("PPLC700_GetHWPadID"));
        m_pfn_PPLC700_GetHWVersion = reinterpret_cast<PPLC700_GetHWVersion>(m_plibPPSignPadSDK->resolve("PPLC700_GetHWVersion"));
        m_pfn_PPLC700_SetPenStyle = reinterpret_cast<PPLC700_SetPenStyle>(m_plibPPSignPadSDK->resolve("PPLC700_SetPenStyle"));
        m_pfn_PPLC700_SetPenWidth = reinterpret_cast<PPLC700_SetPenWidth>(m_plibPPSignPadSDK->resolve("PPLC700_SetPenWidth"));
        m_pfn_PPLC700_SignPadEventCallback = reinterpret_cast<PPLC700_SignPadEventCallback>(m_plibPPSignPadSDK->resolve("PPLC700_SignPadEventCallback"));
        m_pfn_PPLC700_GetTotalInkPointsNumber = reinterpret_cast<PPLC700_GetTotalInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPLC700_GetTotalInkPointsNumber"));
        m_pfn_PPLC700_GetInkPointData = reinterpret_cast<PPLC700_GetInkPointData>(m_plibPPSignPadSDK->resolve("PPLC700_GetInkPointData"));
        m_pfn_PPLC700_GetInkPointDataTimeInfo = reinterpret_cast<PPLC700_GetInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPLC700_GetInkPointDataTimeInfo"));
        m_pfn_PPLC700_FreeInkPointDataTimeInfo = reinterpret_cast<PPLC700_FreeInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPLC700_FreeInkPointDataTimeInfo"));
        m_pfn_PPLC700_SaveDrawingImage = reinterpret_cast<PPLC700_SaveDrawingImage>(m_plibPPSignPadSDK->resolve("PPLC700_SaveDrawingImage"));
        m_pfn_PPLC700_SetSaveClipImageMargin = reinterpret_cast<PPLC700_SetSaveClipImageMargin>(m_plibPPSignPadSDK->resolve("PPLC700_SetSaveClipImageMargin"));
        m_pfn_PPLC700_GetDeviceInfo = reinterpret_cast<PPLC700_GetDeviceInfo>(m_plibPPSignPadSDK->resolve("PPLC700_GetDeviceInfo"));
        m_pfn_PPLC700_AboutBoxByWId = reinterpret_cast<PPLC700_AboutBoxByWId>(m_plibPPSignPadSDK->resolve("PPLC700_AboutBoxByWId"));
        m_pfn_PPLC700_AboutBox = reinterpret_cast<PPLC700_AboutBox>(m_plibPPSignPadSDK->resolve("PPLC700_AboutBox"));
        m_pfn_PPLC700_Base64Encode = reinterpret_cast<PPLC700_Base64Encode>(m_plibPPSignPadSDK->resolve("PPLC700_Base64Encode"));
        m_pfn_PPLC700_Base64EncodeFree = reinterpret_cast<PPLC700_Base64EncodeFree>(m_plibPPSignPadSDK->resolve("PPLC700_Base64EncodeFree"));
        m_pfn_PPLC700_Base64Decode = reinterpret_cast<PPLC700_Base64Decode>(m_plibPPSignPadSDK->resolve("PPLC700_Base64Decode"));
        m_pfn_PPLC700_GetTotalDecodeInkPointsNumber = reinterpret_cast<PPLC700_GetTotalDecodeInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPLC700_GetTotalDecodeInkPointsNumber"));
        m_pfn_PPLC700_GetDecodeInkPointData = reinterpret_cast<PPLC700_GetDecodeInkPointData>(m_plibPPSignPadSDK->resolve("PPLC700_GetDecodeInkPointData"));
        m_pfn_PPLC700_SetPenColor = reinterpret_cast<PPLC700_SetPenColor>(m_plibPPSignPadSDK->resolve("PPLC700_SetPenColor"));

        // ==================================
        // initial E640 APIs...
        // ==================================
        //
        m_pfn_PPE640_InitialDeviceByWId = reinterpret_cast<PPE640_InitialDeviceByWId>(m_plibPPSignPadSDK->resolve("PPE640_InitialDeviceByWId"));
        m_pfn_PPE640_InitialDevice = reinterpret_cast<PPE640_InitialDevice>(m_plibPPSignPadSDK->resolve("PPE640_InitialDevice"));
        m_pfn_PPE640_UnInitialDevice = reinterpret_cast<PPE640_UnInitialDevice>(m_plibPPSignPadSDK->resolve("PPE640_UnInitialDevice"));
        m_pfn_PPE640_Clear = reinterpret_cast<PPE640_Clear>(m_plibPPSignPadSDK->resolve("PPE640_Clear"));
        m_pfn_PPE640_GetHWPadID = reinterpret_cast<PPE640_GetHWPadID>(m_plibPPSignPadSDK->resolve("PPE640_GetHWPadID"));
        m_pfn_PPE640_GetHWVersion = reinterpret_cast<PPE640_GetHWVersion>(m_plibPPSignPadSDK->resolve("PPE640_GetHWVersion"));
        m_pfn_PPE640_SetPenStyle = reinterpret_cast<PPE640_SetPenStyle>(m_plibPPSignPadSDK->resolve("PPE640_SetPenStyle"));
        m_pfn_PPE640_SetPenWidth = reinterpret_cast<PPE640_SetPenWidth>(m_plibPPSignPadSDK->resolve("PPE640_SetPenWidth"));
        m_pfn_PPE640_SignPadEventCallback = reinterpret_cast<PPE640_SignPadEventCallback>(m_plibPPSignPadSDK->resolve("PPE640_SignPadEventCallback"));
        m_pfn_PPE640_GetTotalInkPointsNumber = reinterpret_cast<PPE640_GetTotalInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPE640_GetTotalInkPointsNumber"));
        m_pfn_PPE640_GetInkPointData = reinterpret_cast<PPE640_GetInkPointData>(m_plibPPSignPadSDK->resolve("PPE640_GetInkPointData"));
        m_pfn_PPE640_GetInkPointDataTimeInfo = reinterpret_cast<PPE640_GetInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPE640_GetInkPointDataTimeInfo"));
        m_pfn_PPE640_FreeInkPointDataTimeInfo = reinterpret_cast<PPE640_FreeInkPointDataTimeInfo>(m_plibPPSignPadSDK->resolve("PPE640_FreeInkPointDataTimeInfo"));
        m_pfn_PPE640_SaveDrawingImage = reinterpret_cast<PPE640_SaveDrawingImage>(m_plibPPSignPadSDK->resolve("PPE640_SaveDrawingImage"));
        m_pfn_PPE640_SetSaveClipImageMargin = reinterpret_cast<PPE640_SetSaveClipImageMargin>(m_plibPPSignPadSDK->resolve("PPE640_SetSaveClipImageMargin"));
        m_pfn_PPE640_GetDeviceInfo = reinterpret_cast<PPE640_GetDeviceInfo>(m_plibPPSignPadSDK->resolve("PPE640_GetDeviceInfo"));
        m_pfn_PPE640_AboutBoxByWId = reinterpret_cast<PPE640_AboutBoxByWId>(m_plibPPSignPadSDK->resolve("PPE640_AboutBoxByWId"));
        m_pfn_PPE640_AboutBox = reinterpret_cast<PPE640_AboutBox>(m_plibPPSignPadSDK->resolve("PPE640_AboutBox"));
        m_pfn_PPE640_Base64Encode = reinterpret_cast<PPE640_Base64Encode>(m_plibPPSignPadSDK->resolve("PPE640_Base64Encode"));
        m_pfn_PPE640_Base64EncodeFree = reinterpret_cast<PPE640_Base64EncodeFree>(m_plibPPSignPadSDK->resolve("PPE640_Base64EncodeFree"));
        m_pfn_PPE640_Base64Decode = reinterpret_cast<PPE640_Base64Decode>(m_plibPPSignPadSDK->resolve("PPE640_Base64Decode"));
        m_pfn_PPE640_GetTotalDecodeInkPointsNumber = reinterpret_cast<PPE640_GetTotalDecodeInkPointsNumber>(m_plibPPSignPadSDK->resolve("PPE640_GetTotalDecodeInkPointsNumber"));
        m_pfn_PPE640_GetDecodeInkPointData = reinterpret_cast<PPE640_GetDecodeInkPointData>(m_plibPPSignPadSDK->resolve("PPE640_GetDecodeInkPointData"));
        m_pfn_PPE640_SetPenColor = reinterpret_cast<PPE640_SetPenColor>(m_plibPPSignPadSDK->resolve("PPE640_SetPenColor"));

        if(m_pfn_PPL398_InitialDeviceByWId && m_pfn_PPL398_InitialDevice && m_pfn_PPL398_UnInitialDevice && m_pfn_PPL398_OpenLCD &&
           m_pfn_PPL398_Clear && m_pfn_PPL398_GetHWPenID && m_pfn_PPL398_GetHWPadID &&
           m_pfn_PPL398_GetHWVersion && m_pfn_PPL398_DisplayHWVersion && m_pfn_PPL398_SetPenStyle &&
           m_pfn_PPL398_SetPenWidth && m_pfn_PPL398_SignPadEventCallback && m_pfn_PPL398_GetTotalInkPointsNumber &&
           m_pfn_PPL398_GetInkPointData && m_pfn_PPL398_GetInkPointDataTimeInfo && m_pfn_PPL398_FreeInkPointDataTimeInfo &&
           m_pfn_PPL398_SaveDrawingImage && m_pfn_PPL398_SetSaveClipImageMargin && m_pfn_PPL398_GetDeviceInfo &&
           m_pfn_PPL398_AboutBoxByWId && m_pfn_PPL398_AboutBox && m_pfn_PPL398_Base64Encode && m_pfn_PPL398_Base64EncodeFree &&
           m_pfn_PPL398_Base64Decode && m_pfn_PPL398_GetTotalDecodeInkPointsNumber && m_pfn_PPL398_GetDecodeInkPointData &&
           m_pfn_PPL398_SetPenColor &&
           m_pfn_PPL500_InitialDeviceByWId && m_pfn_PPL500_InitialDevice && m_pfn_PPL500_UnInitialDevice && m_pfn_PPL500_OpenLCD &&
           m_pfn_PPL500_Clear && m_pfn_PPL500_GetHWPenID && m_pfn_PPL500_GetHWPadID &&
           m_pfn_PPL500_GetHWVersion && m_pfn_PPL500_DisplayHWVersion && m_pfn_PPL500_SetPenStyle &&
           m_pfn_PPL500_SetPenWidth && m_pfn_PPL500_SignPadEventCallback && m_pfn_PPL500_GetTotalInkPointsNumber &&
           m_pfn_PPL500_GetInkPointData && m_pfn_PPL500_GetInkPointDataTimeInfo && m_pfn_PPL500_FreeInkPointDataTimeInfo &&
           m_pfn_PPL500_SaveDrawingImage && m_pfn_PPL500_SetSaveClipImageMargin && m_pfn_PPL500_GetDeviceInfo &&
           m_pfn_PPL500_AboutBoxByWId && m_pfn_PPL500_AboutBox && m_pfn_PPL500_Base64Encode && m_pfn_PPL500_Base64EncodeFree &&
           m_pfn_PPL500_Base64Decode && m_pfn_PPL500_GetTotalDecodeInkPointsNumber && m_pfn_PPL500_GetDecodeInkPointData &&
           m_pfn_PPL500_SetPenColor &&
           m_pfn_PPL501F_InitialDeviceByWId && m_pfn_PPL501F_InitialDevice && m_pfn_PPL501F_UnInitialDevice && m_pfn_PPL501F_OpenLCD &&
           m_pfn_PPL501F_Clear && m_pfn_PPL501F_GetHWPenID && m_pfn_PPL501F_GetHWPadID &&
           m_pfn_PPL501F_GetHWVersion && m_pfn_PPL501F_DisplayHWVersion && m_pfn_PPL501F_SetPenStyle &&
           m_pfn_PPL501F_SetPenWidth && m_pfn_PPL501F_SignPadEventCallback && m_pfn_PPL501F_GetTotalInkPointsNumber &&
           m_pfn_PPL501F_GetInkPointData && m_pfn_PPL501F_GetInkPointDataTimeInfo && m_pfn_PPL501F_FreeInkPointDataTimeInfo &&
           m_pfn_PPL501F_SaveDrawingImage && m_pfn_PPL501F_SetSaveClipImageMargin && m_pfn_PPL501F_GetDeviceInfo &&
           m_pfn_PPL501F_AboutBoxByWId && m_pfn_PPL501F_AboutBox && m_pfn_PPL501F_Base64Encode && m_pfn_PPL501F_Base64EncodeFree &&
           m_pfn_PPL501F_Base64Decode && m_pfn_PPL501F_GetTotalDecodeInkPointsNumber && m_pfn_PPL501F_GetDecodeInkPointData &&
           m_pfn_PPL501F_SetPenColor && m_pfn_PPL501F_SetDisplayedFPImageAt && m_pfn_PPL501F_SetDisplayedFPImageAtByWId &&
           m_pfn_PPL501F_GetFPImageBase64Data &&  m_pfn_PPL501F_FreeFPImageBase64Data &&
           m_pfn_PPLC700_InitialDeviceByWId && m_pfn_PPLC700_InitialDevice && m_pfn_PPLC700_UnInitialDevice && m_pfn_PPLC700_Clear && m_pfn_PPLC700_GetHWPadID &&
           m_pfn_PPLC700_GetHWVersion && m_pfn_PPLC700_SetPenStyle && m_pfn_PPLC700_SetPenWidth &&
           m_pfn_PPLC700_SignPadEventCallback && m_pfn_PPLC700_GetTotalInkPointsNumber && m_pfn_PPLC700_GetInkPointData &&
           m_pfn_PPLC700_GetInkPointDataTimeInfo && m_pfn_PPLC700_FreeInkPointDataTimeInfo && m_pfn_PPLC700_SaveDrawingImage &&
           m_pfn_PPLC700_SetSaveClipImageMargin && m_pfn_PPLC700_GetDeviceInfo && m_pfn_PPLC700_AboutBox && m_pfn_PPLC700_AboutBoxByWId &&
           m_pfn_PPLC700_Base64Encode && m_pfn_PPLC700_Base64EncodeFree && m_pfn_PPLC700_Base64Decode &&
           m_pfn_PPLC700_GetTotalDecodeInkPointsNumber && m_pfn_PPLC700_GetDecodeInkPointData && m_pfn_PPLC700_SetPenColor &&
           m_pfn_PPE640_InitialDeviceByWId && m_pfn_PPE640_InitialDevice && m_pfn_PPE640_UnInitialDevice && m_pfn_PPE640_Clear && m_pfn_PPE640_GetHWPadID &&
           m_pfn_PPE640_GetHWVersion && m_pfn_PPE640_SetPenStyle && m_pfn_PPE640_SetPenWidth &&
           m_pfn_PPE640_SignPadEventCallback && m_pfn_PPE640_GetTotalInkPointsNumber && m_pfn_PPE640_GetInkPointData &&
           m_pfn_PPE640_GetInkPointDataTimeInfo && m_pfn_PPE640_FreeInkPointDataTimeInfo && m_pfn_PPE640_SaveDrawingImage &&
           m_pfn_PPE640_SetSaveClipImageMargin && m_pfn_PPE640_GetDeviceInfo && m_pfn_PPE640_AboutBox && m_pfn_PPE640_AboutBoxByWId &&
           m_pfn_PPE640_Base64Encode && m_pfn_PPE640_Base64EncodeFree && m_pfn_PPE640_Base64Decode &&
           m_pfn_PPE640_GetTotalDecodeInkPointsNumber && m_pfn_PPE640_GetDecodeInkPointData && m_pfn_PPE640_SetPenColor
           )
        {
            g_pMainWnd = reinterpret_cast<void *>(this);
            bRet = true;
        }
        else
        {
            QMessageBox::warning(this, "Warning Box", "APIs of 'libppsignpadsdk.so' Library loaded Failed !");
            qDebug("APIs of 'libppsignpadsdk.so' Library loaded Failed : %s", qPrintable(m_plibPPSignPadSDK->errorString()));
        }
    }
    else
    {
         QMessageBox::warning(this, "Warning Box", "'libppsignpadsdk.so' Library is not loaded !");
         qDebug("'libppsignpadsdk.so' Library is not loaded : %s", qPrintable(m_plibPPSignPadSDK->errorString()));
    }

    return bRet;
}

void MainWindow::on_InitButton_clicked()
{
//    QMessageBox::information(this, "Information Box", "Now, you click 'Init' Button !");
    if(m_pfn_PPL398_InitialDevice)
    {
        int nWidth = width();
        int nSignPadWidth = 710;
        int nSignPadHeight = 430;
        bool bRet = false;

        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            bRet = m_pfn_PPL398_InitialDevice(PPL398_DEVICE, this->centralWidget(), (nWidth - nSignPadWidth) >> 1,
                                                   10, nSignPadWidth, nSignPadHeight);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            bRet = m_pfn_PPL500_InitialDevice(PPL500_DEVICE, this->centralWidget(), (nWidth - nSignPadWidth) >> 1,
                                                   10, nSignPadWidth, nSignPadHeight);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            bRet = m_pfn_PPL501F_InitialDevice(PPL501F_DEVICE, this->centralWidget(), (nWidth - nSignPadWidth) >> 1,
                                                   10, nSignPadWidth, nSignPadHeight);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            bRet = m_pfn_PPLC700_InitialDevice(PPLC700_DEVICE, this->centralWidget(), (nWidth - nSignPadWidth) >> 1,
                                                   10, nSignPadWidth, nSignPadHeight);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            bRet = m_pfn_PPE640_InitialDevice(PPE640_DEVICE, this->centralWidget(), (nWidth - nSignPadWidth) >> 1,
                                                   10, nSignPadWidth, nSignPadHeight);
        }

        if(bRet == true)
        {
            if(m_nSelectedDeviceID == PPL398_DEVICE)
            {
                m_pfn_PPL398_SignPadEventCallback(PPL398_DEVICE, SignPadEventCallback);
            }
            else if(m_nSelectedDeviceID == PPL500_DEVICE)
            {
                m_pfn_PPL500_SignPadEventCallback(PPL500_DEVICE, SignPadEventCallback);
            }
            else if(m_nSelectedDeviceID == PPL501F_DEVICE)
            {
                // set displayed FP Image location...
                // physical FP Image Size : (Width : 208) x (Height : 288)
                // the FP Image demo maintains its aspect ratio...
                int nFPImageWidth = 145;
                int nFPImageHeight = 201;
                int nX = (nSignPadWidth - nFPImageWidth) >> 1;
                int nY = (nSignPadHeight - nFPImageHeight) >> 1;

                int nResult = m_pfn_PPL501F_SetDisplayedFPImageAt(PPL501F_DEVICE, this->centralWidget(), 0, 0, nX, nY, nFPImageWidth, nFPImageHeight);
                if(nResult != ARI_SUCCESS)
                {
                    QString strPenID = QString("m_pfn_PPL501F_SetDisplayedFPImageAt() Failed : %1").arg(nResult);
                    ui->labelStatus->setText(strPenID);
                    return;
                }

                m_pfn_PPL501F_SignPadEventCallback(PPL501F_DEVICE, SignPadEventCallback);
            }
            else if(m_nSelectedDeviceID == PPLC700_DEVICE)
            {
                m_pfn_PPLC700_SignPadEventCallback(PPLC700_DEVICE, SignPadEventCallback);
            }
            else if(m_nSelectedDeviceID == PPE640_DEVICE)
            {
                m_pfn_PPE640_SignPadEventCallback(PPE640_DEVICE, SignPadEventCallback);
            }

            ui->label->setEnabled(false);
            ui->cbSelectDevice->setEnabled(false);
            ui->InitButton->setEnabled(false);
            ui->UnInitButton->setEnabled(true);

            if((m_nSelectedDeviceID == PPLC700_DEVICE) || (m_nSelectedDeviceID == PPE640_DEVICE))
            {
            }
            else
            {
                ui->OpenLCDButton->setEnabled(true);
                ui->CloseLCDButton->setEnabled(true);
                ui->PenIDButton->setEnabled(true);
                ui->ShowVersionOnDeviceButton->setEnabled(true);
            }

            ui->ClearButton->setEnabled(true);
            ui->GetSizeButton->setEnabled(true);
            ui->GetPointButton->setEnabled(true);
            ui->cbGetPoint->setEnabled(true);
            ui->PadIDButton->setEnabled(true);
            ui->EncodeButton->setEnabled(true);
            ui->cbEncode->setEnabled(true);
            ui->DecodeButton->setEnabled(true);
            ui->AboutButton->setEnabled(true);
            ui->HWVersionButton->setEnabled(true);
            ui->cbPenStyle->setEnabled(true);
            ui->cbPenWidth->setEnabled(true);
            ui->GetDeviceInfoButton->setEnabled(true);
            ui->cbGetDeviceInfo->setEnabled(true);
            ui->SetClipMarginButton->setEnabled(true);
            ui->lineEdit_SetClipMarginWidth->setEnabled(true);
            ui->lineEdit_SetClipMarginHeight->setEnabled(true);
            ui->SaveDrawingImageButton->setEnabled(true);
            ui->cbSaveDrawingImage->setEnabled(true);
            ui->cbSaveDrawingImageDPI->setEnabled(true);
            ui->label_2->setEnabled(true);
            ui->label_3->setEnabled(true);
            ui->label_4->setEnabled(true);
            ui->groupBox->setEnabled(true);
            ui->plainTextEdit_EncodeDecodeData->setEnabled(true);
            ui->lineEdit_SetClipMarginWidth->setText("0");
            ui->lineEdit_SetClipMarginHeight->setText("0");
            ui->cbPenColor->setEnabled(true);
            ui->labelStatus->setText("You may start signing now.");

//            QMessageBox::information(this, "Information Box", "PPL398_InitialDevice() return true...");
        }
        else
        {
            QMessageBox::warning(this, "Warning Box", "Device not found !");
        }
    }
}

void MainWindow::on_UnInitButton_clicked()
{
//    QMessageBox::information(this, "Information Box", "Now, you click 'UnInit' Button !");
    if(m_pfn_PPL398_UnInitialDevice && m_pfn_PPL500_UnInitialDevice && m_pfn_PPL501F_UnInitialDevice &&
       m_pfn_PPLC700_UnInitialDevice && m_pfn_PPE640_UnInitialDevice)
    {
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            m_pfn_PPL398_UnInitialDevice(PPL398_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            m_pfn_PPL500_UnInitialDevice(PPL500_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            m_pfn_PPL501F_UnInitialDevice(PPL501F_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            m_pfn_PPLC700_UnInitialDevice(PPLC700_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            m_pfn_PPE640_UnInitialDevice(PPE640_DEVICE);
        }

        ui->label->setEnabled(true);
        ui->cbSelectDevice->setEnabled(true);
        ui->InitButton->setEnabled(true);
        ui->UnInitButton->setEnabled(false);
        ui->OpenLCDButton->setEnabled(false);
        ui->CloseLCDButton->setEnabled(false);
        ui->ClearButton->setEnabled(false);
        ui->GetSizeButton->setEnabled(false);
        ui->GetPointButton->setEnabled(false);
        ui->cbGetPoint->setEnabled(false);
        ui->PenIDButton->setEnabled(false);
        ui->PadIDButton->setEnabled(false);
        ui->EncodeButton->setEnabled(false);
        ui->cbEncode->setEnabled(false);
        ui->DecodeButton->setEnabled(false);
        ui->AboutButton->setEnabled(false);
        ui->HWVersionButton->setEnabled(false);
        ui->ShowVersionOnDeviceButton->setEnabled(false);
        ui->cbPenStyle->setEnabled(false);
        ui->cbPenStyle->setCurrentIndex(0);
        ui->cbPenWidth->setEnabled(false);
        ui->cbPenWidth->setCurrentIndex(2);
        ui->GetDeviceInfoButton->setEnabled(false);
        ui->cbGetDeviceInfo->setEnabled(false);
        ui->SetClipMarginButton->setEnabled(false);
        ui->lineEdit_SetClipMarginWidth->setEnabled(false);
        ui->lineEdit_SetClipMarginHeight->setEnabled(false);
        ui->SaveDrawingImageButton->setEnabled(false);
        ui->cbSaveDrawingImage->setEnabled(false);
        ui->cbSaveDrawingImageDPI->setEnabled(false);
        ui->label_2->setEnabled(false);
        ui->label_3->setEnabled(false);
        ui->groupBox->setEnabled(false);
        ui->plainTextEdit_EncodeDecodeData->setEnabled(false);
        ui->plainTextEdit_EncodeDecodeData->setPlainText("");
        ui->label_4->setEnabled(false);
        ui->cbPenColor->setEnabled(false);
        ui->cbPenColor->setCurrentIndex(0);
        ui->labelStatus->setText("Please select device and click [Init] button to initial sign pad.");
    }

}

void MainWindow::closeEvent(QCloseEvent *event)
{
    if(m_pfn_PPL398_UnInitialDevice && m_pfn_PPL500_UnInitialDevice && m_pfn_PPL501F_UnInitialDevice &&
       m_pfn_PPLC700_UnInitialDevice && m_pfn_PPE640_UnInitialDevice)
    {
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            m_pfn_PPL398_UnInitialDevice(PPL398_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            m_pfn_PPL500_UnInitialDevice(PPL500_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            m_pfn_PPL501F_UnInitialDevice(PPL501F_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            m_pfn_PPLC700_UnInitialDevice(PPLC700_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            m_pfn_PPE640_UnInitialDevice(PPE640_DEVICE);
        }
    }

    event->accept();
}

void MainWindow::on_ClearButton_clicked()
{
    if(m_pfn_PPL398_Clear && m_pfn_PPL500_Clear && m_pfn_PPL501F_Clear && m_pfn_PPLC700_Clear && m_pfn_PPE640_Clear)
    {
        int nResult = ARI_FAIL;

        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nResult = m_pfn_PPL398_Clear(PPL398_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_Clear(PPL500_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_Clear(PPL501F_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            nResult = m_pfn_PPLC700_Clear(PPLC700_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            nResult = m_pfn_PPE640_Clear(PPE640_DEVICE);
        }

        if(nResult == ARI_SUCCESS)
        {
            ui->labelStatus->setText("Clear : succeeded.");

            // clear GetPoint combobox...
            ui->cbGetPoint->clear();

            // clear Set Clip Margin line edit...
            ui->lineEdit_SetClipMarginWidth->setText("0");
            ui->lineEdit_SetClipMarginHeight->setText("0");

            // clear Encode/Decode Data...
            ui->plainTextEdit_EncodeDecodeData->setPlainText("");
        }
    }
}

void MainWindow::on_OpenLCDButton_clicked()
{
    if(m_pfn_PPL398_OpenLCD && m_pfn_PPL500_OpenLCD && m_pfn_PPL501F_OpenLCD)
    {
        int nResult = ARI_FAIL;

        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nResult = m_pfn_PPL398_OpenLCD(PPL398_DEVICE, true);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_OpenLCD(PPL500_DEVICE, true);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_OpenLCD(PPL501F_DEVICE, true);
        }

        if(nResult == ARI_SUCCESS)
        {
            ui->labelStatus->setText("Open LCD : succeeded.");
        }
    }
}

void MainWindow::on_CloseLCDButton_clicked()
{
    if(m_pfn_PPL398_OpenLCD && m_pfn_PPL500_OpenLCD && m_pfn_PPL501F_OpenLCD)
    {
        on_ClearButton_clicked();

        int nResult = ARI_FAIL;
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nResult = m_pfn_PPL398_OpenLCD(PPL398_DEVICE, false);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_OpenLCD(PPL500_DEVICE, false);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_OpenLCD(PPL501F_DEVICE, false);
        }

        if(nResult == ARI_SUCCESS)
        {
            ui->labelStatus->setText("Close LCD : succeeded.");
        }
    }
}

void MainWindow::on_PenIDButton_clicked()
{
    if(m_pfn_PPL398_GetHWPenID && m_pfn_PPL500_GetHWPenID && m_pfn_PPL501F_GetHWPenID)
    {
        char pPenID[RX_DEVICE_DATA_MAX_SIZE];

        int nResult = ARI_FAIL;
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nResult = m_pfn_PPL398_GetHWPenID(PPL398_DEVICE, pPenID, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_GetHWPenID(PPL500_DEVICE, pPenID, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_GetHWPenID(PPL501F_DEVICE, pPenID, RX_DEVICE_DATA_MAX_SIZE);
        }

        if(nResult == ARI_SUCCESS)
        {
            QString strPenID = QString("Pen ID : %1").arg(pPenID);
            ui->labelStatus->setText(strPenID);
        }
    }
}

void MainWindow::on_PadIDButton_clicked()
{
    if(m_pfn_PPL398_GetHWPadID && m_pfn_PPL500_GetHWPadID && m_pfn_PPL501F_GetHWPadID && m_pfn_PPLC700_GetHWPadID &&
      m_pfn_PPE640_GetHWPadID)
    {
        char pPadID[RX_DEVICE_DATA_MAX_SIZE];

        int nResult = ARI_FAIL;
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nResult = m_pfn_PPL398_GetHWPadID(PPL398_DEVICE, pPadID, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_GetHWPadID(PPL500_DEVICE, pPadID, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_GetHWPadID(PPL501F_DEVICE, pPadID, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            nResult = m_pfn_PPLC700_GetHWPadID(PPLC700_DEVICE, pPadID, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            nResult = m_pfn_PPE640_GetHWPadID(PPE640_DEVICE, pPadID, RX_DEVICE_DATA_MAX_SIZE);
        }

        if(nResult == ARI_SUCCESS)
        {
            QString strPenID = QString("Pad ID : %1").arg(pPadID);
            ui->labelStatus->setText(strPenID);
        }
    }
}

void MainWindow::on_HWVersionButton_clicked()
{
    if(m_pfn_PPL398_GetHWVersion && m_pfn_PPL500_GetHWVersion && m_pfn_PPL501F_GetHWVersion && m_pfn_PPLC700_GetHWVersion &&
      m_pfn_PPE640_GetHWVersion)
    {
        char pVersion[RX_DEVICE_DATA_MAX_SIZE];

        int nResult = ARI_FAIL;
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nResult = m_pfn_PPL398_GetHWVersion(PPL398_DEVICE, pVersion, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_GetHWVersion(PPL500_DEVICE, pVersion, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_GetHWVersion(PPL501F_DEVICE, pVersion, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            nResult = m_pfn_PPLC700_GetHWVersion(PPLC700_DEVICE, pVersion, RX_DEVICE_DATA_MAX_SIZE);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            nResult = m_pfn_PPE640_GetHWVersion(PPE640_DEVICE, pVersion, RX_DEVICE_DATA_MAX_SIZE);
        }

        if(nResult == ARI_SUCCESS)
        {
            QString strPenID = QString("HW Version : %1").arg(pVersion);
            ui->labelStatus->setText(strPenID);
        }
    }
}

void MainWindow::on_cbPenWidth_currentIndexChanged(int index)
{
    if(m_pfn_PPL398_SetPenWidth && m_pfn_PPL500_SetPenWidth && m_pfn_PPL501F_SetPenWidth && m_pfn_PPLC700_SetPenWidth &&
      m_pfn_PPE640_SetPenWidth)
    {
        int nResult = ARI_FAIL;
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nResult = m_pfn_PPL398_SetPenWidth(PPL398_DEVICE, index + 1);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_SetPenWidth(PPL500_DEVICE, index + 1);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_SetPenWidth(PPL501F_DEVICE, index + 1);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            nResult = m_pfn_PPLC700_SetPenWidth(PPLC700_DEVICE, index + 1);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            nResult = m_pfn_PPE640_SetPenWidth(PPE640_DEVICE, index + 1);
        }

        if(nResult == ARI_SUCCESS)
        {
            on_ClearButton_clicked();
            ui->labelStatus->setText("Set Pen Width : " + QString::number(index + 1));
        }
    }
}

void MainWindow::ProcessSignPadEvent(int nEventID)
{
    if(nEventID == SIGNPAD_ENTER_BUTTON)
    {
        ui->labelStatus->setText("Click [Enter] Key on SignPad.");
        on_SaveDrawingImageButton_clicked();
        on_ClearButton_clicked();
    }
    else if(nEventID == SIGNPAD_CANCEL_BUTTON)
    {
        on_ClearButton_clicked();
    }
}

void MainWindow::on_GetSizeButton_clicked()
{
    if(m_pfn_PPL398_GetTotalInkPointsNumber && m_pfn_PPL500_GetTotalInkPointsNumber && m_pfn_PPL501F_GetTotalInkPointsNumber &&
       m_pfn_PPLC700_GetTotalInkPointsNumber && m_pfn_PPE640_GetTotalInkPointsNumber)
    {
        int nInkCount = 0;
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nInkCount = m_pfn_PPL398_GetTotalInkPointsNumber(PPL398_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nInkCount = m_pfn_PPL500_GetTotalInkPointsNumber(PPL500_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nInkCount = m_pfn_PPL501F_GetTotalInkPointsNumber(PPL501F_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            nInkCount = m_pfn_PPLC700_GetTotalInkPointsNumber(PPLC700_DEVICE);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            nInkCount = m_pfn_PPE640_GetTotalInkPointsNumber(PPE640_DEVICE);
        }

        ui->labelStatus->setText("point count of signing : " + QString::number(nInkCount));

        // clear GetPoint combobox...
        ui->cbGetPoint->clear();

        // update GetPoint combobox...
        for(int i = 0; i < nInkCount; i++)
        {
            ui->cbGetPoint->addItem(QString::number(i));
        }
    }
}

void MainWindow::on_GetPointButton_clicked()
{
    if(m_pfn_PPL398_GetInkPointData && m_pfn_PPL398_GetInkPointDataTimeInfo && m_pfn_PPL398_FreeInkPointDataTimeInfo &&
       m_pfn_PPL500_GetInkPointData && m_pfn_PPL500_GetInkPointDataTimeInfo && m_pfn_PPL500_FreeInkPointDataTimeInfo &&
       m_pfn_PPL501F_GetInkPointData && m_pfn_PPL501F_GetInkPointDataTimeInfo && m_pfn_PPL501F_FreeInkPointDataTimeInfo &&
       m_pfn_PPLC700_GetInkPointData && m_pfn_PPLC700_GetInkPointDataTimeInfo && m_pfn_PPLC700_FreeInkPointDataTimeInfo &&
       m_pfn_PPE640_GetInkPointData && m_pfn_PPE640_GetInkPointDataTimeInfo && m_pfn_PPE640_FreeInkPointDataTimeInfo)
    {
        int nCurrentPointIndex = ui->cbGetPoint->currentIndex();
        if(nCurrentPointIndex >= 0)
        {
            INKPOINTDATA currentInkPoint;
            currentInkPoint.nIndex = nCurrentPointIndex;

            int nResult = ARI_FAIL;
            if(m_nSelectedDeviceID == PPL398_DEVICE)
            {
                nResult = m_pfn_PPL398_GetInkPointData(PPL398_DEVICE, currentInkPoint);
                char* pInkPointDataTimeInfo = m_pfn_PPL398_GetInkPointDataTimeInfo(PPL398_DEVICE, nCurrentPointIndex);

                if((nResult == ARI_SUCCESS) && pInkPointDataTimeInfo)
                {
                    QString strPointInfo;
                    strPointInfo.sprintf("index=%d, X=%d, Y=%d, Pressure=%d, time=%s, strokeEnd=%d",
                                         nCurrentPointIndex, currentInkPoint.nX, currentInkPoint.nY, currentInkPoint.nPressureValue,
                                         pInkPointDataTimeInfo, static_cast<int>(currentInkPoint.bStrokeEnd));
                    ui->labelStatus->setText(strPointInfo);
                    m_pfn_PPL398_FreeInkPointDataTimeInfo(PPL398_DEVICE, pInkPointDataTimeInfo);
                }
            }
            else if(m_nSelectedDeviceID == PPL500_DEVICE)
            {
                nResult = m_pfn_PPL500_GetInkPointData(PPL500_DEVICE, currentInkPoint);
                char* pInkPointDataTimeInfo = m_pfn_PPL500_GetInkPointDataTimeInfo(PPL500_DEVICE, nCurrentPointIndex);

                if((nResult == ARI_SUCCESS) && pInkPointDataTimeInfo)
                {
                    QString strPointInfo;
                    strPointInfo.sprintf("index=%d, X=%d, Y=%d, Pressure=%d, time=%s, strokeEnd=%d",
                                         nCurrentPointIndex, currentInkPoint.nX, currentInkPoint.nY, currentInkPoint.nPressureValue,
                                         pInkPointDataTimeInfo, static_cast<int>(currentInkPoint.bStrokeEnd));
                    ui->labelStatus->setText(strPointInfo);
                    m_pfn_PPL500_FreeInkPointDataTimeInfo(PPL500_DEVICE, pInkPointDataTimeInfo);
                }
            }
            else if(m_nSelectedDeviceID == PPL501F_DEVICE)
            {
                nResult = m_pfn_PPL501F_GetInkPointData(PPL501F_DEVICE, currentInkPoint);
                char* pInkPointDataTimeInfo = m_pfn_PPL501F_GetInkPointDataTimeInfo(PPL501F_DEVICE, nCurrentPointIndex);

                if((nResult == ARI_SUCCESS) && pInkPointDataTimeInfo)
                {
                    QString strPointInfo;
                    strPointInfo.sprintf("index=%d, X=%d, Y=%d, Pressure=%d, time=%s, strokeEnd=%d",
                                         nCurrentPointIndex, currentInkPoint.nX, currentInkPoint.nY, currentInkPoint.nPressureValue,
                                         pInkPointDataTimeInfo, static_cast<int>(currentInkPoint.bStrokeEnd));
                    ui->labelStatus->setText(strPointInfo);
                    m_pfn_PPL501F_FreeInkPointDataTimeInfo(PPL501F_DEVICE, pInkPointDataTimeInfo);
                }
            }
            else if(m_nSelectedDeviceID == PPLC700_DEVICE)
            {
                nResult = m_pfn_PPLC700_GetInkPointData(PPLC700_DEVICE, currentInkPoint);
                char* pInkPointDataTimeInfo = m_pfn_PPLC700_GetInkPointDataTimeInfo(PPLC700_DEVICE, nCurrentPointIndex);

                if((nResult == ARI_SUCCESS) && pInkPointDataTimeInfo)
                {
                    QString strPointInfo;
                    strPointInfo.sprintf("index=%d, X=%d, Y=%d, Pressure=%d, time=%s, strokeEnd=%d",
                                         nCurrentPointIndex, currentInkPoint.nX, currentInkPoint.nY, currentInkPoint.nPressureValue,
                                         pInkPointDataTimeInfo, static_cast<int>(currentInkPoint.bStrokeEnd));
                    ui->labelStatus->setText(strPointInfo);
                    m_pfn_PPLC700_FreeInkPointDataTimeInfo(PPLC700_DEVICE, pInkPointDataTimeInfo);
                }
            }
            else if(m_nSelectedDeviceID == PPE640_DEVICE)
            {
                nResult = m_pfn_PPE640_GetInkPointData(PPE640_DEVICE, currentInkPoint);
                char* pInkPointDataTimeInfo = m_pfn_PPE640_GetInkPointDataTimeInfo(PPE640_DEVICE, nCurrentPointIndex);

                if((nResult == ARI_SUCCESS) && pInkPointDataTimeInfo)
                {
                    QString strPointInfo;
                    strPointInfo.sprintf("index=%d, X=%d, Y=%d, Pressure=%d, time=%s, strokeEnd=%d",
                                         nCurrentPointIndex, currentInkPoint.nX, currentInkPoint.nY, currentInkPoint.nPressureValue,
                                         pInkPointDataTimeInfo, static_cast<int>(currentInkPoint.bStrokeEnd));
                    ui->labelStatus->setText(strPointInfo);
                    m_pfn_PPE640_FreeInkPointDataTimeInfo(PPE640_DEVICE, pInkPointDataTimeInfo);
                }
            }
        }
    }
}

void MainWindow::on_EncodeButton_clicked()
{
    if(m_pfn_PPL398_Base64Encode && m_pfn_PPL398_Base64EncodeFree &&
       m_pfn_PPL500_Base64Encode && m_pfn_PPL500_Base64EncodeFree &&
       m_pfn_PPL501F_Base64Encode && m_pfn_PPL501F_Base64EncodeFree &&
       m_pfn_PPLC700_Base64Encode && m_pfn_PPLC700_Base64EncodeFree &&
       m_pfn_PPE640_Base64Encode && m_pfn_PPE640_Base64EncodeFree)
    {
        int nIndex = ui->cbEncode->currentIndex();
        if(nIndex >= 0)
        {
            ++nIndex;
            if(nIndex == 4)
                nIndex += 2;    // for EBITI_INK id...

            if(m_nSelectedDeviceID == PPL398_DEVICE)
            {
                char* pEncodeBase64Image = m_pfn_PPL398_Base64Encode(PPL398_DEVICE, nIndex);

                if(pEncodeBase64Image)
                {
                    QString strBase64Image(pEncodeBase64Image);
                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strBase64Image);
                    m_pfn_PPL398_Base64EncodeFree(PPL398_DEVICE, pEncodeBase64Image);
                    ui->labelStatus->setText("Encode Base64 Image : succeeded.");
                }
                else
                {
                     ui->labelStatus->setText("Encode Base64 Image : Failed !");
                }
            }
            else if(m_nSelectedDeviceID == PPL500_DEVICE)
            {
                char* pEncodeBase64Image = m_pfn_PPL500_Base64Encode(PPL500_DEVICE, nIndex);

                if(pEncodeBase64Image)
                {
                    QString strBase64Image(pEncodeBase64Image);
                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strBase64Image);
                    m_pfn_PPL500_Base64EncodeFree(PPL500_DEVICE, pEncodeBase64Image);
                    ui->labelStatus->setText("Encode Base64 Image : succeeded.");
                }
                else
                {
                     ui->labelStatus->setText("Encode Base64 Image : Failed !");
                }
            }
            else if(m_nSelectedDeviceID == PPL501F_DEVICE)
            {
                char* pEncodeBase64Image = m_pfn_PPL501F_Base64Encode(PPL501F_DEVICE, nIndex);

                if(pEncodeBase64Image)
                {
                    QString strBase64Image(pEncodeBase64Image);
                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strBase64Image);
                    m_pfn_PPL501F_Base64EncodeFree(PPL501F_DEVICE, pEncodeBase64Image);
                    ui->labelStatus->setText("Encode Base64 Image : succeeded.");
                }
                else
                {
                     ui->labelStatus->setText("Encode Base64 Image : Failed !");
                }
            }
            else if(m_nSelectedDeviceID == PPLC700_DEVICE)
            {
                char* pEncodeBase64Image = m_pfn_PPLC700_Base64Encode(PPLC700_DEVICE, nIndex);

                if(pEncodeBase64Image)
                {
                    QString strBase64Image(pEncodeBase64Image);
                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strBase64Image);
                    m_pfn_PPLC700_Base64EncodeFree(PPLC700_DEVICE, pEncodeBase64Image);
                    ui->labelStatus->setText("Encode Base64 Image : succeeded.");
                }
                else
                {
                     ui->labelStatus->setText("Encode Base64 Image : Failed !");
                }
            }
            else if(m_nSelectedDeviceID == PPE640_DEVICE)
            {
                char* pEncodeBase64Image = m_pfn_PPE640_Base64Encode(PPE640_DEVICE, nIndex);

                if(pEncodeBase64Image)
                {
                    QString strBase64Image(pEncodeBase64Image);
                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strBase64Image);
                    m_pfn_PPE640_Base64EncodeFree(PPE640_DEVICE, pEncodeBase64Image);
                    ui->labelStatus->setText("Encode Base64 Image : succeeded.");
                }
                else
                {
                     ui->labelStatus->setText("Encode Base64 Image : Failed !");
                }
            }
        }
    }
}

void MainWindow::on_DecodeButton_clicked()
{
    QString strEncodedData = ui->plainTextEdit_EncodeDecodeData->toPlainText();
    if(!strEncodedData.isEmpty())
    {
        std::string pstrEncodedData = strEncodedData.toStdString();
        const char* pEncodedData = pstrEncodedData.c_str();

        int nIndex = ui->cbEncode->currentIndex();
        if(nIndex >= 0)
        {
            ++nIndex;
            if(nIndex == 4)
                nIndex += 2;    // for EBITI_INK id...

            wchar_t wszImageFilePath[MAX_PATH] = { 0 };

            switch (nIndex)
            {
                case EBITI_BITMAP:
                    wcscpy(wszImageFilePath, L"/tmp/decodeImage.bmp");
                    break;

                case EBITI_JPEG:
                    wcscpy(wszImageFilePath, L"/tmp/decodeImage.jpg");
                    break;

                case EBITI_PNG:
                    wcscpy(wszImageFilePath, L"/tmp/decodeImage.png");
                    break;

                case EBITI_INK:
                    break;
            }

            if(m_nSelectedDeviceID == PPL398_DEVICE)
            {
                if(m_pfn_PPL398_Base64Decode)
                {
                    int nResult = m_pfn_PPL398_Base64Decode(PPL398_DEVICE, nIndex, pEncodedData, wszImageFilePath);
                    if(nResult == ARI_SUCCESS)
                    {
                        if(nIndex == EBITI_INK)
                        {
                            if(m_pfn_PPL398_GetTotalDecodeInkPointsNumber && m_pfn_PPL398_GetDecodeInkPointData)
                            {
                                int nTotalDecodeInkPointsNumber = m_pfn_PPL398_GetTotalDecodeInkPointsNumber(PPL398_DEVICE);
                                int nX, nY, nStrokeEnd;
                                QString strDecodeInkPointsData = "";
                                QString strCurrentInkPointData;

                                for(int i = 0; i < nTotalDecodeInkPointsNumber; i++)
                                {
                                    nX = m_pfn_PPL398_GetDecodeInkPointData(PPL398_DEVICE, i, INKDATATYPE_X);
                                    nY = m_pfn_PPL398_GetDecodeInkPointData(PPL398_DEVICE, i, INKDATATYPE_Y);
                                    nStrokeEnd = m_pfn_PPL398_GetDecodeInkPointData(PPL398_DEVICE, i, INKDATATYPE_STROKEEND);

                                    strCurrentInkPointData.sprintf("index=%d, X=%d, Y=%d, End=%d\n", i, nX, nY, nStrokeEnd);
                                    strDecodeInkPointsData += strCurrentInkPointData;
                                }

                                if(nTotalDecodeInkPointsNumber > 0)
                                {
                                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strDecodeInkPointsData);
                                    ui->labelStatus->setText("Decode Ink Points Data : succeeded.");
                                }
                                else
                                {
                                    ui->labelStatus->setText("Decode Ink Points Data : Failed ! (None of ink data !)");
                                }
                            }
                        }
                        else
                        {
                            QString strImageFilePath = QString::fromWCharArray(wszImageFilePath);
                            QString strResult = QString("Decode Base64 Image (at file path : %1) : succeeded.").arg(strImageFilePath);
                            ui->labelStatus->setText(strResult);
                        }
                    }
                    else
                        ui->labelStatus->setText("Decode Base64 Image : Failed ! (" + QString::number(nResult) + ")");
                }
            }
            else if(m_nSelectedDeviceID == PPL500_DEVICE)
            {
                if(m_pfn_PPL500_Base64Decode)
                {
                    int nResult = m_pfn_PPL500_Base64Decode(PPL500_DEVICE, nIndex, pEncodedData, wszImageFilePath);
                    if(nResult == ARI_SUCCESS)
                    {
                        if(nIndex == EBITI_INK)
                        {
                            if(m_pfn_PPL500_GetTotalDecodeInkPointsNumber && m_pfn_PPL500_GetDecodeInkPointData)
                            {
                                int nTotalDecodeInkPointsNumber = m_pfn_PPL500_GetTotalDecodeInkPointsNumber(PPL500_DEVICE);
                                int nX, nY, nStrokeEnd;
                                QString strDecodeInkPointsData = "";
                                QString strCurrentInkPointData;

                                for(int i = 0; i < nTotalDecodeInkPointsNumber; i++)
                                {
                                    nX = m_pfn_PPL500_GetDecodeInkPointData(PPL500_DEVICE, i, INKDATATYPE_X);
                                    nY = m_pfn_PPL500_GetDecodeInkPointData(PPL500_DEVICE, i, INKDATATYPE_Y);
                                    nStrokeEnd = m_pfn_PPL500_GetDecodeInkPointData(PPL500_DEVICE, i, INKDATATYPE_STROKEEND);

                                    strCurrentInkPointData.sprintf("index=%d, X=%d, Y=%d, End=%d\n", i, nX, nY, nStrokeEnd);
                                    strDecodeInkPointsData += strCurrentInkPointData;
                                }

                                if(nTotalDecodeInkPointsNumber > 0)
                                {
                                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strDecodeInkPointsData);
                                    ui->labelStatus->setText("Decode Ink Points Data : succeeded.");
                                }
                                else
                                {
                                    ui->labelStatus->setText("Decode Ink Points Data : Failed ! (None of ink data !)");
                                }
                            }
                        }
                        else
                        {
                            QString strImageFilePath = QString::fromWCharArray(wszImageFilePath);
                            QString strResult = QString("Decode Base64 Image (at file path : %1) : succeeded.").arg(strImageFilePath);
                            ui->labelStatus->setText(strResult);
                        }
                    }
                    else
                        ui->labelStatus->setText("Decode Base64 Image : Failed ! (" + QString::number(nResult) + ")");
                }
            }
            else if(m_nSelectedDeviceID == PPL501F_DEVICE)
            {
                if(m_pfn_PPL501F_Base64Decode)
                {
                    int nResult = m_pfn_PPL501F_Base64Decode(PPL501F_DEVICE, nIndex, pEncodedData, wszImageFilePath);
                    if(nResult == ARI_SUCCESS)
                    {
                        if(nIndex == EBITI_INK)
                        {
                            if(m_pfn_PPL501F_GetTotalDecodeInkPointsNumber && m_pfn_PPL501F_GetDecodeInkPointData)
                            {
                                int nTotalDecodeInkPointsNumber = m_pfn_PPL501F_GetTotalDecodeInkPointsNumber(PPL501F_DEVICE);
                                int nX, nY, nStrokeEnd;
                                QString strDecodeInkPointsData = "";
                                QString strCurrentInkPointData;

                                for(int i = 0; i < nTotalDecodeInkPointsNumber; i++)
                                {
                                    nX = m_pfn_PPL501F_GetDecodeInkPointData(PPL501F_DEVICE, i, INKDATATYPE_X);
                                    nY = m_pfn_PPL501F_GetDecodeInkPointData(PPL501F_DEVICE, i, INKDATATYPE_Y);
                                    nStrokeEnd = m_pfn_PPL501F_GetDecodeInkPointData(PPL501F_DEVICE, i, INKDATATYPE_STROKEEND);

                                    strCurrentInkPointData.sprintf("index=%d, X=%d, Y=%d, End=%d\n", i, nX, nY, nStrokeEnd);
                                    strDecodeInkPointsData += strCurrentInkPointData;
                                }

                                if(nTotalDecodeInkPointsNumber > 0)
                                {
                                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strDecodeInkPointsData);
                                    ui->labelStatus->setText("Decode Ink Points Data : succeeded.");
                                }
                                else
                                {
                                    ui->labelStatus->setText("Decode Ink Points Data : Failed ! (None of ink data !)");
                                }
                            }
                        }
                        else
                        {
                            QString strImageFilePath = QString::fromWCharArray(wszImageFilePath);
                            QString strResult = QString("Decode Base64 Image (at file path : %1) : succeeded.").arg(strImageFilePath);
                            ui->labelStatus->setText(strResult);
                        }
                    }
                    else
                        ui->labelStatus->setText("Decode Base64 Image : Failed ! (" + QString::number(nResult) + ")");
                }
            }
            else if(m_nSelectedDeviceID == PPLC700_DEVICE)
            {
                if(m_pfn_PPLC700_Base64Decode)
                {
                    int nResult = m_pfn_PPLC700_Base64Decode(PPLC700_DEVICE, nIndex, pEncodedData, wszImageFilePath);
                    if(nResult == ARI_SUCCESS)
                    {
                        if(nIndex == EBITI_INK)
                        {
                            if(m_pfn_PPLC700_GetTotalDecodeInkPointsNumber && m_pfn_PPLC700_GetDecodeInkPointData)
                            {
                                int nTotalDecodeInkPointsNumber = m_pfn_PPLC700_GetTotalDecodeInkPointsNumber(PPLC700_DEVICE);
                                int nX, nY, nStrokeEnd;
                                QString strDecodeInkPointsData = "";
                                QString strCurrentInkPointData;

                                for(int i = 0; i < nTotalDecodeInkPointsNumber; i++)
                                {
                                    nX = m_pfn_PPLC700_GetDecodeInkPointData(PPLC700_DEVICE, i, INKDATATYPE_X);
                                    nY = m_pfn_PPLC700_GetDecodeInkPointData(PPLC700_DEVICE, i, INKDATATYPE_Y);
                                    nStrokeEnd = m_pfn_PPLC700_GetDecodeInkPointData(PPLC700_DEVICE, i, INKDATATYPE_STROKEEND);

                                    strCurrentInkPointData.sprintf("index=%d, X=%d, Y=%d, End=%d\n", i, nX, nY, nStrokeEnd);
                                    strDecodeInkPointsData += strCurrentInkPointData;
                                }

                                if(nTotalDecodeInkPointsNumber > 0)
                                {
                                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strDecodeInkPointsData);
                                    ui->labelStatus->setText("Decode Ink Points Data : succeeded.");
                                }
                                else
                                {
                                    ui->labelStatus->setText("Decode Ink Points Data : Failed ! (None of ink data !)");
                                }
                            }
                        }
                        else
                        {
                            QString strImageFilePath = QString::fromWCharArray(wszImageFilePath);
                            QString strResult = QString("Decode Base64 Image (at file path : %1) : succeeded.").arg(strImageFilePath);
                            ui->labelStatus->setText(strResult);
                        }
                    }
                    else
                        ui->labelStatus->setText("Decode Base64 Image : Failed ! (" + QString::number(nResult) + ")");
                }
            }
            else if(m_nSelectedDeviceID == PPE640_DEVICE)
            {
                if(m_pfn_PPE640_Base64Decode)
                {
                    int nResult = m_pfn_PPE640_Base64Decode(PPE640_DEVICE, nIndex, pEncodedData, wszImageFilePath);
                    if(nResult == ARI_SUCCESS)
                    {
                        if(nIndex == EBITI_INK)
                        {
                            if(m_pfn_PPE640_GetTotalDecodeInkPointsNumber && m_pfn_PPE640_GetDecodeInkPointData)
                            {
                                int nTotalDecodeInkPointsNumber = m_pfn_PPE640_GetTotalDecodeInkPointsNumber(PPE640_DEVICE);
                                int nX, nY, nStrokeEnd;
                                QString strDecodeInkPointsData = "";
                                QString strCurrentInkPointData;

                                for(int i = 0; i < nTotalDecodeInkPointsNumber; i++)
                                {
                                    nX = m_pfn_PPE640_GetDecodeInkPointData(PPE640_DEVICE, i, INKDATATYPE_X);
                                    nY = m_pfn_PPE640_GetDecodeInkPointData(PPE640_DEVICE, i, INKDATATYPE_Y);
                                    nStrokeEnd = m_pfn_PPE640_GetDecodeInkPointData(PPE640_DEVICE, i, INKDATATYPE_STROKEEND);

                                    strCurrentInkPointData.sprintf("index=%d, X=%d, Y=%d, End=%d\n", i, nX, nY, nStrokeEnd);
                                    strDecodeInkPointsData += strCurrentInkPointData;
                                }

                                if(nTotalDecodeInkPointsNumber > 0)
                                {
                                    ui->plainTextEdit_EncodeDecodeData->setPlainText(strDecodeInkPointsData);
                                    ui->labelStatus->setText("Decode Ink Points Data : succeeded.");
                                }
                                else
                                {
                                    ui->labelStatus->setText("Decode Ink Points Data : Failed ! (None of ink data !)");
                                }
                            }
                        }
                        else
                        {
                            QString strImageFilePath = QString::fromWCharArray(wszImageFilePath);
                            QString strResult = QString("Decode Base64 Image (at file path : %1) : succeeded.").arg(strImageFilePath);
                            ui->labelStatus->setText(strResult);
                        }
                    }
                    else
                        ui->labelStatus->setText("Decode Base64 Image : Failed ! (" + QString::number(nResult) + ")");
                }
            }
        }
    }
    else
    {
        ui->labelStatus->setText("Decode Base64 Image : Failed ! (None of encoded data !)");
    }
}

void MainWindow::on_AboutButton_clicked()
{
    if(m_pfn_PPL398_AboutBox && m_pfn_PPL500_AboutBox && m_pfn_PPL501F_AboutBox && m_pfn_PPLC700_AboutBox &&
      m_pfn_PPE640_AboutBox)
    {
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            m_pfn_PPL398_AboutBox(this);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            m_pfn_PPL500_AboutBox(this);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            m_pfn_PPL501F_AboutBox(this);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            m_pfn_PPLC700_AboutBox(this);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            m_pfn_PPE640_AboutBox(this);
        }
    }
}

void MainWindow::on_GetDeviceInfoButton_clicked()
{
    if(m_pfn_PPL398_GetDeviceInfo)
    {
        int nIndex = ui->cbGetDeviceInfo->currentIndex() + 1;
        int nResult = ARI_FAIL;

        switch (nIndex)
        {
            case DIID_GET_STATUS:
                {
                    bool bDeviceConnected = false;

                    if(m_nSelectedDeviceID == PPL398_DEVICE)
                        nResult = m_pfn_PPL398_GetDeviceInfo(PPL398_DEVICE, nIndex, reinterpret_cast<void*>(&bDeviceConnected));
                    else if(m_nSelectedDeviceID == PPL500_DEVICE)
                    {
                        nResult = m_pfn_PPL500_GetDeviceInfo(PPL500_DEVICE, nIndex, reinterpret_cast<void*>(&bDeviceConnected));
                    }
                    else if(m_nSelectedDeviceID == PPL501F_DEVICE)
                    {
                        nResult = m_pfn_PPL501F_GetDeviceInfo(PPL501F_DEVICE, nIndex, reinterpret_cast<void*>(&bDeviceConnected));
                    }
                    else if(m_nSelectedDeviceID == PPLC700_DEVICE)
                    {
                        nResult = m_pfn_PPLC700_GetDeviceInfo(PPLC700_DEVICE, nIndex, reinterpret_cast<void*>(&bDeviceConnected));
                    }
                    else if(m_nSelectedDeviceID == PPE640_DEVICE)
                    {
                        nResult = m_pfn_PPE640_GetDeviceInfo(PPE640_DEVICE, nIndex, reinterpret_cast<void*>(&bDeviceConnected));
                    }

                    if(nResult == ARI_SUCCESS)
                        ui->labelStatus->setText("Get Device Info (Device Connection) : " + QString::number(bDeviceConnected));
                    else
                        ui->labelStatus->setText("Get Device Info (Device Connection) Failed ! (" + QString::number(nResult) + ")");
                }
                break;

            case DIID_GET_AXIS_X:
                {
                    PPAXIS ax;

                    if(m_nSelectedDeviceID == PPL398_DEVICE)
                        nResult = m_pfn_PPL398_GetDeviceInfo(PPL398_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    else if(m_nSelectedDeviceID == PPL500_DEVICE)
                    {
                        nResult = m_pfn_PPL500_GetDeviceInfo(PPL500_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    }
                    else if(m_nSelectedDeviceID == PPL501F_DEVICE)
                    {
                        nResult = m_pfn_PPL501F_GetDeviceInfo(PPL501F_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    }
                    else if(m_nSelectedDeviceID == PPLC700_DEVICE)
                    {
                        nResult = m_pfn_PPLC700_GetDeviceInfo(PPLC700_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    }
                    else if(m_nSelectedDeviceID == PPE640_DEVICE)
                    {
                        nResult = m_pfn_PPE640_GetDeviceInfo(PPE640_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    }

                    if(nResult == ARI_SUCCESS)
                    {
                        QString strXRange;
                        strXRange.sprintf("Get Device Info (Device X Range) : %d - %d", ax.nAXMin, ax.nAXMax);
                        ui->labelStatus->setText(strXRange);
                    }
                    else
                        ui->labelStatus->setText("Get Device Info (Device X Range) Failed ! (" + QString::number(nResult) + ")");
                }
                break;

            case DIID_GET_AXIS_Y:
                {
                    PPAXIS ax;

                    if(m_nSelectedDeviceID == PPL398_DEVICE)
                        nResult = m_pfn_PPL398_GetDeviceInfo(PPL398_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    else if(m_nSelectedDeviceID == PPL500_DEVICE)
                    {
                        nResult = m_pfn_PPL500_GetDeviceInfo(PPL500_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    }
                    else if(m_nSelectedDeviceID == PPL501F_DEVICE)
                    {
                        nResult = m_pfn_PPL501F_GetDeviceInfo(PPL501F_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    }
                    else if(m_nSelectedDeviceID == PPLC700_DEVICE)
                    {
                        nResult = m_pfn_PPLC700_GetDeviceInfo(PPLC700_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    }
                    else if(m_nSelectedDeviceID == PPE640_DEVICE)
                    {
                        nResult = m_pfn_PPE640_GetDeviceInfo(PPE640_DEVICE, nIndex, reinterpret_cast<void*>(&ax));
                    }

                    if(nResult == ARI_SUCCESS)
                    {
                        QString strYRange;
                        strYRange.sprintf("Get Device Info (Device Y Range) : %d - %d", ax.nAXMin, ax.nAXMax);
                        ui->labelStatus->setText(strYRange);
                    }
                    else
                        ui->labelStatus->setText("Get Device Info (Device Y Range) Failed ! (" + QString::number(nResult) + ")");
                }
                break;

            case DIID_GET_PRESSURE:
                {
                    int nPressureValue = 0;

                    if(m_nSelectedDeviceID == PPL398_DEVICE)
                        nResult = m_pfn_PPL398_GetDeviceInfo(PPL398_DEVICE, nIndex, reinterpret_cast<void*>(&nPressureValue));
                    else if(m_nSelectedDeviceID == PPL500_DEVICE)
                    {
                        nResult = m_pfn_PPL500_GetDeviceInfo(PPL500_DEVICE, nIndex, reinterpret_cast<void*>(&nPressureValue));
                    }
                    else if(m_nSelectedDeviceID == PPL501F_DEVICE)
                    {
                        nResult = m_pfn_PPL501F_GetDeviceInfo(PPL501F_DEVICE, nIndex, reinterpret_cast<void*>(&nPressureValue));
                    }
                    else if(m_nSelectedDeviceID == PPLC700_DEVICE)
                    {
                        nResult = m_pfn_PPLC700_GetDeviceInfo(PPLC700_DEVICE, nIndex, reinterpret_cast<void*>(&nPressureValue));
                    }
                    else if(m_nSelectedDeviceID == PPE640_DEVICE)
                    {
                        nResult = m_pfn_PPE640_GetDeviceInfo(PPE640_DEVICE, nIndex, reinterpret_cast<void*>(&nPressureValue));
                    }

                    if(nResult == ARI_SUCCESS)
                        ui->labelStatus->setText("Get Device Info (Device Pressure Range) : " + QString::number(nPressureValue));
                    else
                        ui->labelStatus->setText("Get Device Info (Device Pressure Range) Failed ! (" + QString::number(nResult) + ")");
                }
                break;

            case DIID_GET_VENDOR:
                {
                    char cVendor[MAX_PATH];

                    if(m_nSelectedDeviceID == PPL398_DEVICE)
                        nResult = m_pfn_PPL398_GetDeviceInfo(PPL398_DEVICE, nIndex, reinterpret_cast<void*>(cVendor));
                    else if(m_nSelectedDeviceID == PPL500_DEVICE)
                    {
                        nResult = m_pfn_PPL500_GetDeviceInfo(PPL500_DEVICE, nIndex, reinterpret_cast<void*>(cVendor));
                    }
                    else if(m_nSelectedDeviceID == PPL501F_DEVICE)
                    {
                        nResult = m_pfn_PPL501F_GetDeviceInfo(PPL501F_DEVICE, nIndex, reinterpret_cast<void*>(cVendor));
                    }
                    else if(m_nSelectedDeviceID == PPLC700_DEVICE)
                    {
                        nResult = m_pfn_PPLC700_GetDeviceInfo(PPLC700_DEVICE, nIndex, reinterpret_cast<void*>(cVendor));
                    }
                    else if(m_nSelectedDeviceID == PPE640_DEVICE)
                    {
                        nResult = m_pfn_PPE640_GetDeviceInfo(PPE640_DEVICE, nIndex, reinterpret_cast<void*>(cVendor));
                    }

                    if(nResult == ARI_SUCCESS)
                        ui->labelStatus->setText("Get Device Info (Device Vendor) : " + QString(cVendor));
                    else
                        ui->labelStatus->setText("Get Device Info (Device Vendor) Failed ! (" + QString::number(nResult) + ")");
                }
                break;

            case DIID_GET_PRODUCT:
                {
                    char cProduct[MAX_PATH];

                    if(m_nSelectedDeviceID == PPL398_DEVICE)
                        nResult = m_pfn_PPL398_GetDeviceInfo(PPL398_DEVICE, nIndex, reinterpret_cast<void*>(cProduct));
                    else if(m_nSelectedDeviceID == PPL500_DEVICE)
                    {
                        nResult = m_pfn_PPL500_GetDeviceInfo(PPL500_DEVICE, nIndex, reinterpret_cast<void*>(cProduct));
                    }
                    else if(m_nSelectedDeviceID == PPL501F_DEVICE)
                    {
                        nResult = m_pfn_PPL501F_GetDeviceInfo(PPL501F_DEVICE, nIndex, reinterpret_cast<void*>(cProduct));
                    }
                    else if(m_nSelectedDeviceID == PPLC700_DEVICE)
                    {
                        nResult = m_pfn_PPLC700_GetDeviceInfo(PPLC700_DEVICE, nIndex, reinterpret_cast<void*>(cProduct));
                    }
                    else if(m_nSelectedDeviceID == PPE640_DEVICE)
                    {
                        nResult = m_pfn_PPE640_GetDeviceInfo(PPE640_DEVICE, nIndex, reinterpret_cast<void*>(cProduct));
                    }

                    if(nResult == ARI_SUCCESS)
                        ui->labelStatus->setText("Get Device Info (Device Product Name) : " + QString(cProduct));
                    else
                        ui->labelStatus->setText("Get Device Info (Device Product Name) Failed ! (" + QString::number(nResult) + ")");
                }
                break;

            case DIID_GET_DRV_VER:
                {
                    PPSDKVERSION sdkVersion;

                    if(m_nSelectedDeviceID == PPL398_DEVICE)
                        nResult = m_pfn_PPL398_GetDeviceInfo(PPL398_DEVICE, nIndex, reinterpret_cast<void*>(&sdkVersion));
                    else if(m_nSelectedDeviceID == PPL500_DEVICE)
                    {
                        nResult = m_pfn_PPL500_GetDeviceInfo(PPL500_DEVICE, nIndex, reinterpret_cast<void*>(&sdkVersion));
                    }
                    else if(m_nSelectedDeviceID == PPL501F_DEVICE)
                    {
                        nResult = m_pfn_PPL501F_GetDeviceInfo(PPL501F_DEVICE, nIndex, reinterpret_cast<void*>(&sdkVersion));
                    }
                    else if(m_nSelectedDeviceID == PPLC700_DEVICE)
                    {
                        nResult = m_pfn_PPLC700_GetDeviceInfo(PPLC700_DEVICE, nIndex, reinterpret_cast<void*>(&sdkVersion));
                    }
                    else if(m_nSelectedDeviceID == PPE640_DEVICE)
                    {
                        nResult = m_pfn_PPE640_GetDeviceInfo(PPE640_DEVICE, nIndex, reinterpret_cast<void*>(&sdkVersion));
                    }

                    if(nResult == ARI_SUCCESS)
                    {
                        QString strSDKVersion;
                        strSDKVersion.sprintf("Get Device Info (SDK Version) : %d.%d",
                                              sdkVersion.nMajorVersion, sdkVersion.nMinorVersion);
                        ui->labelStatus->setText(strSDKVersion);
                    }
                    else
                        ui->labelStatus->setText("Get Device Info (SDK Version) Failed ! (" + QString::number(nResult) + ")");
                }
                break;
        }
    }
}

void MainWindow::on_SetClipMarginButton_clicked()
{
    if(m_pfn_PPL398_SetSaveClipImageMargin)
    {
        int nClipMarginX = ui->lineEdit_SetClipMarginWidth->text().toInt();
        int nClipMarginY = ui->lineEdit_SetClipMarginHeight->text().toInt();

        int nResult = ARI_FAIL;

        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            if((nClipMarginX == 0) && (nClipMarginY == 0))
            {
                nResult = m_pfn_PPL398_SetSaveClipImageMargin(PPL398_DEVICE, false, nClipMarginX, nClipMarginY);
            }
            else
            {
                nResult = m_pfn_PPL398_SetSaveClipImageMargin(PPL398_DEVICE, true, nClipMarginX, nClipMarginY);
            }
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            if((nClipMarginX == 0) && (nClipMarginY == 0))
            {
                nResult = m_pfn_PPL500_SetSaveClipImageMargin(PPL500_DEVICE, false, nClipMarginX, nClipMarginY);
            }
            else
            {
                nResult = m_pfn_PPL500_SetSaveClipImageMargin(PPL500_DEVICE, true, nClipMarginX, nClipMarginY);
            }
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            if((nClipMarginX == 0) && (nClipMarginY == 0))
            {
                nResult = m_pfn_PPL501F_SetSaveClipImageMargin(PPL501F_DEVICE, false, nClipMarginX, nClipMarginY);
            }
            else
            {
                nResult = m_pfn_PPL501F_SetSaveClipImageMargin(PPL501F_DEVICE, true, nClipMarginX, nClipMarginY);
            }
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            if((nClipMarginX == 0) && (nClipMarginY == 0))
            {
                nResult = m_pfn_PPLC700_SetSaveClipImageMargin(PPLC700_DEVICE, false, nClipMarginX, nClipMarginY);
            }
            else
            {
                nResult = m_pfn_PPLC700_SetSaveClipImageMargin(PPLC700_DEVICE, true, nClipMarginX, nClipMarginY);
            }
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            if((nClipMarginX == 0) && (nClipMarginY == 0))
            {
                nResult = m_pfn_PPE640_SetSaveClipImageMargin(PPE640_DEVICE, false, nClipMarginX, nClipMarginY);
            }
            else
            {
                nResult = m_pfn_PPE640_SetSaveClipImageMargin(PPE640_DEVICE, true, nClipMarginX, nClipMarginY);
            }
        }

        if(nResult == ARI_SUCCESS)
            ui->labelStatus->setText("Set Clip Image Margin : succeeded.");
        else
            ui->labelStatus->setText("Set Clip Image Margin : Failed ! (" + QString::number(nResult) + ")");
    }
}

void MainWindow::on_SaveDrawingImageButton_clicked()
{
    if(m_pfn_PPL398_SaveDrawingImage && m_pfn_PPL500_SaveDrawingImage && m_pfn_PPL501F_SaveDrawingImage &&
       m_pfn_PPLC700_SaveDrawingImage && m_pfn_PPE640_SaveDrawingImage)
    {
        int nCurrentImageTypeIndex = ui->cbSaveDrawingImage->currentIndex();
        if(nCurrentImageTypeIndex >= 0)
        {
            ++nCurrentImageTypeIndex;
            if(nCurrentImageTypeIndex >= 4)
                nCurrentImageTypeIndex += 3;    // for ITI_PDF/ITI_SVG id...

            wchar_t wszImageFilePath[MAX_PATH];

            switch (nCurrentImageTypeIndex)
            {
                case ITI_BITMAP:
                    wcscpy(wszImageFilePath, L"/tmp/test.bmp");
                    break;

                case ITI_JPEG:
                    wcscpy(wszImageFilePath, L"/tmp/test.jpg");
                    break;

                case ITI_PNG:
                    wcscpy(wszImageFilePath, L"/tmp/test.png");
                    break;

                case ITI_PDF:
                    wcscpy(wszImageFilePath, L"/tmp/test.pdf");
                    break;

                case ITI_SVG:
                    wcscpy(wszImageFilePath, L"/tmp/test.svg");
                    break;
            }

            int nCurrentDPIIndex = ui->cbSaveDrawingImageDPI->currentIndex();
            int nResult = ARI_FAIL;

            if(m_nSelectedDeviceID == PPL398_DEVICE)
                nResult = m_pfn_PPL398_SaveDrawingImage(PPL398_DEVICE, nCurrentImageTypeIndex, wszImageFilePath, nCurrentDPIIndex);
            else if(m_nSelectedDeviceID == PPL500_DEVICE)
            {
                nResult = m_pfn_PPL500_SaveDrawingImage(PPL500_DEVICE, nCurrentImageTypeIndex, wszImageFilePath, nCurrentDPIIndex);
            }
            else if(m_nSelectedDeviceID == PPL501F_DEVICE)
            {
                nResult = m_pfn_PPL501F_SaveDrawingImage(PPL501F_DEVICE, nCurrentImageTypeIndex, wszImageFilePath, nCurrentDPIIndex);
            }
            else if(m_nSelectedDeviceID == PPLC700_DEVICE)
            {
                nResult = m_pfn_PPLC700_SaveDrawingImage(PPLC700_DEVICE, nCurrentImageTypeIndex, wszImageFilePath, nCurrentDPIIndex);
            }
            else if(m_nSelectedDeviceID == PPE640_DEVICE)
            {
                nResult = m_pfn_PPE640_SaveDrawingImage(PPE640_DEVICE, nCurrentImageTypeIndex, wszImageFilePath, nCurrentDPIIndex);
            }

            if(nResult == ARI_SUCCESS)
            {
                QString strImageFilePath = QString::fromWCharArray(wszImageFilePath);
                QString strResult = QString("Save Drawing Image (at file path : %1) : succeeded.").arg(strImageFilePath);
                ui->labelStatus->setText(strResult);
            }
            else
                ui->labelStatus->setText("Save Drawing Image : Failed ! (" + QString::number(nResult) + ")");
        }
    }
}

void MainWindow::on_ShowVersionOnDeviceButton_clicked()
{
    if(m_pfn_PPL398_DisplayHWVersion && m_pfn_PPL500_DisplayHWVersion && m_pfn_PPL501F_DisplayHWVersion)
    {
        int nResult = ARI_FAIL;

        if(m_nSelectedDeviceID == PPL398_DEVICE)
            nResult = m_pfn_PPL398_DisplayHWVersion(PPL398_DEVICE, m_bShowHWVersion);
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_DisplayHWVersion(PPL500_DEVICE, m_bShowHWVersion);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_DisplayHWVersion(PPL501F_DEVICE, m_bShowHWVersion);
        }

        if(nResult == ARI_SUCCESS)
        {
            if(m_bShowHWVersion)
                ui->labelStatus->setText("Show Version On Device : succeeded.");
            else
                ui->labelStatus->setText("Hide Version On Device : succeeded.");
        }

        m_bShowHWVersion = !m_bShowHWVersion;
    }
}

void MainWindow::on_cbPenStyle_currentIndexChanged(int index)
{
    if(m_pfn_PPL398_SetPenStyle && m_pfn_PPL500_SetPenStyle && m_pfn_PPL501F_SetPenStyle &&
       m_pfn_PPLC700_SetPenStyle && m_pfn_PPE640_SetPenStyle)
    {
        bool bPressureOn;
        if(index == 0)
            bPressureOn = true;
        else
            bPressureOn = false;

        int nResult = ARI_FAIL;
        if(m_nSelectedDeviceID == PPL398_DEVICE)
            nResult = m_pfn_PPL398_SetPenStyle(PPL398_DEVICE, bPressureOn);
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_SetPenStyle(PPL500_DEVICE, bPressureOn);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_SetPenStyle(PPL501F_DEVICE, bPressureOn);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            nResult = m_pfn_PPLC700_SetPenStyle(PPLC700_DEVICE, bPressureOn);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            nResult = m_pfn_PPE640_SetPenStyle(PPE640_DEVICE, bPressureOn);
        }

        if(nResult == ARI_SUCCESS)
        {
            if(bPressureOn)
                ui->labelStatus->setText("Set Pen Style with [Pressure sensitivity]");
            else
                ui->labelStatus->setText("Set Pen Style with [Fixed width]");
        }
    }
}

void MainWindow::on_cbSelectDevice_currentIndexChanged(int index)
{
    switch (index)
    {
        case 0:
        case 1:
            m_nSelectedDeviceID = PPL398_DEVICE;
            break;

        case 2:
            m_nSelectedDeviceID = PPL500_DEVICE;
            break;

        case 3:
            m_nSelectedDeviceID = PPL501F_DEVICE;
            break;

        case 4:
            m_nSelectedDeviceID = PPLC700_DEVICE;
            break;

        case 5:
            m_nSelectedDeviceID = PPE640_DEVICE;
            break;
    }
}

void MainWindow::on_cbPenColor_currentIndexChanged(int index)
{
    if(m_pfn_PPL398_SetPenColor && m_pfn_PPL500_SetPenColor && m_pfn_PPL501F_SetPenColor &&
       m_pfn_PPLC700_SetPenColor && m_pfn_PPE640_SetPenColor)
    {
        int nResult = ARI_FAIL;
        int nR = 0, nG = 0, nB = 0;
        QString strSelectedColor = "";

        switch (index)
        {
            case 0: // black color...
                {
                    nR = nG = nB = 0;
                    strSelectedColor = "Black Color";
                }
                break;

            case 1: // red color...
                {
                    nR = 255;
                    nG = nB = 0;
                    strSelectedColor = "Red Color";
                }
                break;

            case 2: // green color...
                {
                    nG = 255;
                    nR = nB = 0;
                    strSelectedColor = "Green Color";
                }
                break;

            case 3: // blue color...
                {
                    nB = 255;
                    nR = nG = 0;
                    strSelectedColor = "Blue Color";
                }
                break;

            case 4: // yellow color...
                {
                    nR = nG = 255;
                    nB = 0;
                    strSelectedColor = "Yellow Color";
                }
                break;
        }
        if(m_nSelectedDeviceID == PPL398_DEVICE)
        {
            nResult = m_pfn_PPL398_SetPenColor(PPL398_DEVICE, nR, nG, nB);
        }
        else if(m_nSelectedDeviceID == PPL500_DEVICE)
        {
            nResult = m_pfn_PPL500_SetPenColor(PPL500_DEVICE, nR, nG, nB);
        }
        else if(m_nSelectedDeviceID == PPL501F_DEVICE)
        {
            nResult = m_pfn_PPL501F_SetPenColor(PPL501F_DEVICE, nR, nG, nB);
        }
        else if(m_nSelectedDeviceID == PPLC700_DEVICE)
        {
            nResult = m_pfn_PPLC700_SetPenColor(PPLC700_DEVICE, nR, nG, nB);
        }
        else if(m_nSelectedDeviceID == PPE640_DEVICE)
        {
            nResult = m_pfn_PPE640_SetPenColor(PPE640_DEVICE, nR, nG, nB);
        }

        if(nResult == ARI_SUCCESS)
        {
            ui->labelStatus->setText("Set Pen Color : " + strSelectedColor);
        }
    }
}
