import sys
from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.QtGui import QIntValidator
from PyQt5.QtWidgets import QDesktopWidget, QMessageBox
import sip
from structdefs import *
from PPL398APIDefs import *
from PPL500APIDefs import *
from PPL501FAPIDefs import *
from PPLC700APIDefs import *
from PPE640APIDefs import *

global g_UiMainWndInstance
g_UiMainWndInstance = None

def CB_SignPadEventCallback(nStatus):
	print('CB_SignPadEventCallback(), nStatus = {0}'.format(nStatus))

	if g_UiMainWndInstance != None:
		g_UiMainWndInstance.ProcessSignPadEvent(nStatus)
	return

class MyMainWindow(QtWidgets.QMainWindow):
	def closeEvent(self, event):
		print('MyMainWindow::closeEvent() m_nSelectedDeviceID = {0}'.format(self.m_nSelectedDeviceID))
		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			PPL398_UnInitialDevice(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			PPL500_UnInitialDevice(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			PPL501F_UnInitialDevice(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			PPLC700_UnInitialDevice(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			PPE640_UnInitialDevice(self.m_nSelectedDeviceID)

	def updateSelectedDeviceID(self, id):
		print('MyMainWindow::updateSelectedDeviceID() id = {0}'.format(id))
		self.m_nSelectedDeviceID = id

class Ui_MainWindow(object):
	def setupUi(self, MainWindow):
		MainWindow.setObjectName("MainWindow")
		MainWindow.resize(1109, 736)
		self.MainWindow = MainWindow
		self.MainWndWidth = MainWindow.width()
		self.MainWndHeight = MainWindow.height()
		self.centralWidget = QtWidgets.QWidget(MainWindow)
		self.centralWidget.setObjectName("centralWidget")
		self.OpenLCDButton = QtWidgets.QPushButton(self.centralWidget)
		self.OpenLCDButton.setGeometry(QtCore.QRect(490, 450, 111, 30))
		self.OpenLCDButton.setObjectName("OpenLCDButton")
		self.ClearButton = QtWidgets.QPushButton(self.centralWidget)
		self.ClearButton.setGeometry(QtCore.QRect(10, 490, 111, 30))
		self.ClearButton.setObjectName("ClearButton")
		self.PadIDButton = QtWidgets.QPushButton(self.centralWidget)
		self.PadIDButton.setGeometry(QtCore.QRect(610, 490, 111, 30))
		self.PadIDButton.setObjectName("PadIDButton")
		self.InitButton = QtWidgets.QPushButton(self.centralWidget)
		self.InitButton.setGeometry(QtCore.QRect(250, 450, 111, 30))
		self.InitButton.setObjectName("InitButton")
		self.CloseLCDButton = QtWidgets.QPushButton(self.centralWidget)
		self.CloseLCDButton.setGeometry(QtCore.QRect(610, 450, 111, 30))
		self.CloseLCDButton.setObjectName("CloseLCDButton")
		self.PenIDButton = QtWidgets.QPushButton(self.centralWidget)
		self.PenIDButton.setGeometry(QtCore.QRect(490, 490, 111, 30))
		self.PenIDButton.setObjectName("PenIDButton")
		self.ShowVersionOnDeviceButton = QtWidgets.QPushButton(self.centralWidget)
		self.ShowVersionOnDeviceButton.setGeometry(QtCore.QRect(610, 530, 171, 31))
		self.ShowVersionOnDeviceButton.setObjectName("ShowVersionOnDeviceButton")
		self.UnInitButton = QtWidgets.QPushButton(self.centralWidget)
		self.UnInitButton.setGeometry(QtCore.QRect(370, 450, 111, 30))
		self.UnInitButton.setObjectName("UnInitButton")
		self.HWVersionButton = QtWidgets.QPushButton(self.centralWidget)
		self.HWVersionButton.setGeometry(QtCore.QRect(490, 530, 111, 30))
		self.HWVersionButton.setObjectName("HWVersionButton")
		self.labelStatus = QtWidgets.QLabel(self.centralWidget)
		self.labelStatus.setGeometry(QtCore.QRect(10, 690, 711, 21))
		self.labelStatus.setText("")
		self.labelStatus.setAlignment(QtCore.Qt.AlignCenter)
		self.labelStatus.setObjectName("labelStatus")
		self.cbPenWidth = QtWidgets.QComboBox(self.centralWidget)
		self.cbPenWidth.setGeometry(QtCore.QRect(380, 570, 101, 30))
		self.cbPenWidth.setMaxCount(10)
		self.cbPenWidth.setObjectName("cbPenWidth")
		self.label = QtWidgets.QLabel(self.centralWidget)
		self.label.setGeometry(QtCore.QRect(10, 450, 101, 31))
		self.label.setObjectName("label")
		self.cbSelectDevice = QtWidgets.QComboBox(self.centralWidget)
		self.cbSelectDevice.setGeometry(QtCore.QRect(118, 450, 121, 31))
		self.cbSelectDevice.setMaxCount(10)
		self.cbSelectDevice.setObjectName("cbSelectDevice")
		self.label_2 = QtWidgets.QLabel(self.centralWidget)
		self.label_2.setGeometry(QtCore.QRect(280, 570, 81, 31))
		self.label_2.setObjectName("label_2")
		self.cbPenStyle = QtWidgets.QComboBox(self.centralWidget)
		self.cbPenStyle.setGeometry(QtCore.QRect(88, 570, 181, 30))
		self.cbPenStyle.setMaxCount(10)
		self.cbPenStyle.setObjectName("cbPenStyle")
		self.label_3 = QtWidgets.QLabel(self.centralWidget)
		self.label_3.setGeometry(QtCore.QRect(10, 570, 81, 31))
		self.label_3.setObjectName("label_3")
		self.GetSizeButton = QtWidgets.QPushButton(self.centralWidget)
		self.GetSizeButton.setGeometry(QtCore.QRect(130, 490, 101, 30))
		self.GetSizeButton.setObjectName("GetSizeButton")
		self.GetPointButton = QtWidgets.QPushButton(self.centralWidget)
		self.GetPointButton.setGeometry(QtCore.QRect(250, 490, 111, 30))
		self.GetPointButton.setObjectName("GetPointButton")
		self.cbGetPoint = QtWidgets.QComboBox(self.centralWidget)
		self.cbGetPoint.setGeometry(QtCore.QRect(370, 490, 111, 30))
		self.cbGetPoint.setMaxCount(10000)
		self.cbGetPoint.setObjectName("cbGetPoint")
		self.cbEncode = QtWidgets.QComboBox(self.centralWidget)
		self.cbEncode.setGeometry(QtCore.QRect(130, 530, 101, 30))
		self.cbEncode.setMaxCount(10)
		self.cbEncode.setObjectName("cbEncode")
		self.EncodeButton = QtWidgets.QPushButton(self.centralWidget)
		self.EncodeButton.setGeometry(QtCore.QRect(10, 530, 111, 30))
		self.EncodeButton.setObjectName("EncodeButton")
		self.DecodeButton = QtWidgets.QPushButton(self.centralWidget)
		self.DecodeButton.setGeometry(QtCore.QRect(250, 530, 111, 30))
		self.DecodeButton.setObjectName("DecodeButton")
		self.AboutButton = QtWidgets.QPushButton(self.centralWidget)
		self.AboutButton.setGeometry(QtCore.QRect(370, 530, 111, 30))
		self.AboutButton.setObjectName("AboutButton")
		self.GetDeviceInfoButton = QtWidgets.QPushButton(self.centralWidget)
		self.GetDeviceInfoButton.setGeometry(QtCore.QRect(10, 610, 131, 30))
		self.GetDeviceInfoButton.setObjectName("GetDeviceInfoButton")
		self.cbGetDeviceInfo = QtWidgets.QComboBox(self.centralWidget)
		self.cbGetDeviceInfo.setGeometry(QtCore.QRect(150, 610, 81, 30))
		self.cbGetDeviceInfo.setMaxCount(10)
		self.cbGetDeviceInfo.setObjectName("cbGetDeviceInfo")
		self.SetClipMarginButton = QtWidgets.QPushButton(self.centralWidget)
		self.SetClipMarginButton.setGeometry(QtCore.QRect(250, 610, 111, 30))
		self.SetClipMarginButton.setObjectName("SetClipMarginButton")
		self.lineEdit_SetClipMarginWidth = QtWidgets.QLineEdit(self.centralWidget)
		self.lineEdit_SetClipMarginWidth.setGeometry(QtCore.QRect(380, 610, 51, 30))
		self.lineEdit_SetClipMarginWidth.setObjectName("lineEdit_SetClipMarginWidth")
		self.lineEdit_SetClipMarginHeight = QtWidgets.QLineEdit(self.centralWidget)
		self.lineEdit_SetClipMarginHeight.setGeometry(QtCore.QRect(440, 610, 51, 30))
		self.lineEdit_SetClipMarginHeight.setObjectName("lineEdit_SetClipMarginHeight")
		self.SaveDrawingImageButton = QtWidgets.QPushButton(self.centralWidget)
		self.SaveDrawingImageButton.setGeometry(QtCore.QRect(10, 640, 131, 30))
		self.SaveDrawingImageButton.setObjectName("SaveDrawingImageButton")
		self.cbSaveDrawingImage = QtWidgets.QComboBox(self.centralWidget)
		self.cbSaveDrawingImage.setGeometry(QtCore.QRect(150, 640, 81, 30))
		self.cbSaveDrawingImage.setMaxCount(10)
		self.cbSaveDrawingImage.setObjectName("cbSaveDrawingImage")
		self.groupBox = QtWidgets.QGroupBox(self.centralWidget)
		self.groupBox.setGeometry(QtCore.QRect(800, 450, 291, 271))
		self.groupBox.setAlignment(QtCore.Qt.AlignCenter)
		self.groupBox.setObjectName("groupBox")
		self.plainTextEdit_EncodeDecodeData = QtWidgets.QPlainTextEdit(self.groupBox)
		self.plainTextEdit_EncodeDecodeData.setGeometry(QtCore.QRect(10, 40, 271, 221))
		self.plainTextEdit_EncodeDecodeData.setObjectName("plainTextEdit_EncodeDecodeData")
		self.cbSaveDrawingImageDPI = QtWidgets.QComboBox(self.centralWidget)
		self.cbSaveDrawingImageDPI.setGeometry(QtCore.QRect(250, 640, 111, 30))
		self.cbSaveDrawingImageDPI.setMaxCount(10)
		self.cbSaveDrawingImageDPI.setObjectName("cbSaveDrawingImageDPI")
		self.label_4 = QtWidgets.QLabel(self.centralWidget)
		self.label_4.setGeometry(QtCore.QRect(490, 570, 81, 31))
		self.label_4.setObjectName("label_4")
		self.cbPenColor = QtWidgets.QComboBox(self.centralWidget)
		self.cbPenColor.setGeometry(QtCore.QRect(590, 570, 101, 30))
		self.cbPenColor.setMaxCount(10)
		self.cbPenColor.setObjectName("cbPenColor")
		MainWindow.setCentralWidget(self.centralWidget)

		self.retranslateUi(MainWindow)
		self.cbPenWidth.setCurrentIndex(-1)
		self.cbSelectDevice.setCurrentIndex(-1)
		self.cbPenStyle.setCurrentIndex(-1)
		self.cbGetPoint.setCurrentIndex(-1)
		self.cbEncode.setCurrentIndex(-1)
		self.cbGetDeviceInfo.setCurrentIndex(-1)
		self.cbSaveDrawingImage.setCurrentIndex(-1)
		self.cbSaveDrawingImageDPI.setCurrentIndex(-1)
		self.cbPenColor.setCurrentIndex(-1)
		QtCore.QMetaObject.connectSlotsByName(MainWindow)
		MainWindow.setTabOrder(self.cbSelectDevice, self.InitButton)
		MainWindow.setTabOrder(self.InitButton, self.UnInitButton)
		MainWindow.setTabOrder(self.UnInitButton, self.OpenLCDButton)
		MainWindow.setTabOrder(self.OpenLCDButton, self.CloseLCDButton)
		MainWindow.setTabOrder(self.CloseLCDButton, self.ClearButton)
		MainWindow.setTabOrder(self.ClearButton, self.GetSizeButton)
		MainWindow.setTabOrder(self.GetSizeButton, self.GetPointButton)
		MainWindow.setTabOrder(self.GetPointButton, self.cbGetPoint)
		MainWindow.setTabOrder(self.cbGetPoint, self.PenIDButton)
		MainWindow.setTabOrder(self.PenIDButton, self.PadIDButton)
		MainWindow.setTabOrder(self.PadIDButton, self.EncodeButton)
		MainWindow.setTabOrder(self.EncodeButton, self.cbEncode)
		MainWindow.setTabOrder(self.cbEncode, self.DecodeButton)
		MainWindow.setTabOrder(self.DecodeButton, self.AboutButton)
		MainWindow.setTabOrder(self.AboutButton, self.HWVersionButton)
		MainWindow.setTabOrder(self.HWVersionButton, self.ShowVersionOnDeviceButton)
		MainWindow.setTabOrder(self.ShowVersionOnDeviceButton, self.cbPenStyle)
		MainWindow.setTabOrder(self.cbPenStyle, self.cbPenWidth)
		MainWindow.setTabOrder(self.cbPenWidth, self.GetDeviceInfoButton)
		MainWindow.setTabOrder(self.GetDeviceInfoButton, self.cbGetDeviceInfo)
		MainWindow.setTabOrder(self.cbGetDeviceInfo, self.SetClipMarginButton)
		MainWindow.setTabOrder(self.SetClipMarginButton, self.lineEdit_SetClipMarginWidth)
		MainWindow.setTabOrder(self.lineEdit_SetClipMarginWidth, self.lineEdit_SetClipMarginHeight)
		MainWindow.setTabOrder(self.lineEdit_SetClipMarginHeight, self.SaveDrawingImageButton)
		MainWindow.setTabOrder(self.SaveDrawingImageButton, self.cbSaveDrawingImage)
		MainWindow.setTabOrder(self.cbSaveDrawingImage, self.cbSaveDrawingImageDPI)
		MainWindow.setTabOrder(self.cbSaveDrawingImageDPI, self.plainTextEdit_EncodeDecodeData)
		self.initial(MainWindow)

	def retranslateUi(self, MainWindow):
		_translate = QtCore.QCoreApplication.translate
		MainWindow.setWindowTitle(_translate("MainWindow", "[PenPower SignPad SDK] Demo for PyQt5"))
		self.OpenLCDButton.setText(_translate("MainWindow", "Open LCD"))
		self.ClearButton.setText(_translate("MainWindow", "Clear"))
		self.PadIDButton.setText(_translate("MainWindow", "Pad ID"))
		self.InitButton.setText(_translate("MainWindow", "Init"))
		self.CloseLCDButton.setText(_translate("MainWindow", "Close LCD"))
		self.PenIDButton.setText(_translate("MainWindow", "Pen ID"))
		self.ShowVersionOnDeviceButton.setText(_translate("MainWindow", "Show Device Version"))
		self.UnInitButton.setText(_translate("MainWindow", "UnInit"))
		self.HWVersionButton.setText(_translate("MainWindow", "HW Version"))
		self.label.setText(_translate("MainWindow", "Select Device : "))
		self.label_2.setText(_translate("MainWindow", "Pen Width  : "))
		self.label_3.setText(_translate("MainWindow", "Pen Style  : "))
		self.GetSizeButton.setText(_translate("MainWindow", "Get Size"))
		self.GetPointButton.setText(_translate("MainWindow", "Get Point"))
		self.EncodeButton.setText(_translate("MainWindow", "Encode"))
		self.DecodeButton.setText(_translate("MainWindow", "Decode"))
		self.AboutButton.setText(_translate("MainWindow", "About"))
		self.GetDeviceInfoButton.setText(_translate("MainWindow", "Get Device Info"))
		self.SetClipMarginButton.setText(_translate("MainWindow", "Crop Margin"))
		self.SaveDrawingImageButton.setText(_translate("MainWindow", "Save Image"))
		self.groupBox.setTitle(_translate("MainWindow", "Encode/Decode Data"))
		self.label_4.setText(_translate("MainWindow", "Pen Color : "))

	def onCBSelectDeviceIndexChanged(self, index):
		print('onCBSelectDeviceIndexChanged() enter, selected index: {0}, selected text: {1}'.format(index, self.cbSelectDevice.currentText()))
		if (index == 0) or (index == 1):
			self.m_nSelectedDeviceID = DEVICE_TYPE_ID.PPL398_DEVICE.value
		elif index == 2:
			self.m_nSelectedDeviceID = DEVICE_TYPE_ID.PPL500_DEVICE.value
		elif index == 3:
			self.m_nSelectedDeviceID = DEVICE_TYPE_ID.PPL501F_DEVICE.value
		elif index == 4:
			self.m_nSelectedDeviceID = DEVICE_TYPE_ID.PPLC700_DEVICE.value
		elif index == 5:
			self.m_nSelectedDeviceID = DEVICE_TYPE_ID.PPE640_DEVICE.value

		# update selected device id...
		self.MainWindow.updateSelectedDeviceID(self.m_nSelectedDeviceID)

	def onCBPenStyleIndexChanged(self, index):
		print('onCBPenStyleIndexChanged() enter, selected index: {0}, selected text: {1}'.format(index, self.cbPenStyle.currentText()))
		nResult = ERROR_ID.RET_PST_FAIL.value
		bPressureOn = False
		if index == 0:
			bPressureOn = True

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_SetPenStyle(self.m_nSelectedDeviceID, bPressureOn)
			print('onCBPenStyleIndexChanged(), after call PPL398_SetPenStyle(...{0}...), nResult={1}'.format(bPressureOn, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_SetPenStyle(self.m_nSelectedDeviceID, bPressureOn)
			print('onCBPenStyleIndexChanged(), after call PPL500_SetPenStyle(...{0}...), nResult={1}'.format(bPressureOn, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_SetPenStyle(self.m_nSelectedDeviceID, bPressureOn)
			print('onCBPenStyleIndexChanged(), after call PPL501F_SetPenStyle(...{0}...), nResult={1}'.format(bPressureOn, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			nResult = PPLC700_SetPenStyle(self.m_nSelectedDeviceID, bPressureOn)
			print('onCBPenStyleIndexChanged(), after call PPLC700_SetPenStyle(...{0}...), nResult={1}'.format(bPressureOn, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			nResult = PPE640_SetPenStyle(self.m_nSelectedDeviceID, bPressureOn)
			print('onCBPenStyleIndexChanged(), after call PPE640_SetPenStyle(...{0}...), nResult={1}'.format(bPressureOn, nResult))

		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			if bPressureOn == True:
				self.labelStatus.setText("Set Pen Style with [Pressure sensitivity]")
			else:
				self.labelStatus.setText("Set Pen Style with [Fixed width]")

	def onCBPenWidthIndexChanged(self, index):
		print('onCBPenWidthIndexChanged() enter, selected index: {0}, selected text: {1}'.format(index, self.cbPenWidth.currentText()))
		nResult = ERROR_ID.RET_PST_FAIL.value

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_SetPenWidth(self.m_nSelectedDeviceID, index + 1)
			print('onCBPenWidthIndexChanged(), after call PPL398_SetPenWidth(...{0}...), nResult={1}'.format(index + 1, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_SetPenWidth(self.m_nSelectedDeviceID, index + 1)
			print('onCBPenWidthIndexChanged(), after call PPL500_SetPenWidth(...{0}...), nResult={1}'.format(index + 1, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_SetPenWidth(self.m_nSelectedDeviceID, index + 1)
			print('onCBPenWidthIndexChanged(), after call PPL501F_SetPenWidth(...{0}...), nResult={1}'.format(index + 1, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			nResult = PPLC700_SetPenWidth(self.m_nSelectedDeviceID, index + 1)
			print('onCBPenWidthIndexChanged(), after call PPLC700_SetPenWidth(...{0}...), nResult={1}'.format(index + 1, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			nResult = PPE640_SetPenWidth(self.m_nSelectedDeviceID, index + 1)
			print('onCBPenWidthIndexChanged(), after call PPE640_SetPenWidth(...{0}...), nResult={1}'.format(index + 1, nResult))

		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			self.onClearButtonClicked()
			self.labelStatus.setText("Set Pen Width : " + str(index + 1))

	def onCBPenColorIndexChanged(self, index):
		print('onCBPenColorIndexChanged() enter, selected index: {0}, selected text: {1}'.format(index, self.cbPenColor.currentText()))
		nResult = ERROR_ID.RET_PST_FAIL.value
		nR = nG = nB = 0
		strSelectedColor = ""

		if index == 0:
			nR = nG = nB = 0
			strSelectedColor = "Black Color"
		elif index == 1:
			nR = 255
			nG = nB = 0
			strSelectedColor = "Red Color"
		elif index == 2:
			nG = 255
			nR = nB = 0
			strSelectedColor = "Green Color"
		elif index == 3:
			nB = 255
			nR = nG = 0
			strSelectedColor = "Blue Color"
		elif index == 4:
			nR = nG = 255
			nB = 0
			strSelectedColor = "Yellow Color"

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_SetPenColor(self.m_nSelectedDeviceID, nR, nG, nB)
			print('onCBPenColorIndexChanged(), after call PPL398_SetPenColor(...{0},{1},{2}...), nResult={3}'.format(nR, nG, nB, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_SetPenColor(self.m_nSelectedDeviceID, nR, nG, nB)
			print('onCBPenColorIndexChanged(), after call PPL500_SetPenColor(...{0},{1},{2}...), nResult={3}'.format(nR, nG, nB, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_SetPenColor(self.m_nSelectedDeviceID, nR, nG, nB)
			print('onCBPenColorIndexChanged(), after call PPL501F_SetPenColor(...{0},{1},{2}...), nResult={3}'.format(nR, nG, nB, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			nResult = PPLC700_SetPenColor(self.m_nSelectedDeviceID, nR, nG, nB)
			print('onCBPenColorIndexChanged(), after call PPLC700_SetPenColor(...{0},{1},{2}...), nResult={3}'.format(nR, nG, nB, nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			nResult = PPE640_SetPenColor(self.m_nSelectedDeviceID, nR, nG, nB)
			print('onCBPenColorIndexChanged(), after call PPE640_SetPenColor(...{0},{1},{2}...), nResult={3}'.format(nR, nG, nB, nResult))

		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			self.labelStatus.setText("Set Pen Color : " + strSelectedColor)

	def onInitButtonClicked(self):
		print('onInitButtonClicked() enter... ')
		nWidth = self.MainWndWidth
		nSignPadWidth = 710
		nSignPadHeight = 430
		bRet = False
		nSignPadLeft = (nWidth - nSignPadWidth) // 2
		nSignPadTop = 10
		print('onInitButtonClicked(), nSignPadLeft = {0}, nSignPadTop = {1}'.format(nSignPadLeft, nSignPadTop))

		centralWidgetPtr = sip.unwrapinstance(self.centralWidget)
		print('centralWidgetPtr:', centralWidgetPtr)

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			bRet = PPL398_InitialDevice(self.m_nSelectedDeviceID, centralWidgetPtr, nSignPadLeft, nSignPadTop, nSignPadWidth, nSignPadHeight)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			bRet = PPL500_InitialDevice(self.m_nSelectedDeviceID, centralWidgetPtr, nSignPadLeft, nSignPadTop, nSignPadWidth, nSignPadHeight)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			bRet = PPL501F_InitialDevice(self.m_nSelectedDeviceID, centralWidgetPtr, nSignPadLeft, nSignPadTop, nSignPadWidth, nSignPadHeight)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			bRet = PPLC700_InitialDevice(self.m_nSelectedDeviceID, centralWidgetPtr, nSignPadLeft, nSignPadTop, nSignPadWidth, nSignPadHeight)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			bRet = PPE640_InitialDevice(self.m_nSelectedDeviceID, centralWidgetPtr, nSignPadLeft, nSignPadTop, nSignPadWidth, nSignPadHeight)

		print('bRet:', bRet)
		if bRet == True:
			signPadEventCB = SIGNPAD_EVENT_CALLBACK(CB_SignPadEventCallback)
			bInit = True

			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				PPL398_SignPadEventCallback(self.m_nSelectedDeviceID, signPadEventCB)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				PPL500_SignPadEventCallback(self.m_nSelectedDeviceID, signPadEventCB)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nFPImageWidth = 145
				nFPImageHeight = 201
				nX = (nSignPadWidth - nFPImageWidth) // 2
				nY = (nSignPadHeight - nFPImageHeight) // 2
				print('onInitButtonClicked(), nX={0}, nY={1}, nFPImageWidth={2}, nFPImageHeight={3}'.format(nX, nY, nFPImageWidth, nFPImageHeight))
				nResult = PPL501F_SetDisplayedFPImageAt(self.m_nSelectedDeviceID, centralWidgetPtr, 0, 0, nX, nY, nFPImageWidth, nFPImageHeight)
				print('onInitButtonClicked(), after call PPL501F_SetDisplayedFPImageAt(), nResult={0}'.format(nResult))

				if nResult == ERROR_ID.RET_PST_SUCCESS.value:
					PPL501F_SignPadEventCallback(self.m_nSelectedDeviceID, signPadEventCB)
				else:
					self.labelStatus.setText("PPL501F_SetDisplayedFPImageAt() Failed  ! (" + str(nResult) + ")")
					bInit = False
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				PPLC700_SignPadEventCallback(self.m_nSelectedDeviceID, signPadEventCB)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				PPE640_SignPadEventCallback(self.m_nSelectedDeviceID, signPadEventCB)

			self.label.setEnabled(False)
			self.cbSelectDevice.setEnabled(False)
			self.InitButton.setEnabled(False)
			self.UnInitButton.setEnabled(True)

			if (self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value) or (self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value):
				pass
			else:
				self.OpenLCDButton.setEnabled(True)
				self.CloseLCDButton.setEnabled(True)
				self.PenIDButton.setEnabled(True)
				self.ShowVersionOnDeviceButton.setEnabled(True)

			self.ClearButton.setEnabled(True)
			self.GetSizeButton.setEnabled(True)
			self.GetPointButton.setEnabled(True)
			self.cbGetPoint.setEnabled(True)
			self.PadIDButton.setEnabled(True)
			self.EncodeButton.setEnabled(True)
			self.cbEncode.setEnabled(True)
			self.DecodeButton.setEnabled(True)
			self.AboutButton.setEnabled(True)
			self.HWVersionButton.setEnabled(True)
			self.cbPenStyle.setEnabled(True)
			self.cbPenWidth.setEnabled(True)
			self.GetDeviceInfoButton.setEnabled(True)
			self.cbGetDeviceInfo.setEnabled(True)
			self.SetClipMarginButton.setEnabled(True)
			self.lineEdit_SetClipMarginWidth.setEnabled(True)
			self.lineEdit_SetClipMarginHeight.setEnabled(True)
			self.SaveDrawingImageButton.setEnabled(True)
			self.cbSaveDrawingImage.setEnabled(True)
			self.cbSaveDrawingImageDPI.setEnabled(True)
			self.label_2.setEnabled(True)
			self.label_3.setEnabled(True)
			self.label_4.setEnabled(True)
			self.groupBox.setEnabled(True)
			self.plainTextEdit_EncodeDecodeData.setEnabled(True)
			self.lineEdit_SetClipMarginWidth.setText("0")
			self.lineEdit_SetClipMarginHeight.setText("0")
			self.cbPenColor.setEnabled(True)

			if bInit == True:
				self.labelStatus.setText("You may start signing now.")
			else:
				pass
		else:
			QMessageBox.warning(self.centralWidget, "Warning Box", "Device not found!")
		
	def onUnInitButtonClicked(self):
		print('onUnInitButtonClicked() enter... ')
		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			PPL398_UnInitialDevice(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			PPL500_UnInitialDevice(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			PPL501F_UnInitialDevice(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			PPLC700_UnInitialDevice(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			PPE640_UnInitialDevice(self.m_nSelectedDeviceID)

		self.label.setEnabled(True)
		self.cbSelectDevice.setEnabled(True)
		self.InitButton.setEnabled(True)
		self.UnInitButton.setEnabled(False)
		self.OpenLCDButton.setEnabled(False)
		self.CloseLCDButton.setEnabled(False)
		self.ClearButton.setEnabled(False)
		self.GetSizeButton.setEnabled(False)
		self.GetPointButton.setEnabled(False)
		self.cbGetPoint.setEnabled(False)
		self.PenIDButton.setEnabled(False)
		self.PadIDButton.setEnabled(False)
		self.EncodeButton.setEnabled(False)
		self.cbEncode.setEnabled(False)
		self.DecodeButton.setEnabled(False)
		self.AboutButton.setEnabled(False)
		self.HWVersionButton.setEnabled(False)
		self.ShowVersionOnDeviceButton.setEnabled(False)
		self.cbPenStyle.setEnabled(False)
		self.cbPenStyle.setCurrentIndex(0)
		self.cbPenWidth.setEnabled(False)
		self.cbPenWidth.setCurrentIndex(2)
		self.GetDeviceInfoButton.setEnabled(False)
		self.cbGetDeviceInfo.setEnabled(False)
		self.SetClipMarginButton.setEnabled(False)
		self.lineEdit_SetClipMarginWidth.setEnabled(False)
		self.lineEdit_SetClipMarginHeight.setEnabled(False)
		self.SaveDrawingImageButton.setEnabled(False)
		self.cbSaveDrawingImage.setEnabled(False)
		self.cbSaveDrawingImageDPI.setEnabled(False)
		self.label_2.setEnabled(False)
		self.label_3.setEnabled(False)
		self.groupBox.setEnabled(False)
		self.plainTextEdit_EncodeDecodeData.setEnabled(False)
		self.plainTextEdit_EncodeDecodeData.setPlainText("")
		self.label_4.setEnabled(False)
		self.cbPenColor.setEnabled(False)
		self.cbPenColor.setCurrentIndex(0)
		self.labelStatus.setText("Please select device and click [Init] button to initial sign pad.")

	def onOpenLCDButtonClicked(self):
		print('onOpenLCDButtonClicked() enter... ')
		nResult = ERROR_ID.RET_PST_FAIL.value

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_OpenLCD(self.m_nSelectedDeviceID, True)
			print('onOpenLCDButtonClicked(), after call PPL398_OpenLCD(...True...), nResult={0}'.format(nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_OpenLCD(self.m_nSelectedDeviceID, True)
			print('onCloseLCDButtonClicked(), after call PPL500_OpenLCD(...True...), nResult={0}'.format(nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_OpenLCD(self.m_nSelectedDeviceID, True)
			print('onCloseLCDButtonClicked(), after call PPL501F_OpenLCD(...True...), nResult={0}'.format(nResult))

		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			self.labelStatus.setText("Open LCD : succeeded.")

	def onCloseLCDButtonClicked(self):
		print('onCloseLCDButtonClicked() enter... ')
		nResult = ERROR_ID.RET_PST_FAIL.value

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_OpenLCD(self.m_nSelectedDeviceID, False)
			print('onCloseLCDButtonClicked(), after call PPL398_OpenLCD(...False...), nResult={0}'.format(nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_OpenLCD(self.m_nSelectedDeviceID, False)
			print('onCloseLCDButtonClicked(), after call PPL500_OpenLCD(...False...), nResult={0}'.format(nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_OpenLCD(self.m_nSelectedDeviceID, False)
			print('onCloseLCDButtonClicked(), after call PPL501F_OpenLCD(...False...), nResult={0}'.format(nResult))

		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			self.labelStatus.setText("Close LCD : succeeded.")

	def onClearButtonClicked(self):
		print('onClearButtonClicked() enter... ')
		nResult = ERROR_ID.RET_PST_FAIL.value
				
		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_Clear(self.m_nSelectedDeviceID)
			print('onClearButtonClicked(), after call PPL398_Clear(), nResult={0}'.format(nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_Clear(self.m_nSelectedDeviceID)
			print('onClearButtonClicked(), after call PPL500_Clear(), nResult={0}'.format(nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_Clear(self.m_nSelectedDeviceID)
			print('onClearButtonClicked(), after call PPL501F_Clear(), nResult={0}'.format(nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			nResult = PPLC700_Clear(self.m_nSelectedDeviceID)
			print('onClearButtonClicked(), after call PPLC700_Clear(), nResult={0}'.format(nResult))
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			nResult = PPE640_Clear(self.m_nSelectedDeviceID)
			print('onClearButtonClicked(), after call PPE640_Clear(), nResult={0}'.format(nResult))
			
		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			self.labelStatus.setText("Clear : succeeded.")
			# clear GetPoint combobox...
			self.cbGetPoint.clear()
			# clear Set Clip Margin line edit...
			self.lineEdit_SetClipMarginWidth.setText("0")
			self.lineEdit_SetClipMarginHeight.setText("0")
			# clear Encode/Decode Data...
			self.plainTextEdit_EncodeDecodeData.setPlainText("")

	def onGetSizeButtonClicked(self):
		print('onGetSizeButtonClicked() enter... ')
		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nInkCount = PPL398_GetTotalInkPointsNumber(self.m_nSelectedDeviceID)
			self.labelStatus.setText("point count of signing : " + str(nInkCount))
			# clear GetPoint combobox...
			self.cbGetPoint.clear()
			# update GetPoint combobox...
			for i in range(nInkCount):
				self.cbGetPoint.addItem(str(i))

		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nInkCount = PPL500_GetTotalInkPointsNumber(self.m_nSelectedDeviceID)
			self.labelStatus.setText("point count of signing : " + str(nInkCount))
			# clear GetPoint combobox...
			self.cbGetPoint.clear()
			# update GetPoint combobox...
			for i in range(nInkCount):
				self.cbGetPoint.addItem(str(i))

		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nInkCount = PPL501F_GetTotalInkPointsNumber(self.m_nSelectedDeviceID)
			self.labelStatus.setText("point count of signing : " + str(nInkCount))
			# clear GetPoint combobox...
			self.cbGetPoint.clear()
			# update GetPoint combobox...
			for i in range(nInkCount):
				self.cbGetPoint.addItem(str(i))

		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			nInkCount = PPLC700_GetTotalInkPointsNumber(self.m_nSelectedDeviceID)
			self.labelStatus.setText("point count of signing : " + str(nInkCount))
			# clear GetPoint combobox...
			self.cbGetPoint.clear()
			# update GetPoint combobox...
			for i in range(nInkCount):
				self.cbGetPoint.addItem(str(i))

		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			nInkCount = PPE640_GetTotalInkPointsNumber(self.m_nSelectedDeviceID)
			self.labelStatus.setText("point count of signing : " + str(nInkCount))
			# clear GetPoint combobox...
			self.cbGetPoint.clear()
			# update GetPoint combobox...
			for i in range(nInkCount):
				self.cbGetPoint.addItem(str(i))

	def onGetPointButtonClicked(self):
		print('onGetPointButtonClicked() enter... ')
		nCurrentPointIndex = int(self.cbGetPoint.currentIndex())

		if nCurrentPointIndex >= 0:
			currentInkPoint = INKPOINTDATA(nCurrentPointIndex, 0, 0, 0, False)

			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_GetInkPointData(self.m_nSelectedDeviceID, currentInkPoint)
				pInkPointDataTimeInfo = PPL398_GetInkPointDataTimeInfo(self.m_nSelectedDeviceID, nCurrentPointIndex)

				if (nResult == ERROR_ID.RET_PST_SUCCESS.value) and (pInkPointDataTimeInfo != None):
					pInkPointTime = cast(pInkPointDataTimeInfo, c_char_p)
					strpInkPointTime = pInkPointTime.value
					strpInkPointTime = strpInkPointTime.decode()

					strPointInfo = "index={0}, X={1}, Y={2}, Pressure={3}, time={4}, strokeEnd={5}".format(
									currentInkPoint.btn, currentInkPoint.X, currentInkPoint.Y, currentInkPoint.Press,
									strpInkPointTime, currentInkPoint.bStrokeEnd)
					self.labelStatus.setText(strPointInfo)
					PPL398_FreeInkPointDataTimeInfo(self.m_nSelectedDeviceID, pInkPointDataTimeInfo)

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_GetInkPointData(self.m_nSelectedDeviceID, currentInkPoint)
				pInkPointDataTimeInfo = PPL500_GetInkPointDataTimeInfo(self.m_nSelectedDeviceID, nCurrentPointIndex)

				if (nResult == ERROR_ID.RET_PST_SUCCESS.value) and (pInkPointDataTimeInfo != None):
					pInkPointTime = cast(pInkPointDataTimeInfo, c_char_p)
					strpInkPointTime = pInkPointTime.value
					strpInkPointTime = strpInkPointTime.decode()

					strPointInfo = "index={0}, X={1}, Y={2}, Pressure={3}, time={4}, strokeEnd={5}".format(
									currentInkPoint.btn, currentInkPoint.X, currentInkPoint.Y, currentInkPoint.Press,
									strpInkPointTime, currentInkPoint.bStrokeEnd)
					self.labelStatus.setText(strPointInfo)
					PPL500_FreeInkPointDataTimeInfo(self.m_nSelectedDeviceID, pInkPointDataTimeInfo)

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_GetInkPointData(self.m_nSelectedDeviceID, currentInkPoint)
				pInkPointDataTimeInfo = PPL501F_GetInkPointDataTimeInfo(self.m_nSelectedDeviceID, nCurrentPointIndex)

				if (nResult == ERROR_ID.RET_PST_SUCCESS.value) and (pInkPointDataTimeInfo != None):
					pInkPointTime = cast(pInkPointDataTimeInfo, c_char_p)
					strpInkPointTime = pInkPointTime.value
					strpInkPointTime = strpInkPointTime.decode()

					strPointInfo = "index={0}, X={1}, Y={2}, Pressure={3}, time={4}, strokeEnd={5}".format(
									currentInkPoint.btn, currentInkPoint.X, currentInkPoint.Y, currentInkPoint.Press,
									strpInkPointTime, currentInkPoint.bStrokeEnd)
					self.labelStatus.setText(strPointInfo)
					PPL501F_FreeInkPointDataTimeInfo(self.m_nSelectedDeviceID, pInkPointDataTimeInfo)

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_GetInkPointData(self.m_nSelectedDeviceID, currentInkPoint)
				pInkPointDataTimeInfo = PPLC700_GetInkPointDataTimeInfo(self.m_nSelectedDeviceID, nCurrentPointIndex)

				if (nResult == ERROR_ID.RET_PST_SUCCESS.value) and (pInkPointDataTimeInfo != None):
					pInkPointTime = cast(pInkPointDataTimeInfo, c_char_p)
					strpInkPointTime = pInkPointTime.value
					strpInkPointTime = strpInkPointTime.decode()

					strPointInfo = "index={0}, X={1}, Y={2}, Pressure={3}, time={4}, strokeEnd={5}".format(
									currentInkPoint.btn, currentInkPoint.X, currentInkPoint.Y, currentInkPoint.Press,
									strpInkPointTime, currentInkPoint.bStrokeEnd)
					self.labelStatus.setText(strPointInfo)
					PPLC700_FreeInkPointDataTimeInfo(self.m_nSelectedDeviceID, pInkPointDataTimeInfo)

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_GetInkPointData(self.m_nSelectedDeviceID, currentInkPoint)
				pInkPointDataTimeInfo = PPE640_GetInkPointDataTimeInfo(self.m_nSelectedDeviceID, nCurrentPointIndex)

				if (nResult == ERROR_ID.RET_PST_SUCCESS.value) and (pInkPointDataTimeInfo != None):
					pInkPointTime = cast(pInkPointDataTimeInfo, c_char_p)
					strpInkPointTime = pInkPointTime.value
					strpInkPointTime = strpInkPointTime.decode()

					strPointInfo = "index={0}, X={1}, Y={2}, Pressure={3}, time={4}, strokeEnd={5}".format(
									currentInkPoint.btn, currentInkPoint.X, currentInkPoint.Y, currentInkPoint.Press,
									strpInkPointTime, currentInkPoint.bStrokeEnd)
					self.labelStatus.setText(strPointInfo)
					PPE640_FreeInkPointDataTimeInfo(self.m_nSelectedDeviceID, pInkPointDataTimeInfo)

	def onPenIDButtonClicked(self):
		print('onPenIDButtonClicked() enter... ')
		strHWPenID = c_buffer(RX_DEVICE_DATA_MAX_SIZE)  # ansi buffer...
		nResult = ERROR_ID.RET_PST_FAIL.value

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_GetHWPenID(self.m_nSelectedDeviceID, strHWPenID, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_GetHWPenID(self.m_nSelectedDeviceID, strHWPenID, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_GetHWPenID(self.m_nSelectedDeviceID, strHWPenID, RX_DEVICE_DATA_MAX_SIZE)
		
		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			strHWPenIDValue = strHWPenID.value.decode('utf-8')
			print('onPenIDButtonClicked(), strHWPenIDValue=' + strHWPenIDValue)
			self.labelStatus.setText("Pen ID : " + strHWPenIDValue)

	def onPadIDButtonClicked(self):
		print('onPadIDButtonClicked() enter... ')
		strHWPadID = c_buffer(RX_DEVICE_DATA_MAX_SIZE)  # ansi buffer...
		nResult = ERROR_ID.RET_PST_FAIL.value

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_GetHWPadID(self.m_nSelectedDeviceID, strHWPadID, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_GetHWPadID(self.m_nSelectedDeviceID, strHWPadID, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_GetHWPadID(self.m_nSelectedDeviceID, strHWPadID, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			nResult = PPLC700_GetHWPadID(self.m_nSelectedDeviceID, strHWPadID, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			nResult = PPE640_GetHWPadID(self.m_nSelectedDeviceID, strHWPadID, RX_DEVICE_DATA_MAX_SIZE)
		
		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			strHWPadIDValue = strHWPadID.value.decode('utf-8')
			print('onPadIDButtonClicked(), strHWPadIDValue=' + strHWPadIDValue)
			self.labelStatus.setText("Pad ID : " + strHWPadIDValue)

	def onEncodeButtonClicked(self):
		print('onEncodeButtonClicked() enter... ')
		nIndex = self.cbEncode.currentIndex()
		if nIndex >= 0:
			nIndex += 1
			if nIndex == 4:
				nIndex += 2

			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				pEncodeBase64Image = PPL398_Base64Encode(self.m_nSelectedDeviceID, nIndex)

				if pEncodeBase64Image != None:
					pEncodeBase64Data = cast(pEncodeBase64Image, c_char_p)
					strEncodeBase64Data = pEncodeBase64Data.value
					self.plainTextEdit_EncodeDecodeData.setPlainText(strEncodeBase64Data)
					PPL398_Base64EncodeFree(self.m_nSelectedDeviceID, pEncodeBase64Image)
					self.labelStatus.setText("Encode Base64 Image : succeeded.")
				else:
					self.labelStatus.setText("Encode Base64 Image : Failed !")

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				pEncodeBase64Image = PPL500_Base64Encode(self.m_nSelectedDeviceID, nIndex)

				if pEncodeBase64Image != None:
					pEncodeBase64Data = cast(pEncodeBase64Image, c_char_p)
					strEncodeBase64Data = pEncodeBase64Data.value
					self.plainTextEdit_EncodeDecodeData.setPlainText(strEncodeBase64Data)
					PPL500_Base64EncodeFree(self.m_nSelectedDeviceID, pEncodeBase64Image)
					self.labelStatus.setText("Encode Base64 Image : succeeded.")
				else:
					self.labelStatus.setText("Encode Base64 Image : Failed !")

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				pEncodeBase64Image = PPL501F_Base64Encode(self.m_nSelectedDeviceID, nIndex)

				if pEncodeBase64Image != None:
					pEncodeBase64Data = cast(pEncodeBase64Image, c_char_p)
					strEncodeBase64Data = pEncodeBase64Data.value
					self.plainTextEdit_EncodeDecodeData.setPlainText(strEncodeBase64Data)
					PPL501F_Base64EncodeFree(self.m_nSelectedDeviceID, pEncodeBase64Image)
					self.labelStatus.setText("Encode Base64 Image : succeeded.")
				else:
					self.labelStatus.setText("Encode Base64 Image : Failed !")

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				pEncodeBase64Image = PPLC700_Base64Encode(self.m_nSelectedDeviceID, nIndex)

				if pEncodeBase64Image != None:
					pEncodeBase64Data = cast(pEncodeBase64Image, c_char_p)
					strEncodeBase64Data = pEncodeBase64Data.value
					self.plainTextEdit_EncodeDecodeData.setPlainText(strEncodeBase64Data)
					PPLC700_Base64EncodeFree(self.m_nSelectedDeviceID, pEncodeBase64Image)
					self.labelStatus.setText("Encode Base64 Image : succeeded.")
				else:
					self.labelStatus.setText("Encode Base64 Image : Failed !")

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				pEncodeBase64Image = PPE640_Base64Encode(self.m_nSelectedDeviceID, nIndex)

				if pEncodeBase64Image != None:
					pEncodeBase64Data = cast(pEncodeBase64Image, c_char_p)
					strEncodeBase64Data = pEncodeBase64Data.value
					self.plainTextEdit_EncodeDecodeData.setPlainText(strEncodeBase64Data)
					PPE640_Base64EncodeFree(self.m_nSelectedDeviceID, pEncodeBase64Image)
					self.labelStatus.setText("Encode Base64 Image : succeeded.")
				else:
					self.labelStatus.setText("Encode Base64 Image : Failed !")

	def onDecodeButtonClicked(self):
		print('onDecodeButtonClicked() enter... ')
		strEncodeBase64Data = self.plainTextEdit_EncodeDecodeData.toPlainText()
		if strEncodeBase64Data != None:
			pEncodeBase64Data = strEncodeBase64Data.encode('utf8')
			nIndex = self.cbEncode.currentIndex()
			if nIndex >= 0:
				nIndex += 1
				if nIndex == 4:
					nIndex += 2

			strTargetFilePath = ""
			if nIndex == 1:
				strTargetFilePath = "/tmp/decodeImage.bmp"
			elif nIndex == 2:
				strTargetFilePath = "/tmp/decodeImage.jpg"
			elif nIndex == 3:
				strTargetFilePath = "/tmp/decodeImage.png"
			wTargetFilePath = create_unicode_buffer(strTargetFilePath)

			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_Base64Decode(self.m_nSelectedDeviceID, nIndex, pEncodeBase64Data, wTargetFilePath)
				if nResult == ERROR_ID.RET_PST_SUCCESS.value:
					if nIndex == 6:
						nTotalDecodeInkPointsNumber = PPL398_GetTotalDecodeInkPointsNumber(self.m_nSelectedDeviceID)
						strDecodeInkPointsData = ''

						for nIndex in range(nTotalDecodeInkPointsNumber):
							X = PPL398_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 1)
							Y = PPL398_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 2)
							END = PPL398_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 3)
							strDecodeInkPointsData += "index = {0}, X = {1}, Y = {2}, End = {3}\n".format(nIndex, X, Y, END)
						
						if nTotalDecodeInkPointsNumber > 0:
							self.plainTextEdit_EncodeDecodeData.setPlainText(strDecodeInkPointsData)
							self.labelStatus.setText("Decode Ink Points Data : succeeded.")
						else:
							self.labelStatus.setText("Decode Ink Points Data : Failed ! (None of ink data !)")
					else:
						strResult = "Decode Base64 Image (at file path : {0}) : succeeded.".format(wTargetFilePath.value)
						self.labelStatus.setText(strResult)

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_Base64Decode(self.m_nSelectedDeviceID, nIndex, pEncodeBase64Data, wTargetFilePath)
				if nResult == ERROR_ID.RET_PST_SUCCESS.value:
					if nIndex == 6:
						nTotalDecodeInkPointsNumber = PPL500_GetTotalDecodeInkPointsNumber(self.m_nSelectedDeviceID)
						strDecodeInkPointsData = ''

						for nIndex in range(nTotalDecodeInkPointsNumber):
							X = PPL500_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 1)
							Y = PPL500_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 2)
							END = PPL500_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 3)
							strDecodeInkPointsData += "index = {0}, X = {1}, Y = {2}, End = {3}\n".format(nIndex, X, Y, END)
						
						if nTotalDecodeInkPointsNumber > 0:
							self.plainTextEdit_EncodeDecodeData.setPlainText(strDecodeInkPointsData)
							self.labelStatus.setText("Decode Ink Points Data : succeeded.")
						else:
							self.labelStatus.setText("Decode Ink Points Data : Failed ! (None of ink data !)")
					else:
						strResult = "Decode Base64 Image (at file path : {0}) : succeeded.".format(wTargetFilePath.value)
						self.labelStatus.setText(strResult)

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_Base64Decode(self.m_nSelectedDeviceID, nIndex, pEncodeBase64Data, wTargetFilePath)
				if nResult == ERROR_ID.RET_PST_SUCCESS.value:
					if nIndex == 6:
						nTotalDecodeInkPointsNumber = PPL501F_GetTotalDecodeInkPointsNumber(self.m_nSelectedDeviceID)
						strDecodeInkPointsData = ''

						for nIndex in range(nTotalDecodeInkPointsNumber):
							X = PPL501F_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 1)
							Y = PPL501F_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 2)
							END = PPL501F_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 3)
							strDecodeInkPointsData += "index = {0}, X = {1}, Y = {2}, End = {3}\n".format(nIndex, X, Y, END)
						
						if nTotalDecodeInkPointsNumber > 0:
							self.plainTextEdit_EncodeDecodeData.setPlainText(strDecodeInkPointsData)
							self.labelStatus.setText("Decode Ink Points Data : succeeded.")
						else:
							self.labelStatus.setText("Decode Ink Points Data : Failed ! (None of ink data !)")
					else:
						strResult = "Decode Base64 Image (at file path : {0}) : succeeded.".format(wTargetFilePath.value)
						self.labelStatus.setText(strResult)

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_Base64Decode(self.m_nSelectedDeviceID, nIndex, pEncodeBase64Data, wTargetFilePath)
				if nResult == ERROR_ID.RET_PST_SUCCESS.value:
					if nIndex == 6:
						nTotalDecodeInkPointsNumber = PPLC700_GetTotalDecodeInkPointsNumber(self.m_nSelectedDeviceID)
						strDecodeInkPointsData = ''

						for nIndex in range(nTotalDecodeInkPointsNumber):
							X = PPLC700_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 1)
							Y = PPLC700_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 2)
							END = PPLC700_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 3)
							strDecodeInkPointsData += "index = {0}, X = {1}, Y = {2}, End = {3}\n".format(nIndex, X, Y, END)
						
						if nTotalDecodeInkPointsNumber > 0:
							self.plainTextEdit_EncodeDecodeData.setPlainText(strDecodeInkPointsData)
							self.labelStatus.setText("Decode Ink Points Data : succeeded.")
						else:
							self.labelStatus.setText("Decode Ink Points Data : Failed ! (None of ink data !)")
					else:
						strResult = "Decode Base64 Image (at file path : {0}) : succeeded.".format(wTargetFilePath.value)
						self.labelStatus.setText(strResult)

			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_Base64Decode(self.m_nSelectedDeviceID, nIndex, pEncodeBase64Data, wTargetFilePath)
				if nResult == ERROR_ID.RET_PST_SUCCESS.value:
					if nIndex == 6:
						nTotalDecodeInkPointsNumber = PPE640_GetTotalDecodeInkPointsNumber(self.m_nSelectedDeviceID)
						strDecodeInkPointsData = ''

						for nIndex in range(nTotalDecodeInkPointsNumber):
							X = PPE640_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 1)
							Y = PPE640_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 2)
							END = PPE640_GetDecodeInkPointData(self.m_nSelectedDeviceID, nIndex, 3)
							strDecodeInkPointsData += "index = {0}, X = {1}, Y = {2}, End = {3}\n".format(nIndex, X, Y, END)
						
						if nTotalDecodeInkPointsNumber > 0:
							self.plainTextEdit_EncodeDecodeData.setPlainText(strDecodeInkPointsData)
							self.labelStatus.setText("Decode Ink Points Data : succeeded.")
						else:
							self.labelStatus.setText("Decode Ink Points Data : Failed ! (None of ink data !)")
					else:
						strResult = "Decode Base64 Image (at file path : {0}) : succeeded.".format(wTargetFilePath.value)
						self.labelStatus.setText(strResult)
		else:
			self.labelStatus.setText("Decode Base64 Image : Failed ! (None of encoded data !)")

	def onAboutButtonClicked(self):
		print('onAboutButtonClicked() enter... ')
		centralWidgetPtr = sip.unwrapinstance(self.centralWidget)
		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			PPL398_AboutBox(centralWidgetPtr)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			PPL500_AboutBox(centralWidgetPtr)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			PPL501F_AboutBox(centralWidgetPtr)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			PPLC700_AboutBox(centralWidgetPtr)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			PPE640_AboutBox(centralWidgetPtr)
			
	def onHWVersionButtonClicked(self):
		print('onHWVersionButtonClicked() enter... ')
		strHWVersion = c_buffer(RX_DEVICE_DATA_MAX_SIZE)  # ansi buffer...
		nResult = ERROR_ID.RET_PST_FAIL.value

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_GetHWVersion(self.m_nSelectedDeviceID, strHWVersion, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_GetHWVersion(self.m_nSelectedDeviceID, strHWVersion, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_GetHWVersion(self.m_nSelectedDeviceID, strHWVersion, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			nResult = PPLC700_GetHWVersion(self.m_nSelectedDeviceID, strHWVersion, RX_DEVICE_DATA_MAX_SIZE)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			nResult = PPE640_GetHWVersion(self.m_nSelectedDeviceID, strHWVersion, RX_DEVICE_DATA_MAX_SIZE)
		
		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			strHWVersionValue = strHWVersion.value.decode('utf-8')
			print('onHWVersionButtonClicked(), strHWVersionValue=' + strHWVersionValue)
			self.labelStatus.setText("HW Version : " + strHWVersionValue)

	def onShowVersionOnDeviceButtonClicked(self):
		print('onShowVersionOnDeviceButtonClicked() enter... ')
		nResult = ERROR_ID.RET_PST_FAIL.value

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			nResult = PPL398_DisplayHWVersion(self.m_nSelectedDeviceID, self.m_bShowHWVersion)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			nResult = PPL500_DisplayHWVersion(self.m_nSelectedDeviceID, self.m_bShowHWVersion)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			nResult = PPL501F_DisplayHWVersion(self.m_nSelectedDeviceID, self.m_bShowHWVersion)
		
		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			if self.m_bShowHWVersion == True:
				self.labelStatus.setText("Show Version On Device : succeeded.")
			else:
				self.labelStatus.setText("Hide Version On Device : succeeded.")
		self.m_bShowHWVersion = not self.m_bShowHWVersion

	def onGetDeviceInfoButtonClicked(self):
		print('onGetDeviceInfoButtonClicked() enter... ')
		nIndex = self.cbGetDeviceInfo.currentIndex() + 1
		nResult = ERROR_ID.RET_PST_FAIL.value
		if nIndex == 1:
			bDeviceConnected = c_bool()
			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, bDeviceConnected)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, bDeviceConnected)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, bDeviceConnected)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, bDeviceConnected)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, bDeviceConnected)
			
			if nResult == ERROR_ID.RET_PST_SUCCESS.value:
				self.labelStatus.setText("Get Device Info (Device Connection) : " + str(bDeviceConnected.value))
			else:
				self.labelStatus.setText("Get Device Info (Device Connection) Failed ! (" + str(nResult) + ")")
		elif nIndex == 2:
			ppAxis_X = PPAXIS(0, 0)
			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_X)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_X)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_X)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_X)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_X)
			
			if nResult == ERROR_ID.RET_PST_SUCCESS.value:
				strResult = 'Get Device Info (Device X Range) : {0} - {1}'.format(ppAxis_X.axMin, ppAxis_X.axMax)
				self.labelStatus.setText(strResult)
			else:
				self.labelStatus.setText("Get Device Info (Device X Range) Failed ! (" + str(nResult) + ")")
		elif nIndex == 3:
			ppAxis_Y = PPAXIS(0, 0)
			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_Y)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_Y)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_Y)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_Y)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, ppAxis_Y)
			
			if nResult == ERROR_ID.RET_PST_SUCCESS.value:
				strResult = 'Get Device Info (Device Y Range) : {0} - {1}'.format(ppAxis_Y.axMin, ppAxis_Y.axMax)
				self.labelStatus.setText(strResult)
			else:
				self.labelStatus.setText("Get Device Info (Device Y Range) Failed ! (" + str(nResult) + ")")
		elif nIndex == 4:
			nPressure = c_int32()
			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, nPressure)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, nPressure)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, nPressure)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, nPressure)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, nPressure)
			
			if nResult == ERROR_ID.RET_PST_SUCCESS.value:
				strResult = 'Get Device Info (Device Pressure Range) : {0}'.format(nPressure.value)
				self.labelStatus.setText(strResult)
			else:
				self.labelStatus.setText("Get Device Info (Device Pressure Range) Failed ! (" + str(nResult) + ")")
		elif nIndex == 5:
			strVendor = c_buffer(MAX_PATH)  # ansi buffer...
			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strVendor)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strVendor)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strVendor)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strVendor)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strVendor)
			
			if nResult == ERROR_ID.RET_PST_SUCCESS.value:
				strVendorValue = strVendor.value.decode()
				strResult = 'Get Device Info (Device Vendor) : {0}'.format(strVendorValue)
				self.labelStatus.setText(strResult)
			else:
				self.labelStatus.setText("Get Device Info (Device Vendor) Failed ! (" + str(nResult) + ")")
		elif nIndex == 6:
			strProduct = c_buffer(MAX_PATH)  # ansi buffer...
			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strProduct)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strProduct)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strProduct)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strProduct)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, strProduct)
			
			if nResult == ERROR_ID.RET_PST_SUCCESS.value:
				strProductValue = strProduct.value.decode()
				strResult = 'Get Device Info (Device Product Name) : {0}'.format(strProductValue)
				self.labelStatus.setText(strResult)
			else:
				self.labelStatus.setText("Get Device Info (Device Product Name) Failed ! (" + str(nResult) + ")")
		elif nIndex == 7:
			sdkVersion = PPSDKVERSION(0, 0)
			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, sdkVersion)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, sdkVersion)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, sdkVersion)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, sdkVersion)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_GetDeviceInfo(self.m_nSelectedDeviceID, nIndex, sdkVersion)
			
			if nResult == ERROR_ID.RET_PST_SUCCESS.value:
				strResult = 'Get Device Info (Device SDK Version) : {0}.{1}'.format(sdkVersion.sdkVerMajor, sdkVersion.sdkVerMinor)
				self.labelStatus.setText(strResult)
			else:
				self.labelStatus.setText("Get Device Info (Device SDK Version) Failed ! (" + str(nResult) + ")")

	def onSetClipMarginButtonClicked(self):
		print('onSetClipMarginButtonClicked() enter... ')
		nClipMarginX = int(self.lineEdit_SetClipMarginWidth.text())
		nClipMarginY = int(self.lineEdit_SetClipMarginHeight.text())
		nResult = ERROR_ID.RET_PST_FAIL.value

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			if (nClipMarginX == 0) and (nClipMarginY == 0):
				nResult = PPL398_SetSaveClipImageMargin(self.m_nSelectedDeviceID, False, nClipMarginX, nClipMarginY)
			else:
				nResult = PPL398_SetSaveClipImageMargin(self.m_nSelectedDeviceID, True, nClipMarginX, nClipMarginY)

		if nResult == ERROR_ID.RET_PST_SUCCESS.value:
			self.labelStatus.setText("Set Clip Image Margin : succeeded.")
		else:
			self.labelStatus.setText("Set Clip Image Margin : Failed ! (" + str(nResult) + ")")

	def onSaveDrawingImageButtonClicked(self):
		print('onSaveDrawingImageButtonClicked() enter... ')
		nIndex = self.cbSaveDrawingImage.currentIndex()
		if nIndex >= 0:
			nIndex += 1
			if nIndex >= 4:
				nIndex += 3

			strTargetFilePath = ""
			if nIndex == 1:
				strTargetFilePath = "/tmp/test.bmp"
			elif nIndex == 2:
				strTargetFilePath = "/tmp/test.jpg"
			elif nIndex == 3:
				strTargetFilePath = "/tmp/test.png"
			elif nIndex == 7:
				strTargetFilePath = "/tmp/test.pdf"
			elif nIndex == 8:
				strTargetFilePath = "/tmp/test.svg"

			wTargetFilePath = create_unicode_buffer(strTargetFilePath)
			nCurrentDPIIndex = self.cbSaveDrawingImageDPI.currentIndex()
			nResult = ERROR_ID.RET_PST_FAIL.value

			if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
				nResult = PPL398_SaveDrawingImage(self.m_nSelectedDeviceID, nIndex, wTargetFilePath, nCurrentDPIIndex)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
				nResult = PPL500_SaveDrawingImage(self.m_nSelectedDeviceID, nIndex, wTargetFilePath, nCurrentDPIIndex)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
				nResult = PPL501F_SaveDrawingImage(self.m_nSelectedDeviceID, nIndex, wTargetFilePath, nCurrentDPIIndex)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
				nResult = PPLC700_SaveDrawingImage(self.m_nSelectedDeviceID, nIndex, wTargetFilePath, nCurrentDPIIndex)
			elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
				nResult = PPE640_SaveDrawingImage(self.m_nSelectedDeviceID, nIndex, wTargetFilePath, nCurrentDPIIndex)

			if nResult == ERROR_ID.RET_PST_SUCCESS.value:
				strResult = "Save Drawing Image (at file path : {0}) : succeeded.".format(wTargetFilePath.value)
				self.labelStatus.setText(strResult)
			else:
				self.labelStatus.setText("Save Drawing Image : Failed ! (" + str(nResult) + ")")

	def initial(self, MainWindow):
		self.m_bShowHWVersion = True
		
		# init all buttons click event...
		self.InitButton.clicked.connect(self.onInitButtonClicked)
		self.UnInitButton.clicked.connect(self.onUnInitButtonClicked)
		self.OpenLCDButton.clicked.connect(self.onOpenLCDButtonClicked)
		self.CloseLCDButton.clicked.connect(self.onCloseLCDButtonClicked)
		self.ClearButton.clicked.connect(self.onClearButtonClicked)
		self.GetSizeButton.clicked.connect(self.onGetSizeButtonClicked)
		self.GetPointButton.clicked.connect(self.onGetPointButtonClicked)
		self.PenIDButton.clicked.connect(self.onPenIDButtonClicked)
		self.PadIDButton.clicked.connect(self.onPadIDButtonClicked)
		self.EncodeButton.clicked.connect(self.onEncodeButtonClicked)
		self.DecodeButton.clicked.connect(self.onDecodeButtonClicked)
		self.AboutButton.clicked.connect(self.onAboutButtonClicked)
		self.HWVersionButton.clicked.connect(self.onHWVersionButtonClicked)
		self.ShowVersionOnDeviceButton.clicked.connect(self.onShowVersionOnDeviceButtonClicked)
		self.GetDeviceInfoButton.clicked.connect(self.onGetDeviceInfoButtonClicked)
		self.SetClipMarginButton.clicked.connect(self.onSetClipMarginButtonClicked)
		self.SaveDrawingImageButton.clicked.connect(self.onSaveDrawingImageButtonClicked)

		# init cbSelectDevice/cbPenStyle/cbPenWidth/cbPenColor combobox index changed event...
		self.cbSelectDevice.currentIndexChanged.connect(self.onCBSelectDeviceIndexChanged)
		self.cbPenStyle.currentIndexChanged.connect(self.onCBPenStyleIndexChanged)
		self.cbPenWidth.currentIndexChanged.connect(self.onCBPenWidthIndexChanged)
		self.cbPenColor.currentIndexChanged.connect(self.onCBPenColorIndexChanged)

		# disable all buttons except label, cbSelectDevice, InitButton...
		self.UnInitButton.setEnabled(False)
		self.OpenLCDButton.setEnabled(False)
		self.CloseLCDButton.setEnabled(False)
		self.ClearButton.setEnabled(False)
		self.GetSizeButton.setEnabled(False)
		self.GetPointButton.setEnabled(False)
		self.cbGetPoint.setEnabled(False)
		self.PenIDButton.setEnabled(False)
		self.PadIDButton.setEnabled(False)
		self.EncodeButton.setEnabled(False)
		self.cbEncode.setEnabled(False)
		self.DecodeButton.setEnabled(False)
		self.AboutButton.setEnabled(False)
		self.HWVersionButton.setEnabled(False)
		self.ShowVersionOnDeviceButton.setEnabled(False)
		self.cbPenStyle.setEnabled(False)
		self.cbPenWidth.setEnabled(False)
		self.GetDeviceInfoButton.setEnabled(False)
		self.cbGetDeviceInfo.setEnabled(False)
		self.SetClipMarginButton.setEnabled(False)
		self.lineEdit_SetClipMarginWidth.setEnabled(False)
		self.lineEdit_SetClipMarginHeight.setEnabled(False)
		self.SaveDrawingImageButton.setEnabled(False)
		self.cbSaveDrawingImage.setEnabled(False)
		self.cbSaveDrawingImageDPI.setEnabled(False)
		self.label_2.setEnabled(False)
		self.label_3.setEnabled(False)
		self.label_4.setEnabled(False)
		self.groupBox.setEnabled(False)
		self.plainTextEdit_EncodeDecodeData.setEnabled(False)
		self.cbPenColor.setEnabled(False)

		# init Select Device combobox...
		self.cbSelectDevice.addItem("E550/E560")
		self.cbSelectDevice.addItem("L370/L398")
		self.cbSelectDevice.addItem("L500")
		self.cbSelectDevice.addItem("L501G")
		self.cbSelectDevice.addItem("LC700")
		self.cbSelectDevice.addItem("E640")
		self.cbSelectDevice.setCurrentIndex(0)
		self.m_nSelectedDeviceID = DEVICE_TYPE_ID.PPL398_DEVICE.value

		# initial encode combobox...
		self.cbEncode.addItem("BMP")
		self.cbEncode.addItem("JPG")
		self.cbEncode.addItem("PNG")
		self.cbEncode.addItem("INK")
		self.cbEncode.setCurrentIndex(0)

		# initial Pen Style combobox...
		self.cbPenStyle.addItem("Presssure sensitivity")
		self.cbPenStyle.addItem("Fixed width")
		self.cbPenStyle.setCurrentIndex(0)

		# initial Pen Width combobox...
		for i in range(10):
			self.cbPenWidth.addItem(str(i + 1))
		self.cbPenWidth.setCurrentIndex(2)

		# initial Pen Color combobox...
		self.cbPenColor.addItem("Black")
		self.cbPenColor.addItem("Red")
		self.cbPenColor.addItem("Green")
		self.cbPenColor.addItem("Blue")
		self.cbPenColor.addItem("Yellow")
		self.cbPenColor.setCurrentIndex(0)

		# initial Get Device Info combobox...
		for i in range(7):		
			self.cbGetDeviceInfo.addItem(str(i + 1))
		self.cbGetDeviceInfo.setCurrentIndex(0)

		# initial Save Drawing Image combobox...
		self.cbSaveDrawingImage.addItem("BMP")
		self.cbSaveDrawingImage.addItem("JPG")
		self.cbSaveDrawingImage.addItem("PNG")
		self.cbSaveDrawingImage.addItem("PDF")
		self.cbSaveDrawingImage.addItem("SVG")
		self.cbSaveDrawingImage.setCurrentIndex(0)

		# initial Save Drawing Image DPI combobox...
		self.cbSaveDrawingImageDPI.addItem("150 DPI")
		self.cbSaveDrawingImageDPI.addItem("300 DPI")
		self.cbSaveDrawingImageDPI.setCurrentIndex(0)

		# set lineEdit_SetClipMarginWidth/lineEdit_SetClipMarginHeight as number only...
		self.lineEdit_SetClipMarginWidth.setValidator(QIntValidator(0, 100, MainWindow))
		self.lineEdit_SetClipMarginHeight.setValidator(QIntValidator(0, 100, MainWindow))

		# center window on primary screen...
		screen_rect = QDesktopWidget().availableGeometry()
		window_size = MainWindow.size()
		x = (screen_rect.width() - window_size.width()) // 2
		y = (screen_rect.height() - window_size.height()) // 2
		MainWindow.move(x, y)

		# update selected device id...
		MainWindow.updateSelectedDeviceID(self.m_nSelectedDeviceID)

	def ProcessSignPadEvent(self, nStatus):
		print('ProcessSignPadEvent(), nStatus = {0}'.format(nStatus))
		if nStatus == SIGNPAD_CONFIRM_BUTTON:
			print('ProcessSignPadEvent(), click [Confirm] key on SignPad !')
			self.labelStatus.setText("click [Confirm] key on SignPad !")
		elif nStatus == SIGNPAD_CANCEL_BUTTON:
			print('ProcessSignPadEvent(), click [Cancel] key on SignPad !')
			self.labelStatus.setText("click [Cancel] key on SignPad !")

		if self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL398_DEVICE.value:
			PPL398_Clear(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL500_DEVICE.value:
			PPL500_Clear(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPL501F_DEVICE.value:
			PPL501F_Clear(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPLC700_DEVICE.value:
			PPLC700_Clear(self.m_nSelectedDeviceID)
		elif self.m_nSelectedDeviceID == DEVICE_TYPE_ID.PPE640_DEVICE.value:
			PPE640_Clear(self.m_nSelectedDeviceID)

if __name__ == "__main__":
	app = QtWidgets.QApplication(sys.argv)
	MainWindow = MyMainWindow()
	ui = Ui_MainWindow()
	ui.setupUi(MainWindow)
	g_UiMainWndInstance = ui
	MainWindow.show()
	sys.exit(app.exec_())
